/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.common.reflection;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class ClassLoaderUtil {
    private static final String CLASS_FILE_NAME_EXTENSION = ".class";

    public static boolean isClassFile(String resourceName) {
        return resourceName.endsWith(CLASS_FILE_NAME_EXTENSION);
    }

    public static String classToResource(String className) {
        if (className == null) {
            return null;
        }
        return className.replace('.', '/') + CLASS_FILE_NAME_EXTENSION;
    }

    public static String classToResource(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassLoaderUtil.classToResource(clazz.getName());
    }

    public static String classToSlashed(String className) {
        if (className == null) {
            return null;
        }
        return className.replace('.', '/');
    }

    public static String classToSlashed(Class<?> clazz) {
        if (clazz == null) {
            return null;
        }
        return ClassLoaderUtil.classToSlashed(clazz.getName());
    }

    public static String resourceToClass(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        return ClassLoaderUtil.resourceToSlashed(resourceName).replace('/', '.');
    }

    public static String resourceToSlashed(String resourceName) {
        if (resourceName == null) {
            return null;
        }
        if (!resourceName.endsWith(CLASS_FILE_NAME_EXTENSION)) {
            throw new IllegalArgumentException("Resource " + resourceName + " is not a class file");
        }
        return resourceName.substring(0, resourceName.length() - CLASS_FILE_NAME_EXTENSION.length());
    }

    public static void accept(URLClassLoader ucl, Visitor visitor) throws IOException {
        ClassLoaderUtil.accept(ucl, ucl.getURLs(), visitor);
    }

    public static void accept(ClassLoader cl, URL[] urls, Visitor visitor) throws IOException {
        try {
            HashSet<URI> scannedUris = new HashSet<URI>();
            for (URL entry : urls) {
                URI uri = entry.toURI();
                if (!uri.getScheme().equals("file") || !scannedUris.add(uri)) continue;
                ClassLoaderUtil.scanFrom(new File(uri), cl, scannedUris, visitor);
            }
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    private static void scan(URI uri, ClassLoader classloader, Set<URI> scannedUris, Visitor visitor) throws IOException {
        if (uri.getScheme().equals("file") && scannedUris.add(uri)) {
            ClassLoaderUtil.scanFrom(new File(uri), classloader, scannedUris, visitor);
        }
    }

    private static void scanFrom(File file, ClassLoader classloader, Set<URI> scannedUris, Visitor visitor) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            ClassLoaderUtil.scanDirectory(file, classloader, visitor);
        } else {
            ClassLoaderUtil.scanJar(file, classloader, scannedUris, visitor);
        }
    }

    private static void scanDirectory(File directory, ClassLoader classloader, Visitor visitor) throws IOException {
        ClassLoaderUtil.scanDirectory(directory, classloader, "", new HashSet<File>(), visitor);
    }

    private static void scanDirectory(File directory, ClassLoader classloader, String packagePrefix, Set<File> ancestors, Visitor visitor) throws IOException {
        File canonical = directory.getCanonicalFile();
        if (ancestors.contains(canonical)) {
            return;
        }
        File[] files = directory.listFiles();
        if (files == null) {
            return;
        }
        HashSet<File> newAncestors = new HashSet<File>();
        newAncestors.addAll(ancestors);
        newAncestors.add(canonical);
        for (File f : files) {
            String name = f.getName();
            if (f.isDirectory()) {
                ClassLoaderUtil.scanDirectory(f, classloader, packagePrefix + name + "/", newAncestors, visitor);
                continue;
            }
            String resourceName = packagePrefix + name;
            if (resourceName.equals("META-INF/MANIFEST.MF")) continue;
            visitor.visit(resourceName, f.toURI().toURL(), classloader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void scanJar(File file, ClassLoader classloader, Set<URI> scannedUris, Visitor visitor) throws IOException {
        JarFile jarFile;
        try {
            jarFile = new JarFile(file);
        }
        catch (IOException e) {
            return;
        }
        try {
            for (URI uri : ClassLoaderUtil.getClassPathFromManifest(file, jarFile.getManifest())) {
                ClassLoaderUtil.scan(uri, classloader, scannedUris, visitor);
            }
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (entry.isDirectory() || entry.getName().equals("META-INF/MANIFEST.MF")) continue;
                visitor.visit(entry.getName(), new URL("jar:file:" + file.getCanonicalPath() + "!/" + entry.getName()), classloader);
            }
        }
        finally {
            try {
                jarFile.close();
            }
            catch (IOException iOException) {}
        }
    }

    private static Set<URI> getClassPathFromManifest(File jarFile, Manifest manifest) {
        if (manifest == null) {
            return new HashSet<URI>();
        }
        HashSet<URI> s = new HashSet<URI>();
        String classpathAttribute = manifest.getMainAttributes().getValue(Attributes.Name.CLASS_PATH.toString());
        if (classpathAttribute != null) {
            for (String path : classpathAttribute.split("\\s")) {
                URI uri;
                if (path == null || path.trim().length() <= 0) continue;
                try {
                    uri = ClassLoaderUtil.getClassPathEntry(jarFile, path.trim());
                }
                catch (URISyntaxException e) {
                    continue;
                }
                s.add(uri);
            }
        }
        return s;
    }

    private static URI getClassPathEntry(File jarFile, String path) throws URISyntaxException {
        URI uri = new URI(path);
        if (uri.isAbsolute()) {
            return uri;
        }
        return new File(jarFile.getParentFile(), path.replace('/', File.separatorChar)).toURI();
    }

    private ClassLoaderUtil() {
    }

    public static interface Visitor {
        public void visit(String var1, URL var2, ClassLoader var3) throws IOException;
    }
}

