/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.fibers;

import co.paralleluniverse.common.util.SystemProperties;
import co.paralleluniverse.concurrent.util.DelayQueue;
import co.paralleluniverse.concurrent.util.SingleConsumerNonblockingProducerDelayQueue;
import co.paralleluniverse.fibers.Fiber;
import co.paralleluniverse.fibers.FiberScheduler;
import co.paralleluniverse.fibers.FibersMonitor;
import co.paralleluniverse.strands.Strand;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;

public class FiberTimedScheduler {
    private static final boolean USE_LOCKFREE_DELAY_QUEUE = SystemProperties.isEmptyOrTrue("co.paralleluniverse.fibers.useLockFreeDelayQueue");
    private static final boolean DETECT_RUNAWAY_FIBERS = SystemProperties.isNotFalse("co.paralleluniverse.fibers.detectRunawayFibers");
    private static final long MAX_RUN_DURATION = TimeUnit.NANOSECONDS.convert(200L, TimeUnit.MILLISECONDS);
    private static final boolean BACKPRESSURE = true;
    private static final int BACKPRESSURE_MASK = 1023;
    private static final int BACKPRESSURE_THRESHOLD = 1200;
    private static final int BACKPRESSURE_PAUSE_MS = 1;
    private static final AtomicInteger nameSuffixSequence = new AtomicInteger();
    private final Thread worker;
    private final BlockingQueue<ScheduledFutureTask> workQueue;
    private static final int RUNNING = 0;
    private static final int SHUTDOWN = 1;
    private static final int STOP = 1;
    private static final int TERMINATED = 2;
    private volatile int state = 0;
    private final ReentrantLock mainLock = new ReentrantLock();
    private final FiberScheduler scheduler;
    private final FibersMonitor monitor;
    private Map<Thread, FiberInfo> fibersInfo = new IdentityHashMap<Thread, FiberInfo>();

    public FiberTimedScheduler(FiberScheduler scheduler, ThreadFactory threadFactory, FibersMonitor monitor) {
        this.scheduler = scheduler;
        this.worker = threadFactory.newThread(new Runnable(){

            @Override
            public void run() {
                FiberTimedScheduler.this.work();
            }
        });
        this.workQueue = USE_LOCKFREE_DELAY_QUEUE ? new SingleConsumerNonblockingProducerDelayQueue() : new DelayQueue();
        this.monitor = monitor;
        this.worker.start();
    }

    public FiberTimedScheduler(FiberScheduler scheduler, FibersMonitor monitor) {
        this(scheduler, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, "FiberTimedScheduler-" + nameSuffixSequence.incrementAndGet());
                t.setDaemon(true);
                return t;
            }
        }, monitor);
    }

    public FiberTimedScheduler(FiberScheduler scheduler) {
        this(scheduler, null);
    }

    public Future<Void> schedule(Fiber<?> fiber, Object blocker, long delay, TimeUnit unit) {
        if (fiber == null || unit == null) {
            throw new NullPointerException();
        }
        assert (fiber.getScheduler() == this.scheduler);
        ScheduledFutureTask t = new ScheduledFutureTask(fiber, blocker, this.triggerTime(delay, unit));
        this.delayedExecute(t);
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void work() {
        block16: {
            try {
                ScheduledFutureTask task;
                int counter = 0;
                long lastRanFindProblemFibers = 0L;
                while (this.state == 0) {
                    block15: {
                        try {
                            long now;
                            task = this.workQueue.poll(MAX_RUN_DURATION >>> 1, TimeUnit.NANOSECONDS);
                            if (task != null && !task.isCancelled()) {
                                long delay = task.delay;
                                if ((counter & 0x3FF) == 0) {
                                    while (this.scheduler.getQueueLength() > 1200) {
                                        Thread.sleep(1L);
                                    }
                                    delay = this.now() - task.time;
                                }
                                if (this.monitor != null) {
                                    this.monitor.timedParkLatency(delay);
                                }
                                this.run(task);
                            }
                            if (!DETECT_RUNAWAY_FIBERS || (now = System.nanoTime()) - lastRanFindProblemFibers < MAX_RUN_DURATION >>> 1) break block15;
                            this.reportProblemFibers(this.findProblemFibers(now, MAX_RUN_DURATION));
                            lastRanFindProblemFibers = now;
                        }
                        catch (InterruptedException e) {
                            if (this.state == 0) break block15;
                            this.state = 1;
                            break;
                        }
                    }
                    ++counter;
                }
                if (this.state != 1) break block16;
                while (this.state < 1 && !this.workQueue.isEmpty()) {
                    try {
                        task = this.workQueue.take();
                        if (task.isCancelled()) continue;
                        this.run(task);
                    }
                    catch (InterruptedException e) {
                        if (this.state == 0) continue;
                        this.state = 1;
                        break;
                    }
                }
            }
            catch (Exception e) {
                System.err.println("FiberTimedScheduler terminated!");
                e.printStackTrace();
            }
            finally {
                this.state = 2;
            }
        }
    }

    public int getQueueLength() {
        return this.workQueue.size();
    }

    private void run(ScheduledFutureTask task) {
        try {
            Fiber<?> fiber = task.fiber;
            fiber.unpark(task.blocker);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    final long now() {
        return System.nanoTime();
    }

    final boolean isRunningOrShutdown(boolean shutdownOK) {
        int rs = this.state;
        return rs == 0 || rs == 1 && shutdownOK;
    }

    private void delayedExecute(ScheduledFutureTask task) {
        if (this.isShutdown()) {
            this.reject(task);
        } else {
            this.workQueue.add(task);
        }
    }

    protected void reject(Object command) {
        throw new RejectedExecutionException("Task " + command + " rejected from " + this);
    }

    private long triggerTime(long delay, TimeUnit unit) {
        return this.triggerTime(unit.toNanos(delay < 0L ? 0L : delay));
    }

    private long triggerTime(long delay) {
        return this.now() + (delay < 0x3FFFFFFFFFFFFFFFL ? delay : this.overflowFree(delay));
    }

    private long overflowFree(long delay) {
        long headDelay;
        Delayed head = (Delayed)this.workQueue.peek();
        if (head != null && (headDelay = head.getDelay(TimeUnit.NANOSECONDS)) < 0L && delay - headDelay < 0L) {
            delay = Long.MAX_VALUE + headDelay;
        }
        return delay;
    }

    public void shutdown() {
        assert (false);
        this.mainLock.lock();
        try {
            if (this.state < 1) {
                this.state = 1;
            }
        }
        finally {
            this.mainLock.unlock();
        }
    }

    public void shutdownNow() {
        assert (false);
        this.mainLock.lock();
        try {
            if (this.state < 1) {
                this.state = 1;
            }
            this.worker.interrupt();
        }
        finally {
            this.mainLock.unlock();
        }
    }

    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        long nanos = unit.toNanos(timeout);
        long millis = TimeUnit.MILLISECONDS.convert(nanos, TimeUnit.NANOSECONDS);
        this.worker.join(millis, (int)(nanos - millis));
        return !this.worker.isAlive();
    }

    public boolean isShutdown() {
        return this.state >= 1;
    }

    public boolean isTerminated() {
        return !this.worker.isAlive();
    }

    private Collection<Fiber> findProblemFibers(long now, long nanos) {
        ArrayList<Fiber> pfs = new ArrayList<Fiber>();
        Map<Thread, Fiber> fibs = this.scheduler.getRunningFibers();
        if (fibs == null) {
            return null;
        }
        this.fibersInfo.keySet().retainAll(fibs.keySet());
        for (Map.Entry<Thread, Fiber> entry : fibs.entrySet()) {
            long run;
            Thread t = entry.getKey();
            Fiber f = entry.getValue();
            if (f != null) {
                f.getState();
            }
            FiberInfo fi = this.fibersInfo.get(t);
            long l = run = f != null ? f.getRun() : 0L;
            if (fi == null) {
                this.fibersInfo.put(t, new FiberInfo(f, run, f != null ? now : -1L));
                continue;
            }
            if (fi.fiber != f | fi.run != run) {
                fi.set(f, run, f != null ? now : -1L);
                continue;
            }
            if (!(f != null & now - fi.time > nanos)) continue;
            pfs.add(f);
        }
        return pfs;
    }

    private void reportProblemFibers(Collection<Fiber> fs) {
        this.scheduler.getMonitor().setRunawayFibers(fs);
        if (fs == null) {
            return;
        }
        block0: for (Fiber f : fs) {
            Thread t = f.getRunningThread();
            StackTraceElement[] stackTrace = f.getStackTrace();
            if (stackTrace != null) {
                for (StackTraceElement ste : stackTrace) {
                    if ("defineClass".equals(ste.getMethodName()) && "java.lang.ClassLoader".equals(ste.getClassName()) || "loadClass".equals(ste.getMethodName()) && "java.lang.ClassLoader".equals(ste.getClassName()) || "forName".equals(ste.getMethodName()) && "java.lang.Class".equals(ste.getClassName())) continue block0;
                }
            }
            if (t == null || t.getState() == Thread.State.RUNNABLE) {
                System.err.println("WARNING: fiber " + f + " is hogging the CPU or blocking a thread.");
            } else {
                System.err.println("WARNING: fiber " + f + " is blocking a thread (" + t + ").");
            }
            Strand.printStackTrace(stackTrace, System.err);
        }
    }

    private static class FiberInfo {
        Fiber fiber;
        long run;
        long time;

        FiberInfo(Fiber fiber, long run, long time) {
            this.set(fiber, run, time);
        }

        final void set(Fiber fiber, long run, long time) {
            this.fiber = fiber;
            this.run = run;
            this.time = time;
        }
    }

    private class ScheduledFutureTask
    implements Delayed,
    Future<Void> {
        final Fiber<?> fiber;
        final Object blocker;
        final long time;
        private volatile boolean cancelled = false;
        long delay;

        ScheduledFutureTask(Fiber<?> fiber, Object blocker, long ns) {
            this.fiber = fiber;
            this.blocker = blocker;
            this.time = ns;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            long d = unit.convert(this.time - FiberTimedScheduler.this.now(), TimeUnit.NANOSECONDS);
            this.delay = -d;
            return d;
        }

        @Override
        public int compareTo(Delayed other) {
            if (other == this) {
                return 0;
            }
            ScheduledFutureTask x = (ScheduledFutureTask)other;
            long diff = this.time - x.time;
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancelled = true;
            return true;
        }

        @Override
        public boolean isCancelled() {
            return this.cancelled;
        }

        @Override
        public boolean isDone() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Void get() throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return "Timeout(" + this.blocker + ')';
        }
    }
}

