/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.io.serialization.kryo;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Registration;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.serializers.FieldSerializer;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;

public class ReplaceableObjectKryo
extends Kryo {
    private static final ClassValue<SerializationMethods> replaceMethodsCache = new ClassValue<SerializationMethods>(){

        @Override
        protected SerializationMethods computeValue(Class<?> type) {
            return new SerializationMethods(ReplaceableObjectKryo.getMethodByReflection(type, ReplaceableObjectKryo.WRITE_REPLACE, new Class[0]), ReplaceableObjectKryo.getMethodByReflection(type, ReplaceableObjectKryo.READ_RESOLVE, new Class[0]));
        }
    };
    private static final String WRITE_REPLACE = "writeReplace";
    private static final String READ_RESOLVE = "readResolve";

    public void writeClassAndObject(Output output, Object object) {
        if (output == null) {
            throw new IllegalArgumentException("output cannot be null.");
        }
        if (object == null) {
            super.writeClass(output, null);
            return;
        }
        Object newObj = ReplaceableObjectKryo.getReplacement(ReplaceableObjectKryo.getMethods(object.getClass()).writeReplace, object);
        this.setAutoReset(false);
        Registration registration = super.writeClass(output, newObj.getClass());
        this.setAutoReset(true);
        super.writeObject(output, newObj, registration.getSerializer());
    }

    protected Serializer newDefaultSerializer(Class type) {
        Serializer s = super.newDefaultSerializer(type);
        if (s instanceof FieldSerializer) {
            ((FieldSerializer)s).setIgnoreSyntheticFields(false);
        }
        return s;
    }

    public Registration writeClass(Output output, Class type) {
        if (type == null || ReplaceableObjectKryo.getMethods((Class)type).writeReplace == null) {
            return super.writeClass(output, type);
        }
        return super.getRegistration(type);
    }

    public void writeObject(Output output, Object object, Serializer serializer) {
        Method m = ReplaceableObjectKryo.getMethods(object.getClass()).writeReplace;
        if (m != null) {
            object = ReplaceableObjectKryo.getReplacement(m, object);
            Registration reg = super.writeClass(output, object.getClass());
            serializer = reg.getSerializer();
        }
        super.writeObject(output, object, serializer);
    }

    public <T> T readObject(Input input, Class<T> type, Serializer serializer) {
        return this.readReplace(super.readObject(input, type, serializer));
    }

    public <T> T readObject(Input input, Class<T> type) {
        return this.readReplace(super.readObject(input, type));
    }

    public <T> T readObjectOrNull(Input input, Class<T> type) {
        return this.readReplace(super.readObjectOrNull(input, type));
    }

    public <T> T readObjectOrNull(Input input, Class<T> type, Serializer serializer) {
        return this.readReplace(super.readObjectOrNull(input, type, serializer));
    }

    public Object readClassAndObject(Input input) {
        return this.readReplace(super.readClassAndObject(input));
    }

    private <T> T readReplace(Object obj) {
        if (obj == null) {
            return null;
        }
        return (T)ReplaceableObjectKryo.getReplacement(ReplaceableObjectKryo.getMethods(obj.getClass()).readResolve, obj);
    }

    private static Object getReplacement(Method m, Object object) {
        if (m == null) {
            return object;
        }
        try {
            return m.invoke(object, new Object[0]);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e.getCause());
        }
    }

    private static SerializationMethods getMethods(Class clazz) {
        return replaceMethodsCache.get(clazz);
    }

    private static Method getMethodByReflection(Class clazz, String methodName, Class<?> ... paramTypes) throws SecurityException {
        if (!Serializable.class.isAssignableFrom(clazz)) {
            return null;
        }
        Method m = null;
        try {
            m = clazz.getDeclaredMethod(methodName, paramTypes);
        }
        catch (NoSuchMethodException ex) {
            for (Class ancestor = clazz.getSuperclass(); ancestor != null; ancestor = ancestor.getSuperclass()) {
                if (!Serializable.class.isAssignableFrom(ancestor)) {
                    return null;
                }
                try {
                    m = ancestor.getDeclaredMethod(methodName, paramTypes);
                    if (!Modifier.isPublic(m.getModifiers()) && !Modifier.isProtected(m.getModifiers())) {
                        return null;
                    }
                    break;
                }
                catch (NoSuchMethodException ex1) {
                    continue;
                }
            }
        }
        if (m != null) {
            m.setAccessible(true);
        }
        return m;
    }

    private static class SerializationMethods {
        Method writeReplace;
        Method readResolve;

        public SerializationMethods(Method writeReplace, Method readResolve) {
            this.writeReplace = writeReplace;
            this.readResolve = readResolve;
        }
    }
}

