/*
 * Decompiled with CFR 0.152.
 */
package co.paralleluniverse.strands.channels;

import co.paralleluniverse.common.util.Function2;
import co.paralleluniverse.fibers.Instrumented;
import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.strands.Timeout;
import co.paralleluniverse.strands.channels.ReceivePort;
import co.paralleluniverse.strands.channels.ReceivePortTransformer;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;

@Instrumented
class ReducingReceivePort<S, T>
extends ReceivePortTransformer<S, T>
implements ReceivePort<T> {
    private final Function2<T, S, T> f;
    private final AtomicBoolean receivedAtLeastOnce = new AtomicBoolean(false);
    private T prev;

    public ReducingReceivePort(ReceivePort<S> target, Function2<T, S, T> f, T init) {
        super(target);
        this.f = f;
        this.prev = init;
    }

    @Override
    public T tryReceive() {
        return this.checkReceivedAtLeastOnce(super.tryReceive());
    }

    @Override
    public boolean isClosed() {
        return super.isClosed() && this.receivedAtLeastOnce.get();
    }

    @Override
    protected T transform(S m) {
        this.prev = this.reduce(this.prev, m);
        return this.prev;
    }

    private T reduce(T prev, S m) {
        if (this.f != null && prev != null) {
            return this.f.apply(prev, m);
        }
        throw new UnsupportedOperationException();
    }

    private T checkReceivedAtLeastOnce(T r) {
        T ret = r;
        if (this.target.isClosed() && !this.receivedAtLeastOnce.get()) {
            ret = this.prev;
        }
        this.receivedAtLeastOnce.set(true);
        return ret;
    }

    @Override
    @Instrumented(suspendableCallSites={40}, methodStart=40, methodEnd=40, methodOptimized=true)
    public T receive(Timeout timeout) throws SuspendExecution, InterruptedException {
        return this.checkReceivedAtLeastOnce(super.receive(timeout));
    }

    @Override
    @Instrumented(suspendableCallSites={50}, methodStart=50, methodEnd=50, methodOptimized=true)
    public T receive() throws SuspendExecution, InterruptedException {
        return this.checkReceivedAtLeastOnce(super.receive());
    }

    @Override
    @Instrumented(suspendableCallSites={60}, methodStart=60, methodEnd=60, methodOptimized=true)
    public T receive(long timeout, TimeUnit unit) throws SuspendExecution, InterruptedException {
        return this.checkReceivedAtLeastOnce(super.receive(timeout, unit));
    }
}

