/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.impl.NoStackTraceThrowable;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.mail.MailConfig;
import io.vertx.ext.mail.MailMessage;
import io.vertx.ext.mail.MailResult;
import io.vertx.ext.mail.impl.SMTPConnection;
import io.vertx.ext.mail.impl.StatusCode;
import io.vertx.ext.mail.mailencoder.EmailAddress;
import io.vertx.ext.mail.mailencoder.MailEncoder;
import java.util.ArrayList;
import java.util.List;

class SMTPSendMail {
    private static final Logger log = LoggerFactory.getLogger(SMTPSendMail.class);
    private final SMTPConnection connection;
    private final MailMessage email;
    private final MailConfig config;
    private final Handler<AsyncResult<MailResult>> resultHandler;
    private final MailResult mailResult;
    private final String hostname;
    private String mailMessage;

    SMTPSendMail(SMTPConnection connection, MailMessage email, MailConfig config, String hostname, Handler<AsyncResult<MailResult>> resultHandler) {
        this.connection = connection;
        this.email = email;
        this.config = config;
        this.resultHandler = resultHandler;
        this.mailResult = new MailResult();
        this.hostname = hostname;
    }

    void start() {
        try {
            if (this.checkSize()) {
                this.mailFromCmd();
            }
        }
        catch (Exception e) {
            this.handleError(e);
        }
    }

    private boolean checkSize() {
        int size = this.connection.getCapa().getSize();
        if (size > 0) {
            this.createMailMessage();
            if (this.mailMessage.length() > size) {
                this.handleError("message exceeds allowed size limit");
                return false;
            }
            return true;
        }
        return true;
    }

    private void mailFromCmd() {
        try {
            String bounceAddr = this.email.getBounceAddress();
            String fromAddr = bounceAddr != null && !bounceAddr.isEmpty() ? bounceAddr : this.email.getFrom();
            EmailAddress from = new EmailAddress(fromAddr);
            String sizeParameter = this.connection.getCapa().getSize() > 0 ? " SIZE=" + this.mailMessage.length() : "";
            this.connection.write("MAIL FROM:<" + from.getEmail() + ">" + sizeParameter, (Handler<String>)((Handler)message -> {
                log.debug((Object)("MAIL FROM result: " + message));
                if (StatusCode.isStatusOk(message)) {
                    this.rcptToCmd();
                } else {
                    log.warn((Object)("sender address not accepted: " + message));
                    this.handleError("sender address not accepted: " + message);
                }
            }));
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"address exception", (Throwable)e);
            this.handleError(e);
        }
    }

    private void rcptToCmd() {
        ArrayList<String> recipientAddrs = new ArrayList<String>();
        if (this.email.getTo() != null) {
            recipientAddrs.addAll(this.email.getTo());
        }
        if (this.email.getCc() != null) {
            recipientAddrs.addAll(this.email.getCc());
        }
        if (this.email.getBcc() != null) {
            recipientAddrs.addAll(this.email.getBcc());
        }
        this.rcptToCmd(recipientAddrs, 0);
    }

    private void rcptToCmd(List<String> recipientAddrs, int i) {
        try {
            EmailAddress toAddr = new EmailAddress(recipientAddrs.get(i));
            this.connection.write("RCPT TO:<" + toAddr.getEmail() + ">", (Handler<String>)((Handler)message -> {
                if (StatusCode.isStatusOk(message)) {
                    log.debug((Object)("RCPT TO result: " + message));
                    this.mailResult.getRecipients().add(toAddr.getEmail());
                    this.nextRcpt(recipientAddrs, i);
                } else if (this.config.isAllowRcptErrors()) {
                    log.warn((Object)("recipient address not accepted, continuing: " + message));
                    this.nextRcpt(recipientAddrs, i);
                } else {
                    log.warn((Object)("recipient address not accepted: " + message));
                    this.handleError("recipient address not accepted: " + message);
                }
            }));
        }
        catch (IllegalArgumentException e) {
            log.error((Object)"address exception", (Throwable)e);
            this.handleError(e);
        }
    }

    private void nextRcpt(List<String> recipientAddrs, int i) {
        if (i + 1 < recipientAddrs.size()) {
            this.rcptToCmd(recipientAddrs, i + 1);
        } else if (this.mailResult.getRecipients().size() > 0) {
            this.dataCmd();
        } else {
            log.warn((Object)"no recipient addresses were accepted, not sending mail");
            this.handleError("no recipient addresses were accepted, not sending mail");
        }
    }

    private void handleError(Throwable throwable) {
        this.resultHandler.handle((Object)Future.failedFuture((Throwable)throwable));
    }

    private void handleError(String message) {
        this.handleError((Throwable)new NoStackTraceThrowable(message));
    }

    private void dataCmd() {
        this.connection.write("DATA", (Handler<String>)((Handler)message -> {
            log.debug((Object)("DATA result: " + message));
            if (StatusCode.isStatusOk(message)) {
                this.sendMaildata();
            } else {
                log.warn((Object)("DATA command not accepted: " + message));
                this.handleError("DATA command not accepted: " + message);
            }
        }));
    }

    private void sendMaildata() {
        this.createMailMessage();
        this.sendLineByLine(0, this.mailMessage.length());
    }

    private void sendLineByLine(int index, int length) {
        while (index < length) {
            boolean mayLog;
            String line;
            int nextIndex = this.mailMessage.indexOf(10, index);
            if (nextIndex == -1) {
                line = this.mailMessage.substring(index);
                nextIndex = length;
            } else {
                line = this.mailMessage.substring(index, nextIndex);
                ++nextIndex;
            }
            if (line.startsWith(".")) {
                line = "." + line;
            }
            int nextIndexFinal = nextIndex;
            boolean bl = mayLog = nextIndex < 1000;
            if (this.connection.writeQueueFull()) {
                this.connection.writeLineWithDrainHandler(line, mayLog, (Handler<Void>)((Handler)v -> this.sendLineByLine(nextIndexFinal, length)));
                return;
            }
            this.connection.writeLine(line, mayLog);
            index = nextIndex;
        }
        this.connection.write(".", (Handler<String>)((Handler)message -> {
            log.debug((Object)("maildata result: " + message));
            if (StatusCode.isStatusOk(message)) {
                this.resultHandler.handle((Object)Future.succeededFuture((Object)this.mailResult));
            } else {
                log.warn((Object)("sending data failed: " + message));
                this.handleError("sending data failed: " + message);
            }
        }));
    }

    private void createMailMessage() {
        if (this.mailMessage == null) {
            MailEncoder encoder = new MailEncoder(this.email, this.hostname);
            this.mailMessage = encoder.encode();
            this.mailResult.setMessageID(encoder.getMessageID());
        }
    }
}

