/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl.sasl;

import io.vertx.ext.mail.impl.sasl.AuthBaseClass;
import io.vertx.ext.mail.impl.sasl.CryptUtils;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

abstract class AuthDigest
extends AuthBaseClass {
    private int counter = 0;
    final MessageDigest digest;
    private String serverResponse;

    protected AuthDigest(String username, String password, String hash) {
        super(username, password);
        try {
            this.digest = MessageDigest.getInstance(hash);
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException("hash " + hash + " not found", e);
        }
    }

    @Override
    public String nextStep(String data) {
        switch (this.counter++) {
            case 0: {
                return "";
            }
            case 1: {
                String reply = this.calcStep1(data);
                return reply;
            }
            case 2: {
                if (data.equals("rspauth=" + this.serverResponse)) {
                    return "";
                }
                return null;
            }
        }
        return null;
    }

    private String calcStep1(String data) {
        String user;
        Map<String, String> digestChallenge = AuthDigest.parseToMap(data);
        String qop = digestChallenge.get("qop");
        String nonce = digestChallenge.get("nonce");
        String realm = digestChallenge.get("realm");
        HashMap<String, String> digestResponse = new HashMap<String, String>();
        if (this.username.contains("@")) {
            int index = this.username.indexOf(64);
            user = this.username.substring(0, index);
            realm = this.username.substring(index + 1);
        } else {
            user = this.username;
        }
        digestResponse.put("nonce", this.addQuotes(nonce));
        digestResponse.put("realm", this.addQuotes(realm));
        digestResponse.put("username", this.addQuotes(user));
        String cnonce = this.getCnonce();
        digestResponse.put("cnonce", this.addQuotes(cnonce));
        String nc = "00000001";
        digestResponse.put("nc", "00000001");
        String digestUri = this.getDigestUri();
        digestResponse.put("digest-uri", this.addQuotes(digestUri));
        digestResponse.put("qop", qop);
        digestResponse.put("charset", "utf-8");
        digestResponse.put("response", this.response(user, realm, nonce, cnonce, qop, "00000001", digestUri, "AUTHENTICATE"));
        this.serverResponse = this.response(user, realm, nonce, cnonce, qop, "00000001", digestUri, "");
        return this.encodeMap(digestResponse);
    }

    private String response(String user, String realm, String nonce, String cnonce, String qop, String nc, String digestUri, String operation) {
        byte[] colon = this.b(":");
        byte[] A1 = this.concatBytes(this.hash(this.concatBytes(this.b(user), colon, this.b(realm), colon, this.b(this.password))), colon, this.b(nonce), colon, this.b(cnonce));
        byte[] A2 = this.concatBytes(this.b(operation), colon, this.b(digestUri));
        String responseValue = this.hexKd(this.hexHash(A1), nonce + ":" + nc + ":" + cnonce + ":" + qop + ":" + this.hexHash(A2));
        return responseValue;
    }

    private byte[] b(String str) {
        try {
            return str.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private byte[] concatBytes(byte[] ... bytes) {
        int length = 0;
        for (byte[] b : bytes) {
            length += b.length;
        }
        byte[] newArray = new byte[length];
        int index = 0;
        for (byte[] b : bytes) {
            System.arraycopy(b, 0, newArray, index, b.length);
            index += b.length;
        }
        return newArray;
    }

    private byte[] hash(byte[] data) {
        return this.digest.digest(data);
    }

    private String hexKd(String string, String string2) {
        return this.hexHash(this.concatBytes(this.b(string), this.b(":"), this.b(string2)));
    }

    private String hexHash(byte[] data) {
        return CryptUtils.encodeHex(this.hash(data));
    }

    private String encodeMap(Map<String, String> digestResponse) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : digestResponse.entrySet()) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(entry.getKey() + "=" + entry.getValue());
        }
        return sb.toString();
    }

    private String addQuotes(String string) {
        return "\"" + string.replace("\"", "\\\"") + "\"";
    }

    static Map<String, String> parseToMap(String data) {
        ArrayList<String> fields = new ArrayList<String>();
        boolean inQuote = false;
        int startIndex = 0;
        for (int i = 0; i < data.length(); ++i) {
            char ch = data.charAt(i);
            if (ch == '\\') {
                ++i;
                continue;
            }
            if (inQuote) {
                if (ch != '\"') continue;
                inQuote = false;
                continue;
            }
            if (ch == '\"') {
                inQuote = true;
                continue;
            }
            if (ch != ',') continue;
            fields.add(data.substring(startIndex, i));
            startIndex = i + 1;
        }
        fields.add(data.substring(startIndex));
        HashMap<String, String> map = new HashMap<String, String>();
        for (String f : fields) {
            int equalsIndex = f.indexOf(61);
            if (equalsIndex < 0) continue;
            String key = f.substring(0, equalsIndex);
            String val = f.substring(equalsIndex + 1);
            map.put(key, AuthDigest.removeQuotes(val));
        }
        return map;
    }

    private static String removeQuotes(String string) {
        StringBuilder sb = new StringBuilder(string.length());
        boolean backslash = false;
        for (int i = 0; i < string.length(); ++i) {
            char ch = string.charAt(i);
            if (backslash) {
                sb.append(ch);
                backslash = false;
                continue;
            }
            if (ch == '\\') {
                backslash = true;
                continue;
            }
            if (ch == '\"') continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    protected String getCnonce() {
        SecureRandom random = new SecureRandom();
        byte[] randomBytes = new byte[16];
        random.nextBytes(randomBytes);
        return CryptUtils.base64(randomBytes);
    }

    protected String getDigestUri() {
        return "smtp/";
    }
}

