/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl.sasl;

import io.vertx.ext.mail.impl.sasl.AuthCramMD5;
import io.vertx.ext.mail.impl.sasl.AuthCramSHA1;
import io.vertx.ext.mail.impl.sasl.AuthCramSHA256;
import io.vertx.ext.mail.impl.sasl.AuthDigestMD5;
import io.vertx.ext.mail.impl.sasl.AuthLogin;
import io.vertx.ext.mail.impl.sasl.AuthOperation;
import io.vertx.ext.mail.impl.sasl.AuthPlain;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;

public class AuthOperationFactory {
    private static final Class<?>[] authList = new Class[]{AuthDigestMD5.class, AuthCramSHA256.class, AuthCramSHA1.class, AuthCramMD5.class, AuthPlain.class, AuthLogin.class};

    private AuthOperationFactory() {
    }

    public static AuthOperation createAuth(String username, String password, Set<String> allowedMethods) throws IllegalArgumentException, IllegalAccessException, InstantiationException, InvocationTargetException, NoSuchMethodException, SecurityException {
        Class<?> classToUse = null;
        block0: for (Class<?> authClass : authList) {
            Field[] fields;
            for (Field f : fields = authClass.getDeclaredFields()) {
                String authName;
                f.setAccessible(true);
                String fieldName = f.getName();
                if (!"AUTH_NAME".equals(fieldName) || !allowedMethods.contains(authName = (String)f.get(null))) continue;
                classToUse = authClass;
                continue block0;
            }
        }
        if (classToUse != null) {
            return (AuthOperation)classToUse.getConstructor(String.class, String.class).newInstance(username, password);
        }
        return null;
    }
}

