/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.mail.impl.sasl;

import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.Base64;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;

public class CryptUtils {
    private CryptUtils() {
    }

    protected static String hmacHex(String keyString, String message, String hmac) {
        try {
            SecretKeySpec key = new SecretKeySpec(keyString.getBytes("UTF-8"), hmac);
            Mac mac = Mac.getInstance(key.getAlgorithm());
            mac.init(key);
            return CryptUtils.encodeHex(mac.doFinal(message.getBytes("UTF-8")));
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException e) {
            return "";
        }
    }

    protected static String encodeHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder(bytes.length * 2);
        for (byte b : bytes) {
            int v = b & 0xFF;
            if (v < 16) {
                sb.append('0');
            }
            sb.append(Integer.toHexString(v));
        }
        return sb.toString();
    }

    public static String base64(String string) {
        try {
            return Base64.getEncoder().encodeToString(string.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }

    public static String base64(byte[] data) {
        return Base64.getEncoder().encodeToString(data);
    }

    public static String decodeb64(String string) {
        try {
            return new String(Base64.getDecoder().decode(string), "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            return "";
        }
    }
}

