/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StreamCorruptedException;
import java.io.StringWriter;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.client.ClientAuthenticationManager;
import org.apache.sshd.client.ClientBuilder;
import org.apache.sshd.client.ClientFactoryManager;
import org.apache.sshd.client.auth.AuthenticationIdentitiesProvider;
import org.apache.sshd.client.auth.UserAuth;
import org.apache.sshd.client.auth.keyboard.UserAuthKeyboardInteractiveFactory;
import org.apache.sshd.client.auth.keyboard.UserInteraction;
import org.apache.sshd.client.auth.password.PasswordIdentityProvider;
import org.apache.sshd.client.auth.password.UserAuthPasswordFactory;
import org.apache.sshd.client.auth.pubkey.UserAuthPublicKeyFactory;
import org.apache.sshd.client.channel.ClientChannelEvent;
import org.apache.sshd.client.channel.PtyCapableChannelSession;
import org.apache.sshd.client.config.hosts.HostConfigEntry;
import org.apache.sshd.client.config.hosts.HostConfigEntryResolver;
import org.apache.sshd.client.config.hosts.KnownHostEntry;
import org.apache.sshd.client.config.keys.ClientIdentityLoader;
import org.apache.sshd.client.config.keys.DefaultClientIdentitiesWatcher;
import org.apache.sshd.client.future.ConnectFuture;
import org.apache.sshd.client.future.DefaultConnectFuture;
import org.apache.sshd.client.keyverifier.DefaultKnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.KnownHostsServerKeyVerifier;
import org.apache.sshd.client.keyverifier.ModifiedServerKeyAcceptor;
import org.apache.sshd.client.keyverifier.ServerKeyVerifier;
import org.apache.sshd.client.session.AbstractClientSession;
import org.apache.sshd.client.session.ClientConnectionServiceFactory;
import org.apache.sshd.client.session.ClientProxyConnector;
import org.apache.sshd.client.session.ClientSession;
import org.apache.sshd.client.session.ClientSessionCreator;
import org.apache.sshd.client.session.ClientUserAuthServiceFactory;
import org.apache.sshd.client.session.SessionFactory;
import org.apache.sshd.client.simple.AbstractSimpleClientSessionCreator;
import org.apache.sshd.client.simple.SimpleClient;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.cipher.BuiltinCiphers;
import org.apache.sshd.common.cipher.Cipher;
import org.apache.sshd.common.compression.BuiltinCompressions;
import org.apache.sshd.common.compression.Compression;
import org.apache.sshd.common.config.CompressionConfigValue;
import org.apache.sshd.common.config.SshConfigFileReader;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.keyprovider.AbstractFileKeyPairProvider;
import org.apache.sshd.common.keyprovider.KeyPairProvider;
import org.apache.sshd.common.mac.BuiltinMacs;
import org.apache.sshd.common.mac.Mac;
import org.apache.sshd.common.scp.ScpFileOpener;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.OsUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.Supplier;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.io.IoUtils;
import org.apache.sshd.common.util.io.NoCloseInputStream;
import org.apache.sshd.common.util.io.NoCloseOutputStream;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class SshClient
extends AbstractFactoryManager
implements ClientFactoryManager,
ClientSessionCreator,
Closeable {
    public static final Factory<SshClient> DEFAULT_SSH_CLIENT_FACTORY = new Factory<SshClient>(){

        @Override
        public SshClient create() {
            return new SshClient();
        }
    };
    public static final String SSH_CLIENT_PORT_OPTION = "-p";
    public static final List<NamedFactory<UserAuth>> DEFAULT_USER_AUTH_FACTORIES = Collections.unmodifiableList(Arrays.asList(UserAuthPublicKeyFactory.INSTANCE, UserAuthKeyboardInteractiveFactory.INSTANCE, UserAuthPasswordFactory.INSTANCE));
    public static final List<ServiceFactory> DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ClientUserAuthServiceFactory.INSTANCE, ClientConnectionServiceFactory.INSTANCE));
    protected IoConnector connector;
    protected SessionFactory sessionFactory;
    protected UserInteraction userInteraction;
    protected List<NamedFactory<UserAuth>> userAuthFactories;
    private ClientProxyConnector proxyConnector;
    private ServerKeyVerifier serverKeyVerifier;
    private HostConfigEntryResolver hostConfigEntryResolver;
    private ClientIdentityLoader clientIdentityLoader;
    private FilePasswordProvider filePasswordProvider;
    private PasswordIdentityProvider passwordIdentityProvider;
    private ScpFileOpener scpOpener;
    private final List<Object> identities = new CopyOnWriteArrayList<Object>();
    private final AuthenticationIdentitiesProvider identitiesProvider = AuthenticationIdentitiesProvider.Utils.wrap(this.identities);

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ClientProxyConnector getClientProxyConnector() {
        return this.proxyConnector;
    }

    @Override
    public void setClientProxyConnector(ClientProxyConnector proxyConnector) {
        this.proxyConnector = proxyConnector;
    }

    @Override
    public ScpFileOpener getScpFileOpener() {
        return this.scpOpener;
    }

    @Override
    public void setScpFileOpener(ScpFileOpener opener) {
        this.scpOpener = opener;
    }

    @Override
    public ServerKeyVerifier getServerKeyVerifier() {
        return this.serverKeyVerifier;
    }

    @Override
    public void setServerKeyVerifier(ServerKeyVerifier serverKeyVerifier) {
        this.serverKeyVerifier = ValidateUtils.checkNotNull(serverKeyVerifier, "No server key verifier");
    }

    @Override
    public HostConfigEntryResolver getHostConfigEntryResolver() {
        return this.hostConfigEntryResolver;
    }

    @Override
    public void setHostConfigEntryResolver(HostConfigEntryResolver resolver) {
        this.hostConfigEntryResolver = ValidateUtils.checkNotNull(resolver, "No host configuration entry resolver");
    }

    @Override
    public FilePasswordProvider getFilePasswordProvider() {
        return this.filePasswordProvider;
    }

    @Override
    public void setFilePasswordProvider(FilePasswordProvider provider) {
        this.filePasswordProvider = ValidateUtils.checkNotNull(provider, "No file password provider");
    }

    @Override
    public ClientIdentityLoader getClientIdentityLoader() {
        return this.clientIdentityLoader;
    }

    @Override
    public void setClientIdentityLoader(ClientIdentityLoader loader) {
        this.clientIdentityLoader = ValidateUtils.checkNotNull(loader, "No client identity loader");
    }

    @Override
    public UserInteraction getUserInteraction() {
        return this.userInteraction;
    }

    @Override
    public void setUserInteraction(UserInteraction userInteraction) {
        this.userInteraction = userInteraction;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    @Override
    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = ValidateUtils.checkNotNullAndNotEmpty(userAuthFactories, "No user auth factories", new Object[0]);
    }

    @Override
    public AuthenticationIdentitiesProvider getRegisteredIdentities() {
        return this.identitiesProvider;
    }

    @Override
    public PasswordIdentityProvider getPasswordIdentityProvider() {
        return this.passwordIdentityProvider;
    }

    @Override
    public void setPasswordIdentityProvider(PasswordIdentityProvider provider) {
        this.passwordIdentityProvider = provider;
    }

    @Override
    public void addPasswordIdentity(String password) {
        this.identities.add(ValidateUtils.checkNotNullAndNotEmpty(password, "No password provided"));
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPasswordIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(password));
        }
    }

    @Override
    public String removePasswordIdentity(String password) {
        if (GenericUtils.isEmpty(password)) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.Utils.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.Utils.PASSWORD_IDENTITY_COMPARATOR, password);
        if (index >= 0) {
            return (String)this.identities.remove(index);
        }
        return null;
    }

    @Override
    public void addPublicKeyIdentity(KeyPair kp) {
        ValidateUtils.checkNotNull(kp, "No key-pair to add");
        ValidateUtils.checkNotNull(kp.getPublic(), "No public key");
        ValidateUtils.checkNotNull(kp.getPrivate(), "No private key");
        this.identities.add(kp);
        if (this.log.isDebugEnabled()) {
            this.log.debug("addPublicKeyIdentity({}) {}", (Object)this, (Object)KeyUtils.getFingerPrint(kp.getPublic()));
        }
    }

    @Override
    public KeyPair removePublicKeyIdentity(KeyPair kp) {
        if (kp == null) {
            return null;
        }
        int index = AuthenticationIdentitiesProvider.Utils.findIdentityIndex(this.identities, AuthenticationIdentitiesProvider.Utils.KEYPAIR_IDENTITY_COMPARATOR, kp);
        if (index >= 0) {
            return (KeyPair)this.identities.remove(index);
        }
        return null;
    }

    @Override
    protected void checkConfig() {
        SshAgentFactory agentFactory;
        super.checkConfig();
        ValidateUtils.checkNotNull(this.getTcpipForwarderFactory(), "TcpipForwarderFactory not set");
        ValidateUtils.checkNotNull(this.getServerKeyVerifier(), "ServerKeyVerifier not set");
        ValidateUtils.checkNotNull(this.getHostConfigEntryResolver(), "HostConfigEntryResolver not set");
        ValidateUtils.checkNotNull(this.getClientIdentityLoader(), "ClientIdentityLoader not set");
        ValidateUtils.checkNotNull(this.getFilePasswordProvider(), "FilePasswordProvider not set");
        KeyPairProvider defaultIdentities = this.getKeyPairProvider();
        if (defaultIdentities == null) {
            this.setKeyPairProvider(new DefaultClientIdentitiesWatcher(new Supplier<ClientIdentityLoader>(){

                @Override
                public ClientIdentityLoader get() {
                    return SshClient.this.getClientIdentityLoader();
                }
            }, new Supplier<FilePasswordProvider>(){

                @Override
                public FilePasswordProvider get() {
                    return SshClient.this.getFilePasswordProvider();
                }
            }));
        }
        if ((agentFactory = this.getAgentFactory()) != null) {
            List<NamedFactory<Channel>> factories = this.getChannelFactories();
            factories = GenericUtils.isEmpty(factories) ? new ArrayList<NamedFactory<Channel>>() : new ArrayList<NamedFactory<Channel>>(factories);
            factories.add(ValidateUtils.checkNotNull(agentFactory.getChannelForwardingFactory(), "No agent channel forwarding factory for %s", (Object)agentFactory));
            this.setChannelFactories(factories);
        }
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
        if (GenericUtils.isEmpty(this.getUserAuthFactories())) {
            this.setUserAuthFactories(DEFAULT_USER_AUTH_FACTORIES);
        }
    }

    public void start() {
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.setupSessionTimeout(this.sessionFactory);
        this.connector = this.createConnector();
    }

    public void stop() {
        block4: {
            try {
                long maxWait = PropertyResolverUtils.getLongProperty(this, "stop-wait-time", DEFAULT_STOP_WAIT_TIME);
                boolean successful = this.close(true).await(maxWait);
                if (!successful) {
                    throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
                }
            }
            catch (IOException e) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug(e.getClass().getSimpleName() + " while stopping client: " + e.getMessage());
                }
                if (!this.log.isTraceEnabled()) break block4;
                this.log.trace("Stop exception details", (Throwable)e);
            }
        }
    }

    public void open() throws IOException {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().run(new Runnable(){

            @Override
            public void run() {
                SshClient.this.removeSessionTimeout(SshClient.this.sessionFactory);
            }
        }).sequential(this.connector, this.ioServiceFactory).run(new Runnable(){

            @Override
            public void run() {
                SshClient.this.connector = null;
                SshClient.this.ioServiceFactory = null;
                if (SshClient.this.shutdownExecutor && SshClient.this.executor != null && !SshClient.this.executor.isShutdown()) {
                    try {
                        SshClient.this.executor.shutdownNow();
                    }
                    finally {
                        SshClient.this.executor = null;
                    }
                }
            }
        }).build();
    }

    @Override
    public ConnectFuture connect(String username, String host, int port) throws IOException {
        HostConfigEntryResolver resolver = this.getHostConfigEntryResolver();
        HostConfigEntry entry = resolver.resolveEffectiveHost(host, port, username);
        if (entry == null) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("connect({}@{}:{}) no overrides", new Object[]{username, host, port});
            }
            entry = new HostConfigEntry(host, host, port, username);
        } else if (this.log.isDebugEnabled()) {
            this.log.debug("connect({}@{}:{}) effective: {}", new Object[]{username, host, port, entry});
        }
        return this.connect(entry);
    }

    @Override
    public ConnectFuture connect(String username, SocketAddress address) throws IOException {
        ValidateUtils.checkNotNull(address, "No target address");
        if (address instanceof InetSocketAddress) {
            InetSocketAddress inetAddress = (InetSocketAddress)address;
            String host = ValidateUtils.checkNotNullAndNotEmpty(inetAddress.getHostString(), "No host");
            int port = inetAddress.getPort();
            ValidateUtils.checkTrue(port > 0, "Invalid port: %d", port);
            HostConfigEntryResolver resolver = this.getHostConfigEntryResolver();
            HostConfigEntry entry = resolver.resolveEffectiveHost(host, port, username);
            if (entry == null) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("connect({}@{}:{}) no overrides", new Object[]{username, host, port});
                }
                return this.doConnect(username, address, Collections.emptyList(), true);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("connect({}@{}:{}) effective: {}", new Object[]{username, host, port, entry});
            }
            return this.connect(entry);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("connect({}@{}) not an InetSocketAddress: {}", new Object[]{username, address, address.getClass().getName()});
        }
        return this.doConnect(username, address, Collections.emptyList(), true);
    }

    @Override
    public ConnectFuture connect(HostConfigEntry hostConfig) throws IOException {
        ValidateUtils.checkNotNull(hostConfig, "No host configuration");
        String host = ValidateUtils.checkNotNullAndNotEmpty(hostConfig.getHostName(), "No target host");
        int port = hostConfig.getPort();
        ValidateUtils.checkTrue(port > 0, "Invalid port: %d", port);
        List<KeyPair> keys = this.loadClientIdentities(hostConfig.getIdentities(), IoUtils.EMPTY_LINK_OPTIONS);
        return this.doConnect(hostConfig.getUsername(), new InetSocketAddress(host, port), keys, !hostConfig.isIdentitiesOnly());
    }

    protected List<KeyPair> loadClientIdentities(Collection<String> locations, LinkOption ... options) throws IOException {
        if (GenericUtils.isEmpty(locations)) {
            return Collections.emptyList();
        }
        ArrayList<KeyPair> ids = new ArrayList<KeyPair>(locations.size());
        boolean ignoreNonExisting = PropertyResolverUtils.getBooleanProperty(this, "ignore-invalid-identities", true);
        ClientIdentityLoader loader = ValidateUtils.checkNotNull(this.getClientIdentityLoader(), "No ClientIdentityLoader");
        FilePasswordProvider provider = ValidateUtils.checkNotNull(this.getFilePasswordProvider(), "No FilePasswordProvider");
        for (String l : locations) {
            if (!loader.isValidLocation(l)) {
                if (ignoreNonExisting) {
                    this.log.debug("loadClientIdentities - skip non-existing identity location: {}", (Object)l);
                    continue;
                }
                throw new FileNotFoundException("Invalid identity location: " + l);
            }
            try {
                KeyPair kp = loader.loadClientIdentity(l, provider);
                if (kp == null) {
                    throw new IOException("No identity loaded from " + l);
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug("loadClientIdentities({}) type={}, fingerprint={}", new Object[]{l, KeyUtils.getKeyType(kp), KeyUtils.getFingerPrint(kp.getPublic())});
                }
                ids.add(kp);
            }
            catch (GeneralSecurityException e) {
                throw new StreamCorruptedException("Failed (" + e.getClass().getSimpleName() + ") to load identity from " + l + ": " + e.getMessage());
            }
        }
        return ids;
    }

    protected ConnectFuture doConnect(String username, SocketAddress address, Collection<? extends KeyPair> identities, boolean useDefaultIdentities) throws IOException {
        if (this.connector == null) {
            throw new IllegalStateException("SshClient not started. Please call start() method before connecting to a server");
        }
        DefaultConnectFuture connectFuture = new DefaultConnectFuture((Object)null);
        SshFutureListener<IoConnectFuture> listener = this.createConnectCompletionListener(connectFuture, username, address, identities, useDefaultIdentities);
        this.connector.connect(address).addListener(listener);
        return connectFuture;
    }

    protected SshFutureListener<IoConnectFuture> createConnectCompletionListener(final ConnectFuture connectFuture, final String username, final SocketAddress address, final Collection<? extends KeyPair> identities, final boolean useDefaultIdentities) {
        return new SshFutureListener<IoConnectFuture>(){

            @Override
            public void operationComplete(IoConnectFuture future) {
                if (future.isCanceled()) {
                    connectFuture.cancel();
                    return;
                }
                Throwable t = future.getException();
                if (t != null) {
                    if (SshClient.this.log.isDebugEnabled()) {
                        SshClient.this.log.debug("operationComplete({}@{}) failed ({}): {}", new Object[]{username, address, t.getClass().getSimpleName(), t.getMessage()});
                    }
                    connectFuture.setException(t);
                } else {
                    SshClient.this.onConnectOperationComplete(future.getSession(), connectFuture, username, address, identities, useDefaultIdentities);
                }
            }
        };
    }

    protected void onConnectOperationComplete(IoSession ioSession, ConnectFuture connectFuture, String username, SocketAddress address, Collection<? extends KeyPair> identities, boolean useDefaultIdentities) {
        int numIds;
        AbstractClientSession session = (AbstractClientSession)AbstractSession.getSession(ioSession);
        session.setUsername(username);
        session.setConnectAddress(address);
        if (useDefaultIdentities) {
            this.setupDefaultSessionIdentities(session);
        }
        if ((numIds = GenericUtils.size(identities)) > 0) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("onConnectOperationComplete({}) adding {} identities", (Object)session, (Object)numIds);
            }
            for (KeyPair keyPair : identities) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("onConnectOperationComplete({}) add identity type={}, fingerprint={}", new Object[]{session, KeyUtils.getKeyType(keyPair), KeyUtils.getFingerPrint(keyPair.getPublic())});
                }
                session.addPublicKeyIdentity(keyPair);
            }
        }
        connectFuture.setSession(session);
    }

    protected void setupDefaultSessionIdentities(ClientSession session) {
        KeyPairProvider kpSession = session.getKeyPairProvider();
        KeyPairProvider kpClient = this.getKeyPairProvider();
        if (kpSession == null) {
            session.setKeyPairProvider(kpClient);
        } else if (kpSession != kpClient && this.log.isDebugEnabled()) {
            this.log.debug("setupDefaultSessionIdentities({}) key-pair provider override", (Object)session);
        }
        PasswordIdentityProvider passSession = session.getPasswordIdentityProvider();
        PasswordIdentityProvider passClient = this.getPasswordIdentityProvider();
        if (passSession == null) {
            session.setPasswordIdentityProvider(passClient);
        } else if (passSession != passClient && this.log.isDebugEnabled()) {
            this.log.debug("setupDefaultSessionIdentities({}) password provider override", (Object)session);
        }
        AuthenticationIdentitiesProvider idsClient = this.getRegisteredIdentities();
        Iterator<?> iter = GenericUtils.iteratorOf(idsClient == null ? null : idsClient.loadIdentities());
        while (iter.hasNext()) {
            Object id = iter.next();
            if (id instanceof String) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("setupDefaultSessionIdentities({}) add password fingerprint={}", (Object)session, (Object)KeyUtils.getFingerPrint(id.toString()));
                }
                session.addPasswordIdentity((String)id);
                continue;
            }
            if (id instanceof KeyPair) {
                KeyPair kp = (KeyPair)id;
                if (this.log.isTraceEnabled()) {
                    this.log.trace("setupDefaultSessionIdentities({}) add identity type={}, fingerprint={}", new Object[]{session, KeyUtils.getKeyType(kp), KeyUtils.getFingerPrint(kp.getPublic())});
                }
                session.addPublicKeyIdentity(kp);
                continue;
            }
            if (!this.log.isDebugEnabled()) continue;
            this.log.debug("setupDefaultSessionIdentities({}) ignored identity={}", (Object)session, id);
        }
    }

    protected IoConnector createConnector() {
        return this.getIoServiceFactory().createConnector(this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory(this);
    }

    public String toString() {
        return "SshClient[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SimpleClient setUpDefaultSimpleClient() {
        SshClient client = SshClient.setUpDefaultClient();
        client.start();
        return SshClient.wrapAsSimpleClient(client);
    }

    public static SimpleClient wrapAsSimpleClient(final SshClient client) {
        ValidateUtils.checkNotNull(client, "No client instance");
        java.nio.channels.Channel channel = new java.nio.channels.Channel(){

            @Override
            public boolean isOpen() {
                return client.isOpen();
            }

            @Override
            public void close() throws IOException {
                Exception err = null;
                try {
                    client.close();
                }
                catch (Exception e) {
                    err = GenericUtils.accumulateException(err, e);
                }
                try {
                    client.stop();
                }
                catch (Exception e) {
                    err = GenericUtils.accumulateException(err, e);
                }
                if (err != null) {
                    if (err instanceof IOException) {
                        throw (IOException)err;
                    }
                    throw new IOException(err);
                }
            }
        };
        return AbstractSimpleClientSessionCreator.wrap(client, channel);
    }

    public static SshClient setUpDefaultClient() {
        return (SshClient)ClientBuilder.builder().build();
    }

    public static boolean showError(PrintStream stderr, String message) {
        stderr.println(message);
        return true;
    }

    public static boolean isArgumentedOption(String portOption, String argName) {
        return portOption.equals(argName) || "-i".equals(argName) || "-o".equals(argName) || "-l".equals(argName) || "-w".equals(argName) || "-c".equals(argName) || "-m".equals(argName) || "-E".equals(argName);
    }

    public static ClientSession setupClientSession(String portOption, BufferedReader stdin, PrintStream stdout, PrintStream stderr, String ... args) throws Exception {
        int port = -1;
        String host = null;
        String login = null;
        String password = null;
        boolean error = false;
        ArrayList<File> identities = new ArrayList<File>();
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        List<NamedFactory<Cipher>> ciphers = null;
        List<NamedFactory<Mac>> macs = null;
        List<NamedFactory<Compression>> compressions = null;
        int numArgs = GenericUtils.length(args);
        for (int i = 0; !error && i < numArgs; ++i) {
            String argName = args[i];
            String argVal = null;
            if (SshClient.isArgumentedOption(portOption, argName)) {
                if (i + 1 >= numArgs) {
                    error = SshClient.showError(stderr, "option requires an argument: " + argName);
                    break;
                }
                argVal = args[++i];
            }
            if (portOption.equals(argName)) {
                if (port > 0) {
                    error = SshClient.showError(stderr, argName + " option value re-specified: " + port);
                    break;
                }
                port = Integer.parseInt(argVal);
                if (port > 0) continue;
                error = SshClient.showError(stderr, "Bad option value for " + argName + ": " + port);
                break;
            }
            if ("-w".equals(argName)) {
                if (GenericUtils.length(password) > 0) {
                    error = SshClient.showError(stderr, argName + " option value re-specified: " + password);
                    break;
                }
                password = argVal;
                continue;
            }
            if ("-c".equals(argName)) {
                if (!GenericUtils.isEmpty(ciphers = SshClient.setupCiphers(argName, argVal, ciphers, stderr))) continue;
                error = true;
                break;
            }
            if ("-m".equals(argName)) {
                if (!GenericUtils.isEmpty(macs = SshClient.setupMacs(argName, argVal, macs, stderr))) continue;
                error = true;
                break;
            }
            if ("-i".equals(argName)) {
                identities.add(new File(argVal));
                continue;
            }
            if ("-C".equals(argName)) {
                compressions = SshClient.setupCompressions(argName, GenericUtils.join(Arrays.asList("zlib", "zlib@openssh.com"), ','), compressions, stderr);
                if (!GenericUtils.isEmpty(compressions)) continue;
                error = true;
                break;
            }
            if ("-o".equals(argName)) {
                String opt = argVal;
                int idx = opt.indexOf(61);
                if (idx <= 0) {
                    error = SshClient.showError(stderr, "bad syntax for option: " + opt);
                    break;
                }
                options.put(opt.substring(0, idx), opt.substring(idx + 1));
                continue;
            }
            if ("-l".equals(argName)) {
                if (login != null) {
                    error = SshClient.showError(stderr, argName + " option value re-specified: " + port);
                    break;
                }
                login = argVal;
                continue;
            }
            if (argName.charAt(0) == '-') continue;
            if (host != null) break;
            host = argName;
            int pos = host.indexOf(64);
            if (pos <= 0) continue;
            if (login == null) {
                login = host.substring(0, pos);
                host = host.substring(pos + 1);
                continue;
            }
            error = SshClient.showError(stderr, "Login already specified using -l option (" + login + "): " + host);
            break;
        }
        if (!error && GenericUtils.isEmpty(host)) {
            error = SshClient.showError(stderr, "Hostname not specified");
        }
        if (error) {
            return null;
        }
        SshClient client = SshClient.setupClient(options, ciphers, macs, compressions, identities, stdin, stdout, stderr);
        if (client == null) {
            return null;
        }
        try {
            client.start();
            if (login == null) {
                login = OsUtils.getCurrentUser();
            }
            if (port <= 0) {
                port = 22;
            }
            ClientSession session = ((ConnectFuture)client.connect(login, host, port).verify()).getSession();
            try {
                if (GenericUtils.length(password) > 0) {
                    session.addPasswordIdentity(password);
                }
                session.auth().verify(FactoryManager.DEFAULT_AUTH_TIMEOUT);
                return session;
            }
            catch (Exception e) {
                session.close(true);
                throw e;
            }
        }
        catch (Exception e) {
            client.close();
            throw e;
        }
    }

    public static SshClient setupClient(Map<String, ?> options, List<NamedFactory<Cipher>> ciphers, List<NamedFactory<Mac>> macs, List<NamedFactory<Compression>> compressions, Collection<File> identities, BufferedReader stdin, PrintStream stdout, PrintStream stderr) throws Exception {
        if (GenericUtils.isEmpty(ciphers) && (ciphers = SshClient.setupCiphers(options, stderr)) == null) {
            return null;
        }
        if (GenericUtils.isEmpty(macs) && (macs = SshClient.setupMacs(options, stderr)) == null) {
            return null;
        }
        if (GenericUtils.isEmpty(compressions) && (compressions = SshClient.setupCompressions(options, stderr)) == null) {
            return null;
        }
        SshClient client = SshClient.setUpDefaultClient();
        try {
            if (GenericUtils.size(ciphers) > 0) {
                client.setCipherFactories(ciphers);
            }
            if (GenericUtils.size(macs) > 0) {
                client.setMacFactories(macs);
            }
            if (GenericUtils.size(compressions) > 0) {
                client.setCompressionFactories(compressions);
            }
            try {
                SshClient.setupSessionIdentities(client, identities, stdin, stdout, stderr);
            }
            catch (Throwable t) {
                SshClient.showError(stderr, t.getClass().getSimpleName() + " while loading user keys: " + t.getMessage());
            }
            SshClient.setupServerKeyVerifier(client, options, stdin, stdout, stderr);
            SshClient.setupSessionUserInteraction(client, stdin, stdout, stderr);
            Map<String, Object> props = client.getProperties();
            props.putAll(options);
            return client;
        }
        catch (Throwable t) {
            SshClient.showError(stderr, "Failed (" + t.getClass().getSimpleName() + ") to setup client: " + t.getMessage());
            client.close();
            return null;
        }
    }

    public static AbstractFileKeyPairProvider setupSessionIdentities(ClientFactoryManager client, Collection<File> identities, final BufferedReader stdin, final PrintStream stdout, PrintStream stderr) throws Throwable {
        client.setFilePasswordProvider(new FilePasswordProvider(){

            @Override
            public String getPassword(String file) throws IOException {
                stdout.print("Enter password for private key file=" + file + ": ");
                return stdin.readLine();
            }
        });
        if (GenericUtils.isEmpty(identities)) {
            return null;
        }
        AbstractFileKeyPairProvider provider = SecurityUtils.createFileKeyPairProvider();
        provider.setFiles(identities);
        client.setKeyPairProvider(provider);
        return provider;
    }

    public static UserInteraction setupSessionUserInteraction(ClientAuthenticationManager client, final BufferedReader stdin, final PrintStream stdout, final PrintStream stderr) {
        UserInteraction ui = new UserInteraction(){

            @Override
            public boolean isInteractionAllowed(ClientSession session) {
                return true;
            }

            @Override
            public void serverVersionInfo(ClientSession session, List<String> lines) {
                for (String l : lines) {
                    stdout.append('\t').println(l);
                }
            }

            @Override
            public void welcome(ClientSession clientSession, String banner, String lang) {
                stdout.println(banner);
            }

            @Override
            public String[] interactive(ClientSession clientSession, String name, String instruction, String lang, String[] prompt, boolean[] echo) {
                int numPropmts = GenericUtils.length(prompt);
                String[] answers = new String[numPropmts];
                try {
                    for (int i = 0; i < numPropmts; ++i) {
                        stdout.append(prompt[i]).print(" ");
                        answers[i] = stdin.readLine();
                    }
                }
                catch (IOException e) {
                    stderr.append(e.getClass().getSimpleName()).append(" while read prompts: ").println(e.getMessage());
                }
                return answers;
            }

            @Override
            public String getUpdatedPassword(ClientSession clientSession, String prompt, String lang) {
                stdout.append(prompt).print(" ");
                try {
                    return stdin.readLine();
                }
                catch (IOException e) {
                    stderr.append(e.getClass().getSimpleName()).append(" while read password: ").println(e.getMessage());
                    return null;
                }
            }
        };
        client.setUserInteraction(ui);
        return ui;
    }

    public static ServerKeyVerifier setupServerKeyVerifier(ClientAuthenticationManager manager, Map<String, ?> options, final BufferedReader stdin, final PrintStream stdout, final PrintStream stderr) {
        String strictValue;
        ServerKeyVerifier current = manager.getServerKeyVerifier();
        if (current == null) {
            current = ClientBuilder.DEFAULT_SERVER_KEY_VERIFIER;
            manager.setServerKeyVerifier(current);
        }
        if (!SshConfigFileReader.parseBooleanValue(strictValue = Objects.toString(options.remove("StrictHostKeyChecking"), "true"))) {
            return current;
        }
        String filePath = Objects.toString(options.remove("UserKnownHostsFile"), null);
        current = GenericUtils.isEmpty(filePath) ? new DefaultKnownHostsServerKeyVerifier(current) : new DefaultKnownHostsServerKeyVerifier(current, false, Paths.get(filePath, new String[0]), new LinkOption[0]);
        ((KnownHostsServerKeyVerifier)current).setModifiedServerKeyAcceptor(new ModifiedServerKeyAcceptor(){

            @Override
            public boolean acceptModifiedServerKey(ClientSession clientSession, SocketAddress remoteAddress, KnownHostEntry entry, PublicKey expected, PublicKey actual) throws Exception {
                stderr.append("Mismatched keys presented by ").append(Objects.toString(remoteAddress)).append(" for entry=").println(entry);
                stderr.append('\t').append("Expected=").append(KeyUtils.getKeyType(expected)).append('-').println(KeyUtils.getFingerPrint(expected));
                stderr.append('\t').append("Actual=").append(KeyUtils.getKeyType(actual)).append('-').println(KeyUtils.getFingerPrint(actual));
                stderr.flush();
                stdout.append("Accept key and update known hosts: y/[N]");
                stdout.flush();
                String ans = GenericUtils.trimToEmpty(stdin.readLine());
                return GenericUtils.length(ans) > 0 && Character.toLowerCase(ans.charAt(0)) == 'y';
            }
        });
        manager.setServerKeyVerifier(current);
        return current;
    }

    public static Level resolveLoggingVerbosity(String ... args) {
        return SshClient.resolveLoggingVerbosity(args, GenericUtils.length(args));
    }

    public static Level resolveLoggingVerbosity(String[] args, int maxIndex) {
        for (int index = 0; index < maxIndex; ++index) {
            String argName = args[index];
            if ("-v".equals(argName)) {
                return Level.INFO;
            }
            if ("-vv".equals(argName)) {
                return Level.FINE;
            }
            if (!"-vvv".equals(argName)) continue;
            return Level.FINEST;
        }
        return Level.WARNING;
    }

    public static OutputStream resolveLoggingTargetStream(PrintStream stdout, PrintStream stderr, String ... args) {
        return SshClient.resolveLoggingTargetStream(stdout, stderr, args, GenericUtils.length(args));
    }

    public static OutputStream resolveLoggingTargetStream(PrintStream stdout, PrintStream stderr, String[] args, int maxIndex) {
        for (int index = 0; index < maxIndex; ++index) {
            String argName = args[index];
            if (!"-E".equals(argName)) continue;
            if (index + 1 >= maxIndex) {
                SshClient.showError(stderr, "Missing " + argName + " option argument");
                return null;
            }
            String argVal = args[index + 1];
            if ("--".equals(argVal)) {
                return stdout;
            }
            try {
                Path path = Paths.get(argVal, new String[0]).normalize().toAbsolutePath();
                return Files.newOutputStream(path, new OpenOption[0]);
            }
            catch (IOException e) {
                SshClient.showError(stderr, "Failed (" + e.getClass().getSimpleName() + ") to open " + argVal + ": " + e.getMessage());
                return null;
            }
        }
        return stderr;
    }

    public static List<NamedFactory<Compression>> setupCompressions(Map<String, ?> options, PrintStream stderr) {
        String argVal = PropertyResolverUtils.getString(options, "Compression");
        if (GenericUtils.isEmpty(argVal)) {
            return Collections.emptyList();
        }
        CompressionConfigValue value = CompressionConfigValue.fromName(argVal);
        if (value == null) {
            SshClient.showError(stderr, "Unknown compression configuration value: " + argVal);
            return null;
        }
        return Collections.singletonList(value);
    }

    public static List<NamedFactory<Compression>> setupCompressions(String argName, String argVal, List<NamedFactory<Compression>> current, PrintStream stderr) {
        if (GenericUtils.size(current) > 0) {
            SshClient.showError(stderr, argName + " option value re-specified: " + NamedResource.Utils.getNames(current));
            return null;
        }
        BuiltinCompressions.ParseResult result = BuiltinCompressions.parseCompressionsList(argVal);
        List available = result.getParsedFactories();
        if (GenericUtils.isEmpty(available)) {
            SshClient.showError(stderr, "No known compressions in " + argVal);
            return null;
        }
        List<String> unsupported = result.getUnsupportedFactories();
        if (GenericUtils.size(unsupported) > 0) {
            stderr.append("Ignored unsupported compressions: ").println(GenericUtils.join(unsupported, ','));
        }
        return new ArrayList<NamedFactory<Compression>>(available);
    }

    public static List<NamedFactory<Mac>> setupMacs(Map<String, ?> options, PrintStream stderr) {
        String argVal = PropertyResolverUtils.getString(options, "MACs");
        return GenericUtils.isEmpty(argVal) ? Collections.emptyList() : SshClient.setupMacs("MACs", argVal, null, stderr);
    }

    public static List<NamedFactory<Mac>> setupMacs(String argName, String argVal, List<NamedFactory<Mac>> current, PrintStream stderr) {
        if (GenericUtils.size(current) > 0) {
            SshClient.showError(stderr, argName + " option value re-specified: " + NamedResource.Utils.getNames(current));
            return null;
        }
        BuiltinMacs.ParseResult result = BuiltinMacs.parseMacsList(argVal);
        List available = result.getParsedFactories();
        if (GenericUtils.isEmpty(available)) {
            SshClient.showError(stderr, "No known MACs in " + argVal);
            return null;
        }
        List<String> unsupported = result.getUnsupportedFactories();
        if (GenericUtils.size(unsupported) > 0) {
            stderr.append("Ignored unsupported MACs: ").println(GenericUtils.join(unsupported, ','));
        }
        return new ArrayList<NamedFactory<Mac>>(available);
    }

    public static List<NamedFactory<Cipher>> setupCiphers(Map<String, ?> options, PrintStream stderr) {
        String argVal = PropertyResolverUtils.getString(options, "Ciphers");
        return GenericUtils.isEmpty(argVal) ? Collections.emptyList() : SshClient.setupCiphers("Ciphers", argVal, null, stderr);
    }

    public static List<NamedFactory<Cipher>> setupCiphers(String argName, String argVal, List<NamedFactory<Cipher>> current, PrintStream stderr) {
        if (GenericUtils.size(current) > 0) {
            SshClient.showError(stderr, argName + " option value re-specified: " + NamedResource.Utils.getNames(current));
            return null;
        }
        BuiltinCiphers.ParseResult result = BuiltinCiphers.parseCiphersList(argVal);
        List available = result.getParsedFactories();
        if (GenericUtils.isEmpty(available)) {
            SshClient.showError(stderr, "No known ciphers in " + argVal);
            return null;
        }
        List<String> unsupported = result.getUnsupportedFactories();
        if (GenericUtils.size(unsupported) > 0) {
            stderr.append("Ignored unsupported ciphers: ").println(GenericUtils.join(unsupported, ','));
        }
        return new ArrayList<NamedFactory<Cipher>>(available);
    }

    public static Handler setupLogging(Level level, final PrintStream stdout, final PrintStream stderr, final OutputStream outputStream) {
        ConsoleHandler fh = new ConsoleHandler(){
            {
                this.setOutputStream(outputStream);
            }

            @Override
            protected synchronized void setOutputStream(OutputStream out) throws SecurityException {
                if (out == stdout || out == stderr) {
                    super.setOutputStream(new NoCloseOutputStream(out));
                } else {
                    super.setOutputStream(out);
                }
            }
        };
        fh.setLevel(Level.FINEST);
        fh.setFormatter(new Formatter(){

            @Override
            public String format(LogRecord record) {
                String message = this.formatMessage(record);
                String throwable = "";
                Throwable t = record.getThrown();
                if (t != null) {
                    StringWriter sw = new StringWriter();
                    try (PrintWriter pw = new PrintWriter(sw);){
                        pw.println();
                        t.printStackTrace(pw);
                    }
                    throwable = sw.toString();
                }
                return String.format("%1$tY-%1$tm-%1$td: %2$-7.7s: %3$-32.32s: %4$s%5$s%n", new Date(record.getMillis()), record.getLevel().getName(), record.getLoggerName(), message, throwable);
            }
        });
        Logger root = Logger.getLogger("");
        for (Handler handler : root.getHandlers()) {
            root.removeHandler(handler);
        }
        root.addHandler(fh);
        root.setLevel(level);
        return fh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        block83: {
            PrintStream stdout = System.out;
            PrintStream stderr = System.err;
            boolean agentForward = false;
            ArrayList<String> command = null;
            int socksPort = -1;
            int numArgs = GenericUtils.length(args);
            boolean error = false;
            String target = null;
            Level level = Level.WARNING;
            OutputStream logStream = stderr;
            for (int i = 0; i < numArgs; ++i) {
                String argName = args[i];
                if (GenericUtils.isEmpty(command) && SshClient.isArgumentedOption(SSH_CLIENT_PORT_OPTION, argName)) {
                    if (i + 1 >= numArgs) {
                        error = SshClient.showError(stderr, "option requires an argument: " + argName);
                        break;
                    }
                    ++i;
                    continue;
                }
                if (GenericUtils.isEmpty(command) && ("-v".equals(argName) || "-vv".equals(argName) || "-vvv".equals(argName))) continue;
                if (GenericUtils.isEmpty(command) && "-D".equals(argName)) {
                    if (i + 1 >= numArgs) {
                        error = SshClient.showError(stderr, "option requires an argument: " + argName);
                        break;
                    }
                    if (socksPort > 0) {
                        error = SshClient.showError(stderr, argName + " option value re-specified: " + socksPort);
                        break;
                    }
                    if ((socksPort = Integer.parseInt(args[++i])) > 0) continue;
                    error = SshClient.showError(stderr, "Bad option value for " + argName + ": " + socksPort);
                    break;
                }
                if (GenericUtils.isEmpty(command) && "-A".equals(argName)) {
                    agentForward = true;
                    continue;
                }
                if (GenericUtils.isEmpty(command) && "-a".equals(argName)) {
                    agentForward = false;
                    continue;
                }
                level = SshClient.resolveLoggingVerbosity(args, i);
                logStream = SshClient.resolveLoggingTargetStream(stdout, stderr, args, i);
                if (logStream == null) {
                    error = true;
                    break;
                }
                if (GenericUtils.isEmpty(command) && target == null) {
                    target = argName;
                    continue;
                }
                if (command == null) {
                    command = new ArrayList<String>();
                }
                command.add(argName);
            }
            ClientSession session = null;
            try (BufferedReader stdin = new BufferedReader(new InputStreamReader(new NoCloseInputStream(System.in)));){
                if (!error) {
                    SshClient.setupLogging(level, stdout, stderr, logStream);
                    session = SshClient.setupClientSession(SSH_CLIENT_PORT_OPTION, stdin, stdout, stderr, args);
                    if (session == null) {
                        error = true;
                    }
                }
                if (error) {
                    System.err.println("usage: ssh [-A|-a] [-v[v][v]] [-E logoutputfile] [-D socksPort] [-l login] [-p port] [-o option=value] [-w password] [-c cipherslist] [-m maclist] [-C] hostname/user@host [command]");
                    System.exit(-1);
                    return;
                }
                try (SshClient client = (SshClient)session.getFactoryManager();){
                    try {
                        PtyCapableChannelSession channel;
                        if (socksPort >= 0) {
                            session.startDynamicPortForwarding(new SshdSocketAddress("localhost", socksPort));
                            Thread.sleep(Long.MAX_VALUE);
                            break block83;
                        }
                        if (GenericUtils.isEmpty(command)) {
                            channel = session.createShellChannel();
                            channel.setAgentForwarding(agentForward);
                            channel.setIn(new NoCloseInputStream(System.in));
                        } else {
                            StringBuilder w = new StringBuilder();
                            for (String cmd : command) {
                                w.append(cmd).append(' ');
                            }
                            channel = session.createExecChannel(w.toString().trim());
                        }
                        try {
                            NoCloseOutputStream channelOut = new NoCloseOutputStream(System.out);
                            Object object = null;
                            try (NoCloseOutputStream channelErr = new NoCloseOutputStream(System.err);){
                                channel.setOut(channelOut);
                                channel.setErr(channelErr);
                                channel.open().await();
                                channel.waitFor(EnumSet.of(ClientChannelEvent.CLOSED), 0L);
                            }
                            catch (Throwable throwable) {
                                object = throwable;
                                throw throwable;
                            }
                            finally {
                                if (channelOut != null) {
                                    if (object != null) {
                                        try {
                                            ((OutputStream)channelOut).close();
                                        }
                                        catch (Throwable throwable) {
                                            ((Throwable)object).addSuppressed(throwable);
                                        }
                                    } else {
                                        ((OutputStream)channelOut).close();
                                    }
                                }
                            }
                        }
                        finally {
                            channel.close();
                        }
                        session.close(false);
                    }
                    finally {
                        client.stop();
                    }
                }
                finally {
                    session.close();
                }
            }
            finally {
                if (logStream != stdout && logStream != stderr) {
                    logStream.close();
                }
            }
        }
    }
}

