/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.subsystem.sftp;

import java.util.Collection;
import java.util.List;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.NumberUtils;
import org.apache.sshd.common.util.ValidateUtils;

public interface SftpVersionSelector {
    public static final SftpVersionSelector CURRENT = new SftpVersionSelector(){

        @Override
        public int selectVersion(int current, List<Integer> available) {
            return current;
        }
    };
    public static final SftpVersionSelector MAXIMUM = new SftpVersionSelector(){

        @Override
        public int selectVersion(int current, List<Integer> available) {
            int candidate = current;
            if (GenericUtils.size(available) > 0) {
                for (Number number : available) {
                    if (candidate >= number.intValue()) continue;
                    candidate = number.intValue();
                }
            }
            return candidate;
        }
    };
    public static final SftpVersionSelector MINIMUM = new SftpVersionSelector(){

        @Override
        public int selectVersion(int current, List<Integer> available) {
            int candidate = current;
            if (GenericUtils.size(available) > 0) {
                for (Number number : available) {
                    if (candidate <= number.intValue()) continue;
                    candidate = number.intValue();
                }
            }
            return candidate;
        }
    };

    public int selectVersion(int var1, List<Integer> var2);

    public static final class Utils {
        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static SftpVersionSelector fixedVersionSelector(final int version) {
            return new SftpVersionSelector(){

                @Override
                public int selectVersion(int current, List<Integer> available) {
                    return version;
                }
            };
        }

        public static SftpVersionSelector preferredVersionSelector(int ... preferred) {
            return Utils.preferredVersionSelector(NumberUtils.asList(preferred));
        }

        public static SftpVersionSelector preferredVersionSelector(final Iterable<? extends Number> preferred) {
            if (preferred instanceof Collection) {
                ValidateUtils.checkNotNullAndNotEmpty((Collection)preferred, "Empty preferred versions", new Object[0]);
            } else {
                ValidateUtils.checkNotNull(preferred, "No preferred versions");
            }
            return new SftpVersionSelector(){

                @Override
                public int selectVersion(int current, List<Integer> available) {
                    for (Number prefValue : preferred) {
                        int version = prefValue.intValue();
                        if (version == current) {
                            return version;
                        }
                        for (Integer avail : available) {
                            if (version != avail) continue;
                            return version;
                        }
                    }
                    throw new IllegalStateException("Preferred versions (" + preferred + ") not available: " + available);
                }
            };
        }
    }
}

