/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.cipher;

import org.apache.sshd.common.cipher.CipherInformation;
import org.apache.sshd.common.util.ValidateUtils;

public interface Cipher
extends CipherInformation {
    public void init(Mode var1, byte[] var2, byte[] var3) throws Exception;

    public void update(byte[] var1) throws Exception;

    public void update(byte[] var1, int var2, int var3) throws Exception;

    public static final class Utils {
        private Utils() {
            throw new UnsupportedOperationException("No instance allowed");
        }

        public static boolean checkSupported(String xform, int keyLength) {
            ValidateUtils.checkNotNullAndNotEmpty(xform, "No transformation");
            if (keyLength <= 0) {
                throw new IllegalArgumentException("Bad key length (" + keyLength + ") for cipher=" + xform);
            }
            try {
                int maxKeyLength = javax.crypto.Cipher.getMaxAllowedKeyLength(xform);
                return maxKeyLength >= keyLength;
            }
            catch (Exception e) {
                return false;
            }
        }
    }

    public static enum Mode {
        Encrypt,
        Decrypt;

    }
}

