/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.forward;

import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.SshException;
import org.apache.sshd.common.forward.TcpipClientChannel;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.closeable.AbstractCloseable;
import org.apache.sshd.common.util.net.SshdSocketAddress;

public class SocksProxy
extends AbstractCloseable
implements IoHandler {
    private final ConnectionService service;
    private final Map<IoSession, Proxy> proxies = new ConcurrentHashMap<IoSession, Proxy>();

    public SocksProxy(ConnectionService service) {
        this.service = service;
    }

    @Override
    public void sessionCreated(IoSession session) throws Exception {
        if (this.isClosing()) {
            throw new SshException("SocksProxy is closing or closed");
        }
    }

    @Override
    public void sessionClosed(IoSession session) throws Exception {
        Proxy proxy = this.proxies.remove(session);
        if (proxy != null) {
            proxy.close();
        }
    }

    @Override
    public void messageReceived(IoSession session, Readable message) throws Exception {
        ByteArrayBuffer buffer = new ByteArrayBuffer(message.available() + 64, false);
        buffer.putBuffer(message);
        Proxy proxy = this.proxies.get(session);
        if (proxy == null) {
            int version = buffer.getUByte();
            if (version == 4) {
                proxy = new Socks4(session);
            } else if (version == 5) {
                proxy = new Socks5(session);
            } else {
                throw new IllegalStateException("Unsupported version: " + version);
            }
            proxy.onMessage(buffer);
            this.proxies.put(session, proxy);
        } else {
            proxy.onMessage(buffer);
        }
    }

    @Override
    public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
        this.log.warn("Exception caught, closing socks proxy", cause);
        session.close(false);
    }

    public class Socks5
    extends Proxy {
        private byte[] authMethods;
        private Buffer response;

        public Socks5(IoSession session) {
            super(session);
        }

        @Override
        protected void onMessage(Buffer buffer) throws IOException {
            if (this.authMethods == null) {
                int nbAuthMethods = this.getUByte(buffer);
                this.authMethods = new byte[nbAuthMethods];
                buffer.getRawBytes(this.authMethods);
                boolean foundNoAuth = false;
                for (int i = 0; i < nbAuthMethods; ++i) {
                    foundNoAuth |= this.authMethods[i] == 0;
                }
                buffer = new ByteArrayBuffer(8, false);
                buffer.putByte((byte)5);
                buffer.putByte((byte)(foundNoAuth ? 0 : 255));
                this.session.write(buffer);
                if (!foundNoAuth) {
                    throw new IllegalStateException("Received socks5 greeting without NoAuth method");
                }
                SocksProxy.this.log.debug("Received socks5 greeting");
            } else if (this.channel == null) {
                String host;
                int type;
                this.response = buffer;
                int version = this.getUByte(buffer);
                if (version != 5) {
                    throw new IllegalStateException("Unexpected version: " + version);
                }
                int cmd = buffer.getUByte();
                if (cmd != 1) {
                    throw new IllegalStateException("Unsupported socks command: " + cmd);
                }
                int res = buffer.getUByte();
                if (res != 0) {
                    SocksProxy.this.log.debug("No zero reserved value: " + res);
                }
                if ((type = buffer.getUByte()) == 1) {
                    host = Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer));
                } else if (type == 3) {
                    host = this.getBLString(buffer);
                } else if (type == 4) {
                    host = Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer)) + ":" + Integer.toHexString(this.getUShort(buffer));
                } else {
                    throw new IllegalStateException("Unsupported address type: " + type);
                }
                int port = this.getUShort(buffer);
                if (SocksProxy.this.log.isDebugEnabled()) {
                    SocksProxy.this.log.debug("Received socks5 connection request to {}:{}", (Object)host, (Object)port);
                }
                SshdSocketAddress remote = new SshdSocketAddress(host, port);
                this.channel = new TcpipClientChannel(TcpipClientChannel.Type.Direct, this.session, remote);
                SocksProxy.this.service.registerChannel(this.channel);
                this.channel.open().addListener(new SshFutureListener<OpenFuture>(){

                    @Override
                    public void operationComplete(OpenFuture future) {
                        Socks5.this.onChannelOpened(future);
                    }
                });
            } else {
                SocksProxy.this.log.debug("Received socks5 connection message");
                super.onMessage(buffer);
            }
        }

        protected void onChannelOpened(OpenFuture future) {
            int wpos = this.response.wpos();
            this.response.rpos(0);
            this.response.wpos(1);
            Throwable t = future.getException();
            if (t != null) {
                SocksProxy.this.service.unregisterChannel(this.channel);
                this.channel.close(false);
                this.response.putByte((byte)1);
            } else {
                this.response.putByte((byte)0);
            }
            this.response.wpos(wpos);
            this.session.write(this.response);
        }

        private String getBLString(Buffer buffer) {
            int length = this.getUByte(buffer);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < length; ++i) {
                sb.append((char)this.getUByte(buffer));
            }
            return sb.toString();
        }
    }

    public class Socks4
    extends Proxy {
        public Socks4(IoSession session) {
            super(session);
        }

        @Override
        protected void onMessage(Buffer buffer) throws IOException {
            if (this.channel == null) {
                int cmd = buffer.getUByte();
                if (cmd != 1) {
                    throw new IllegalStateException("Unsupported socks command: " + cmd);
                }
                int port = this.getUShort(buffer);
                String host = Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer)) + "." + Integer.toString(this.getUByte(buffer));
                String userId = this.getNTString(buffer);
                if (host.startsWith("0.0.0.")) {
                    host = this.getNTString(buffer);
                }
                if (SocksProxy.this.log.isDebugEnabled()) {
                    SocksProxy.this.log.debug("Received socks4 connection request for {} to {}:{}", new Object[]{userId, host, port});
                }
                SshdSocketAddress remote = new SshdSocketAddress(host, port);
                this.channel = new TcpipClientChannel(TcpipClientChannel.Type.Direct, this.session, remote);
                SocksProxy.this.service.registerChannel(this.channel);
                this.channel.open().addListener(new SshFutureListener<OpenFuture>(){

                    @Override
                    public void operationComplete(OpenFuture future) {
                        Socks4.this.onChannelOpened(future);
                    }
                });
            } else {
                super.onMessage(buffer);
            }
        }

        protected void onChannelOpened(OpenFuture future) {
            ByteArrayBuffer buffer = new ByteArrayBuffer(64, false);
            ((Buffer)buffer).putByte((byte)0);
            Throwable t = future.getException();
            if (t != null) {
                SocksProxy.this.service.unregisterChannel(this.channel);
                this.channel.close(false);
                ((Buffer)buffer).putByte((byte)91);
            } else {
                ((Buffer)buffer).putByte((byte)90);
            }
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            ((Buffer)buffer).putByte((byte)0);
            this.session.write(buffer);
        }

        private String getNTString(Buffer buffer) {
            char c;
            StringBuilder sb = new StringBuilder();
            while ((c = (char)this.getUByte(buffer)) != '\u0000') {
                sb.append(c);
            }
            return sb.toString();
        }
    }

    public abstract class Proxy
    implements Closeable {
        IoSession session;
        TcpipClientChannel channel;

        protected Proxy(IoSession session) {
            this.session = session;
        }

        protected void onMessage(Buffer buffer) throws IOException {
            this.channel.getInvertedIn().write(buffer.array(), buffer.rpos(), buffer.available());
            this.channel.getInvertedIn().flush();
        }

        @Override
        public void close() throws IOException {
            if (this.channel != null) {
                this.channel.close(false);
            }
        }

        protected int getUByte(Buffer buffer) {
            return buffer.getUByte();
        }

        protected int getUShort(Buffer buffer) {
            return (this.getUByte(buffer) << 8) + this.getUByte(buffer);
        }
    }
}

