/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.kex;

import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PublicKey;
import javax.crypto.KeyAgreement;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.digest.Digest;
import org.apache.sshd.common.kex.AbstractDH;
import org.apache.sshd.common.util.SecurityUtils;

public class DHG
extends AbstractDH {
    private BigInteger p;
    private BigInteger g;
    private BigInteger e;
    private byte[] e_array;
    private BigInteger f;
    private KeyPairGenerator myKpairGen = SecurityUtils.getKeyPairGenerator("DH");
    private KeyAgreement myKeyAgree = SecurityUtils.getKeyAgreement("DH");
    private Factory<? extends Digest> factory;

    public DHG(Factory<? extends Digest> digestFactory) throws Exception {
        this(digestFactory, null, null);
    }

    public DHG(Factory<? extends Digest> digestFactory, BigInteger pValue, BigInteger gValue) throws Exception {
        this.factory = digestFactory;
        this.p = pValue;
        this.g = gValue;
    }

    @Override
    public byte[] getE() throws Exception {
        if (this.e == null) {
            DHParameterSpec dhSkipParamSpec = new DHParameterSpec(this.p, this.g);
            this.myKpairGen.initialize(dhSkipParamSpec);
            KeyPair myKpair = this.myKpairGen.generateKeyPair();
            this.myKeyAgree.init(myKpair.getPrivate());
            this.e = ((DHPublicKey)myKpair.getPublic()).getY();
            this.e_array = this.e.toByteArray();
        }
        return this.e_array;
    }

    @Override
    protected byte[] calculateK() throws Exception {
        KeyFactory myKeyFac = SecurityUtils.getKeyFactory("DH");
        DHPublicKeySpec keySpec = new DHPublicKeySpec(this.f, this.p, this.g);
        PublicKey yourPubKey = myKeyFac.generatePublic(keySpec);
        this.myKeyAgree.doPhase(yourPubKey, true);
        return DHG.stripLeadingZeroes(this.myKeyAgree.generateSecret());
    }

    public void setP(byte[] p) {
        this.setP(new BigInteger(p));
    }

    public void setG(byte[] g) {
        this.setG(new BigInteger(g));
    }

    @Override
    public void setF(byte[] f) {
        this.setF(new BigInteger(f));
    }

    public BigInteger getP() {
        return this.p;
    }

    public void setP(BigInteger p) {
        this.p = p;
    }

    public BigInteger getG() {
        return this.g;
    }

    public void setG(BigInteger g) {
        this.g = g;
    }

    public void setF(BigInteger f) {
        this.f = f;
    }

    @Override
    public Digest getHash() throws Exception {
        return this.factory.create();
    }
}

