/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.security.GeneralSecurityException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.Signature;
import java.security.cert.CertificateFactory;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicInteger;
import javax.crypto.Cipher;
import javax.crypto.KeyAgreement;
import javax.crypto.Mac;
import javax.crypto.spec.DHParameterSpec;
import org.apache.sshd.common.config.keys.FilePasswordProvider;
import org.apache.sshd.common.keyprovider.AbstractClassLoadableResourceKeyPairProvider;
import org.apache.sshd.common.keyprovider.AbstractFileKeyPairProvider;
import org.apache.sshd.common.random.AbstractRandom;
import org.apache.sshd.common.random.AbstractRandomFactory;
import org.apache.sshd.common.random.JceRandomFactory;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.random.RandomFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.bouncycastle.crypto.prng.RandomGenerator;
import org.bouncycastle.crypto.prng.VMPCRandomGenerator;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMDecryptorProvider;
import org.bouncycastle.openssl.PEMEncryptedKeyPair;
import org.bouncycastle.openssl.PEMKeyPair;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.openssl.jcajce.JcaPEMKeyConverter;
import org.bouncycastle.openssl.jcajce.JcePEMDecryptorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SecurityUtils {
    public static final String BOUNCY_CASTLE = "BC";
    public static final String MAX_DHGEX_KEY_SIZE_PROP = "org.apache.sshd.maxDHGexKeySize";
    public static final int MIN_DHGEX_KEY_SIZE = 1024;
    public static final int DEFAULT_DHGEX_KEY_SIZE = 1024;
    public static final int PREFERRED_DHGEX_KEY_SIZE = 4096;
    public static final int MAX_DHGEX_KEY_SIZE = 8192;
    public static final String REGISTER_BOUNCY_CASTLE_PROP = "org.apache.sshd.registerBouncyCastle";
    public static final String ECC_SUPPORTED_PROP = "org.apache.sshd.eccSupport";
    private static final AtomicInteger MAX_DHG_KEY_SIZE_HOLDER = new AtomicInteger(0);
    private static String securityProvider;
    private static Boolean registerBouncyCastle;
    private static boolean registrationDone;
    private static Boolean hasEcc;

    private SecurityUtils() {
        throw new UnsupportedOperationException("No instance");
    }

    public static boolean hasEcc() {
        if (hasEcc == null) {
            String propValue = System.getProperty(ECC_SUPPORTED_PROP);
            if (GenericUtils.isEmpty(propValue)) {
                try {
                    SecurityUtils.getKeyPairGenerator("EC");
                    hasEcc = Boolean.TRUE;
                }
                catch (Throwable t) {
                    hasEcc = Boolean.FALSE;
                }
            } else {
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.info("Override ECC support value: " + propValue);
                hasEcc = Boolean.valueOf(propValue);
            }
        }
        return hasEcc;
    }

    public static boolean isDHGroupExchangeSupported() {
        return SecurityUtils.getMaxDHGroupExchangeKeySize() > 0;
    }

    public static boolean isDHOakelyGroupSupported(int keySize) {
        return SecurityUtils.getMaxDHGroupExchangeKeySize() >= keySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getMaxDHGroupExchangeKeySize() {
        int maxSupportedKeySize;
        AtomicInteger atomicInteger = MAX_DHG_KEY_SIZE_HOLDER;
        synchronized (atomicInteger) {
            maxSupportedKeySize = MAX_DHG_KEY_SIZE_HOLDER.get();
            if (maxSupportedKeySize != 0) {
                return maxSupportedKeySize;
            }
            String propValue = System.getProperty(MAX_DHGEX_KEY_SIZE_PROP);
            if (GenericUtils.isEmpty(propValue)) {
                maxSupportedKeySize = -1;
                for (int testKeySize = 8192; testKeySize >= 1024; testKeySize -= 1024) {
                    if (!SecurityUtils.isDHGroupExchangeSupported(testKeySize)) continue;
                    maxSupportedKeySize = testKeySize;
                    break;
                }
            } else {
                Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.info("Override max. DH group exchange key size: " + propValue);
                maxSupportedKeySize = Integer.parseInt(propValue);
                ValidateUtils.checkTrue(maxSupportedKeySize != 0, "Configured org.apache.sshd.maxDHGexKeySize value must be non-zero: %d", maxSupportedKeySize);
            }
            MAX_DHG_KEY_SIZE_HOLDER.set(maxSupportedKeySize);
        }
        return maxSupportedKeySize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setMaxDHGroupExchangeKeySize(int keySize) {
        AtomicInteger atomicInteger = MAX_DHG_KEY_SIZE_HOLDER;
        synchronized (atomicInteger) {
            MAX_DHG_KEY_SIZE_HOLDER.set(keySize);
        }
    }

    public static boolean isDHGroupExchangeSupported(int maxKeySize) {
        ValidateUtils.checkTrue(maxKeySize > 8, "Invalid max. key size: %d", maxKeySize);
        try {
            BigInteger r = new BigInteger("0").setBit(maxKeySize - 1);
            DHParameterSpec dhSkipParamSpec = new DHParameterSpec(r, r);
            KeyPairGenerator kpg = SecurityUtils.getKeyPairGenerator("DH");
            kpg.initialize(dhSkipParamSpec);
            return true;
        }
        catch (GeneralSecurityException t) {
            return false;
        }
    }

    public static synchronized void setSecurityProvider(String securityProvider) {
        SecurityUtils.securityProvider = securityProvider;
        registrationDone = false;
    }

    public static synchronized void setRegisterBouncyCastle(boolean registerBouncyCastle) {
        SecurityUtils.registerBouncyCastle = registerBouncyCastle;
        registrationDone = false;
    }

    public static synchronized String getSecurityProvider() {
        SecurityUtils.register();
        return securityProvider;
    }

    public static synchronized boolean isBouncyCastleRegistered() {
        SecurityUtils.register();
        return BOUNCY_CASTLE.equals(securityProvider);
    }

    private static void register() {
        if (!registrationDone) {
            Logger logger;
            String propValue;
            if (registerBouncyCastle == null && !GenericUtils.isEmpty(propValue = System.getProperty(REGISTER_BOUNCY_CASTLE_PROP))) {
                logger = LoggerFactory.getLogger(SecurityUtils.class);
                logger.info("Override BouncyCastle registration value: " + propValue);
                registerBouncyCastle = Boolean.valueOf(propValue);
            }
            if (securityProvider == null && (registerBouncyCastle == null || registerBouncyCastle.booleanValue())) {
                try {
                    new BouncyCastleRegistration().call();
                }
                catch (Throwable t) {
                    logger = LoggerFactory.getLogger(SecurityUtils.class);
                    if (registerBouncyCastle == null) {
                        logger.info("BouncyCastle not registered, using the default JCE provider");
                    }
                    logger.error("Failed {} to register BouncyCastle as the defaut JCE provider: {}", (Object)t.getClass().getSimpleName(), (Object)t.getMessage());
                    throw new RuntimeException("Failed to register BouncyCastle as the defaut JCE provider", t);
                }
            }
            registrationDone = true;
        }
    }

    public static KeyPair loadKeyPairIdentity(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
        if (!SecurityUtils.isBouncyCastleRegistered()) {
            throw new NoSuchProviderException("BouncyCastle not registered");
        }
        return BouncyCastleInputStreamLoader.loadKeyPair(resourceKey, inputStream, provider);
    }

    public static AbstractFileKeyPairProvider createFileKeyPairProvider() {
        return new BouncyCastleFileKeyPairProvider();
    }

    public static AbstractClassLoadableResourceKeyPairProvider createClassLoadableResourceKeyPairProvider() {
        return new BouncyCastleClassLoadableResourceKeyPairProvider();
    }

    public static AbstractGeneratorHostKeyProvider createGeneratorHostKeyProvider(Path path) {
        return new BouncyCastleGeneratorHostKeyProvider(path);
    }

    public static RandomFactory getRandomFactory() {
        if (SecurityUtils.isBouncyCastleRegistered()) {
            return BouncyCastleRandomFactory.INSTANCE;
        }
        return JceRandomFactory.INSTANCE;
    }

    public static synchronized KeyFactory getKeyFactory(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return KeyFactory.getInstance(algorithm);
        }
        return KeyFactory.getInstance(algorithm, providerName);
    }

    public static synchronized Cipher getCipher(String transformation) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return Cipher.getInstance(transformation);
        }
        return Cipher.getInstance(transformation, providerName);
    }

    public static synchronized MessageDigest getMessageDigest(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return MessageDigest.getInstance(algorithm);
        }
        return MessageDigest.getInstance(algorithm, providerName);
    }

    public static synchronized KeyPairGenerator getKeyPairGenerator(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return KeyPairGenerator.getInstance(algorithm);
        }
        return KeyPairGenerator.getInstance(algorithm, providerName);
    }

    public static synchronized KeyAgreement getKeyAgreement(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return KeyAgreement.getInstance(algorithm);
        }
        return KeyAgreement.getInstance(algorithm, providerName);
    }

    public static synchronized Mac getMac(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return Mac.getInstance(algorithm);
        }
        return Mac.getInstance(algorithm, providerName);
    }

    public static synchronized Signature getSignature(String algorithm) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return Signature.getInstance(algorithm);
        }
        return Signature.getInstance(algorithm, providerName);
    }

    public static synchronized CertificateFactory getCertificateFactory(String type) throws GeneralSecurityException {
        SecurityUtils.register();
        String providerName = SecurityUtils.getSecurityProvider();
        if (GenericUtils.isEmpty(providerName)) {
            return CertificateFactory.getInstance(type);
        }
        return CertificateFactory.getInstance(type, providerName);
    }

    public static final class BouncyCastleRandom
    extends AbstractRandom {
        public static final String NAME = "BC";
        private final RandomGenerator random;

        BouncyCastleRandom() {
            ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
            this.random = new VMPCRandomGenerator();
            byte[] seed = new SecureRandom().generateSeed(8);
            this.random.addSeedMaterial(seed);
        }

        @Override
        public String getName() {
            return "BC";
        }

        @Override
        public void fill(byte[] bytes, int start, int len) {
            this.random.nextBytes(bytes, start, len);
        }

        @Override
        public int random(int n) {
            int val;
            int bits;
            ValidateUtils.checkTrue(n > 0, "Limit must be positive: %d", n);
            if ((n & -n) == n) {
                return (int)((long)n * (long)this.next(31) >> 31);
            }
            while ((bits = this.next(31)) - (val = bits % n) + (n - 1) < 0) {
            }
            return val;
        }

        private int next(int numBits) {
            int bytes = (numBits + 7) / 8;
            byte[] next = new byte[bytes];
            int ret = 0;
            this.random.nextBytes(next);
            for (int i = 0; i < bytes; ++i) {
                ret = next[i] & 0xFF | ret << 8;
            }
            return ret >>> bytes * 8 - numBits;
        }
    }

    public static final class BouncyCastleRandomFactory
    extends AbstractRandomFactory {
        public static final String NAME = "bouncycastle";
        private static final BouncyCastleRandomFactory INSTANCE = new BouncyCastleRandomFactory();

        public BouncyCastleRandomFactory() {
            super(NAME);
        }

        @Override
        public boolean isSupported() {
            return SecurityUtils.isBouncyCastleRegistered();
        }

        @Override
        public Random create() {
            return new BouncyCastleRandom();
        }
    }

    private static final class BouncyCastleGeneratorHostKeyProvider
    extends AbstractGeneratorHostKeyProvider {
        private BouncyCastleGeneratorHostKeyProvider(Path path) {
            ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
            this.setPath(path);
        }

        @Override
        protected KeyPair doReadKeyPair(String resourceKey, InputStream inputStream) throws IOException, GeneralSecurityException {
            return BouncyCastleInputStreamLoader.loadKeyPair(resourceKey, inputStream, null);
        }

        @Override
        protected void doWriteKeyPair(String resourceKey, KeyPair kp, OutputStream outputStream) throws IOException, GeneralSecurityException {
            try (PEMWriter w = new PEMWriter((Writer)new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));){
                w.writeObject((Object)kp);
                w.flush();
            }
        }
    }

    private static final class BouncyCastleClassLoadableResourceKeyPairProvider
    extends AbstractClassLoadableResourceKeyPairProvider {
        private BouncyCastleClassLoadableResourceKeyPairProvider() {
            ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        }

        @Override
        protected KeyPair doLoadKey(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
            return BouncyCastleInputStreamLoader.loadKeyPair(resourceKey, inputStream, provider);
        }
    }

    private static final class BouncyCastleFileKeyPairProvider
    extends AbstractFileKeyPairProvider {
        private BouncyCastleFileKeyPairProvider() {
            ValidateUtils.checkTrue(SecurityUtils.isBouncyCastleRegistered(), "BouncyCastle not registered");
        }

        @Override
        protected KeyPair doLoadKey(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
            return BouncyCastleInputStreamLoader.loadKeyPair(resourceKey, inputStream, provider);
        }
    }

    private static class BouncyCastleInputStreamLoader {
        private BouncyCastleInputStreamLoader() {
        }

        public static KeyPair loadKeyPair(String resourceKey, InputStream inputStream, FilePasswordProvider provider) throws IOException, GeneralSecurityException {
            Throwable throwable = null;
            try (PEMParser r = new PEMParser((Reader)new InputStreamReader(inputStream, StandardCharsets.UTF_8));){
                KeyPair keyPair;
                Object o = r.readObject();
                JcaPEMKeyConverter pemConverter = new JcaPEMKeyConverter();
                pemConverter.setProvider(SecurityUtils.BOUNCY_CASTLE);
                if (o instanceof PEMEncryptedKeyPair) {
                    ValidateUtils.checkNotNull(provider, "No password provider for resource=%s", (Object)resourceKey);
                    String password = ValidateUtils.checkNotNullAndNotEmpty(provider.getPassword(resourceKey), "No password provided for resource=%s", (Object)resourceKey);
                    JcePEMDecryptorProviderBuilder decryptorBuilder = new JcePEMDecryptorProviderBuilder();
                    PEMDecryptorProvider pemDecryptor = decryptorBuilder.build(password.toCharArray());
                    o = ((PEMEncryptedKeyPair)o).decryptKeyPair(pemDecryptor);
                }
                if (o instanceof PEMKeyPair) {
                    keyPair = pemConverter.getKeyPair((PEMKeyPair)o);
                    return keyPair;
                }
                if (o instanceof KeyPair) {
                    keyPair = (KeyPair)o;
                    return keyPair;
                }
                try {
                    throw new IOException("Failed to read " + resourceKey + " - unknown result object: " + o);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }
    }

    private static class BouncyCastleRegistration
    implements Callable<Void> {
        private BouncyCastleRegistration() {
        }

        @Override
        public Void call() throws Exception {
            Logger logger = LoggerFactory.getLogger(SecurityUtils.class);
            if (Security.getProvider(SecurityUtils.BOUNCY_CASTLE) == null) {
                logger.info("Trying to register BouncyCastle as a JCE provider");
                Security.addProvider((Provider)new BouncyCastleProvider());
                MessageDigest.getInstance("MD5", SecurityUtils.BOUNCY_CASTLE);
                KeyAgreement.getInstance("DH", SecurityUtils.BOUNCY_CASTLE);
                logger.info("Registration succeeded");
            } else {
                logger.info("BouncyCastle already registered as a JCE provider");
            }
            securityProvider = SecurityUtils.BOUNCY_CASTLE;
            return null;
        }
    }
}

