/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.util.closeable;

import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.future.CloseFuture;

public final class CloseableUtils {
    public static final String CLOSE_WAIT_TIMEOUT = "sshd-close-wait-time";
    public static final long DEFAULT_CLOSE_WAIT_TIMEOUT = TimeUnit.SECONDS.toMillis(15L);

    private CloseableUtils() {
        throw new UnsupportedOperationException("No instance allowed");
    }

    public static long getMaxCloseWaitTime(PropertyResolver resolver) {
        return resolver == null ? DEFAULT_CLOSE_WAIT_TIMEOUT : PropertyResolverUtils.getLongProperty(resolver, CLOSE_WAIT_TIMEOUT, DEFAULT_CLOSE_WAIT_TIMEOUT);
    }

    public static void close(Closeable closeable) throws IOException {
        long maxWait;
        CloseFuture future;
        boolean successful;
        if (closeable == null) {
            return;
        }
        if (!(closeable.isClosed() || closeable.isClosing() || (successful = (future = closeable.close(true)).await(maxWait = closeable instanceof PropertyResolver ? CloseableUtils.getMaxCloseWaitTime((PropertyResolver)((Object)closeable)) : DEFAULT_CLOSE_WAIT_TIMEOUT)))) {
            throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
        }
    }
}

