/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.common.Closeable;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.PropertyResolver;
import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.helpers.AbstractFactoryManager;
import org.apache.sshd.common.io.IoAcceptor;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.mina.MinaServiceFactory;
import org.apache.sshd.common.io.nio2.Nio2ServiceFactory;
import org.apache.sshd.common.session.helpers.AbstractSession;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.server.Command;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.ServerAuthenticationManager;
import org.apache.sshd.server.ServerBuilder;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.auth.UserAuth;
import org.apache.sshd.server.auth.gss.GSSAuthenticator;
import org.apache.sshd.server.auth.hostbased.HostBasedAuthenticator;
import org.apache.sshd.server.auth.keyboard.KeyboardInteractiveAuthenticator;
import org.apache.sshd.server.auth.password.PasswordAuthenticator;
import org.apache.sshd.server.auth.pubkey.AcceptAllPublickeyAuthenticator;
import org.apache.sshd.server.auth.pubkey.PublickeyAuthenticator;
import org.apache.sshd.server.forward.AcceptAllForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.keyprovider.AbstractGeneratorHostKeyProvider;
import org.apache.sshd.server.keyprovider.SimpleGeneratorHostKeyProvider;
import org.apache.sshd.server.scp.ScpCommandFactory;
import org.apache.sshd.server.session.ServerConnectionServiceFactory;
import org.apache.sshd.server.session.ServerProxyAcceptor;
import org.apache.sshd.server.session.ServerSession;
import org.apache.sshd.server.session.ServerUserAuthServiceFactory;
import org.apache.sshd.server.session.SessionFactory;
import org.apache.sshd.server.shell.InteractiveProcessShellFactory;
import org.apache.sshd.server.shell.ProcessShellFactory;
import org.apache.sshd.server.subsystem.sftp.SftpSubsystemFactory;

public class SshServer
extends AbstractFactoryManager
implements ServerFactoryManager,
Closeable {
    public static final Factory<SshServer> DEFAULT_SSH_SERVER_FACTORY = new Factory<SshServer>(){

        @Override
        public SshServer create() {
            return new SshServer();
        }
    };
    public static final List<ServiceFactory> DEFAULT_SERVICE_FACTORIES = Collections.unmodifiableList(Arrays.asList(ServerUserAuthServiceFactory.INSTANCE, ServerConnectionServiceFactory.INSTANCE));
    protected IoAcceptor acceptor;
    protected String host;
    protected int port;
    private ServerProxyAcceptor proxyAcceptor;
    private Factory<Command> shellFactory;
    private SessionFactory sessionFactory;
    private CommandFactory commandFactory;
    private List<NamedFactory<Command>> subsystemFactories;
    private List<NamedFactory<UserAuth>> userAuthFactories;
    private PasswordAuthenticator passwordAuthenticator;
    private PublickeyAuthenticator publickeyAuthenticator;
    private KeyboardInteractiveAuthenticator interactiveAuthenticator;
    private HostBasedAuthenticator hostBasedAuthenticator;
    private GSSAuthenticator gssAuthenticator;

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    @Override
    public List<NamedFactory<UserAuth>> getUserAuthFactories() {
        return this.userAuthFactories;
    }

    @Override
    public void setUserAuthFactories(List<NamedFactory<UserAuth>> userAuthFactories) {
        this.userAuthFactories = userAuthFactories;
    }

    @Override
    public Factory<Command> getShellFactory() {
        return this.shellFactory;
    }

    public void setShellFactory(Factory<Command> shellFactory) {
        this.shellFactory = shellFactory;
    }

    public SessionFactory getSessionFactory() {
        return this.sessionFactory;
    }

    public void setSessionFactory(SessionFactory sessionFactory) {
        this.sessionFactory = sessionFactory;
    }

    @Override
    public ServerProxyAcceptor getServerProxyAcceptor() {
        return this.proxyAcceptor;
    }

    @Override
    public void setServerProxyAcceptor(ServerProxyAcceptor proxyAcceptor) {
        this.proxyAcceptor = proxyAcceptor;
    }

    @Override
    public CommandFactory getCommandFactory() {
        return this.commandFactory;
    }

    public void setCommandFactory(CommandFactory commandFactory) {
        this.commandFactory = commandFactory;
    }

    @Override
    public List<NamedFactory<Command>> getSubsystemFactories() {
        return this.subsystemFactories;
    }

    public void setSubsystemFactories(List<NamedFactory<Command>> subsystemFactories) {
        this.subsystemFactories = subsystemFactories;
    }

    @Override
    public PasswordAuthenticator getPasswordAuthenticator() {
        return this.passwordAuthenticator;
    }

    @Override
    public void setPasswordAuthenticator(PasswordAuthenticator passwordAuthenticator) {
        this.passwordAuthenticator = passwordAuthenticator;
    }

    @Override
    public PublickeyAuthenticator getPublickeyAuthenticator() {
        return this.publickeyAuthenticator;
    }

    @Override
    public void setPublickeyAuthenticator(PublickeyAuthenticator publickeyAuthenticator) {
        this.publickeyAuthenticator = publickeyAuthenticator;
    }

    @Override
    public KeyboardInteractiveAuthenticator getKeyboardInteractiveAuthenticator() {
        return this.interactiveAuthenticator;
    }

    @Override
    public void setKeyboardInteractiveAuthenticator(KeyboardInteractiveAuthenticator interactiveAuthenticator) {
        this.interactiveAuthenticator = interactiveAuthenticator;
    }

    @Override
    public GSSAuthenticator getGSSAuthenticator() {
        return this.gssAuthenticator;
    }

    @Override
    public void setGSSAuthenticator(GSSAuthenticator gssAuthenticator) {
        this.gssAuthenticator = gssAuthenticator;
    }

    @Override
    public HostBasedAuthenticator getHostBasedAuthenticator() {
        return this.hostBasedAuthenticator;
    }

    @Override
    public void setHostBasedAuthenticator(HostBasedAuthenticator hostBasedAuthenticator) {
        this.hostBasedAuthenticator = hostBasedAuthenticator;
    }

    @Override
    public void setTcpipForwardingFilter(ForwardingFilter forwardingFilter) {
        this.tcpipForwardingFilter = forwardingFilter;
    }

    @Override
    protected void checkConfig() {
        super.checkConfig();
        ValidateUtils.checkTrue(this.getPort() >= 0, "Bad port number: %d", (Object)this.getPort());
        List<NamedFactory<UserAuth>> authFactories = ServerAuthenticationManager.Utils.resolveUserAuthFactories(this);
        this.setUserAuthFactories(ValidateUtils.checkNotNullAndNotEmpty(authFactories, "UserAuthFactories not set", new Object[0]));
        ValidateUtils.checkNotNullAndNotEmpty(this.getChannelFactories(), "ChannelFactories not set", new Object[0]);
        ValidateUtils.checkNotNull(this.getKeyPairProvider(), "HostKeyProvider not set");
        ValidateUtils.checkNotNull(this.getFileSystemFactory(), "FileSystemFactory not set");
        if (GenericUtils.isEmpty(this.getServiceFactories())) {
            this.setServiceFactories(DEFAULT_SERVICE_FACTORIES);
        }
    }

    public void start() throws IOException {
        this.checkConfig();
        if (this.sessionFactory == null) {
            this.sessionFactory = this.createSessionFactory();
        }
        this.acceptor = this.createAcceptor();
        this.setupSessionTimeout(this.sessionFactory);
        String hostsList = this.getHost();
        if (!GenericUtils.isEmpty(hostsList)) {
            String[] hosts;
            for (String host : hosts = GenericUtils.split(hostsList, ',')) {
                InetAddress[] inetAddresses;
                if (this.log.isDebugEnabled()) {
                    this.log.debug("start() - resolve bind host={}", (Object)host);
                }
                for (InetAddress inetAddress : inetAddresses = InetAddress.getAllByName(host)) {
                    if (this.log.isTraceEnabled()) {
                        this.log.trace("start() - bind host={} / {}", (Object)host, (Object)inetAddress);
                    }
                    this.acceptor.bind(new InetSocketAddress(inetAddress, this.port));
                    if (this.port != 0) continue;
                    this.port = ((InetSocketAddress)this.acceptor.getBoundAddresses().iterator().next()).getPort();
                    this.log.info("start() listen on auto-allocated port=" + this.port);
                }
            }
        } else {
            this.acceptor.bind(new InetSocketAddress(this.port));
            if (this.port == 0) {
                this.port = ((InetSocketAddress)this.acceptor.getBoundAddresses().iterator().next()).getPort();
                this.log.info("start() listen on auto-allocated port=" + this.port);
            }
        }
    }

    public void stop() throws IOException {
        this.stop(false);
    }

    public void stop(boolean immediately) throws IOException {
        long maxWait = immediately ? PropertyResolverUtils.getLongProperty(this, "stop-wait-time", DEFAULT_STOP_WAIT_TIME) : Long.MAX_VALUE;
        boolean successful = this.close(immediately).await(maxWait);
        if (!successful) {
            throw new SocketTimeoutException("Failed to receive closure confirmation within " + maxWait + " millis");
        }
    }

    public void open() throws IOException {
        this.start();
    }

    @Override
    protected Closeable getInnerCloseable() {
        return this.builder().run(new Runnable(){

            @Override
            public void run() {
                SshServer.this.removeSessionTimeout(SshServer.this.sessionFactory);
            }
        }).sequential(this.acceptor, this.ioServiceFactory).run(new Runnable(){

            @Override
            public void run() {
                SshServer.this.acceptor = null;
                SshServer.this.ioServiceFactory = null;
                if (SshServer.this.shutdownExecutor && SshServer.this.executor != null && !SshServer.this.executor.isShutdown()) {
                    try {
                        SshServer.this.executor.shutdownNow();
                    }
                    finally {
                        SshServer.this.executor = null;
                    }
                }
            }
        }).build();
    }

    public List<AbstractSession> getActiveSessions() {
        ArrayList<AbstractSession> sessions = new ArrayList<AbstractSession>();
        for (IoSession ioSession : this.acceptor.getManagedSessions().values()) {
            AbstractSession session = AbstractSession.getSession(ioSession, true);
            if (session == null) continue;
            sessions.add(session);
        }
        return sessions;
    }

    protected IoAcceptor createAcceptor() {
        return this.getIoServiceFactory().createAcceptor(this.getSessionFactory());
    }

    protected SessionFactory createSessionFactory() {
        return new SessionFactory(this);
    }

    public String toString() {
        return "SshServer[" + Integer.toHexString(this.hashCode()) + "]";
    }

    public static SshServer setUpDefaultServer() {
        return (SshServer)ServerBuilder.builder().build();
    }

    public static void main(String[] args) throws Exception {
        AbstractGeneratorHostKeyProvider hostKeyProvider;
        Path hostKeyFile;
        int port = 8000;
        boolean error = false;
        String hostKeyType = "DSA";
        LinkedHashMap<String, String> options = new LinkedHashMap<String, String>();
        int numArgs = GenericUtils.length(args);
        for (int i = 0; i < numArgs; ++i) {
            String argName = args[i];
            if ("-p".equals(argName)) {
                if (i + 1 >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    break;
                }
                port = Integer.parseInt(args[++i]);
                continue;
            }
            if ("-key-type".equals(argName)) {
                if (i + 1 >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    break;
                }
                hostKeyType = args[++i].toUpperCase();
                continue;
            }
            if ("-io".equals(argName)) {
                String provider;
                if (i + 1 >= numArgs) {
                    System.err.println("option requires an argument: " + argName);
                    break;
                }
                if ("mina".equals(provider = args[++i])) {
                    System.setProperty(IoServiceFactory.class.getName(), MinaServiceFactory.class.getName());
                    continue;
                }
                if ("nio2".endsWith(provider)) {
                    System.setProperty(IoServiceFactory.class.getName(), Nio2ServiceFactory.class.getName());
                    continue;
                }
                System.err.println("provider should be mina or nio2: " + argName);
                break;
            }
            if ("-o".equals(argName)) {
                String opt;
                int idx;
                if (i + 1 >= numArgs) {
                    System.err.println("option requires and argument: " + argName);
                    error = true;
                    break;
                }
                if ((idx = (opt = args[++i]).indexOf(61)) <= 0) {
                    System.err.println("bad syntax for option: " + opt);
                    error = true;
                    break;
                }
                options.put(opt.substring(0, idx), opt.substring(idx + 1));
                continue;
            }
            if (argName.startsWith("-")) {
                System.err.println("illegal option: " + argName);
                error = true;
                break;
            }
            System.err.println("extra argument: " + argName);
            error = true;
            break;
        }
        if (error) {
            System.err.println("usage: sshd [-p port] [-io mina|nio2] [-key-type RSA|DSA|EC] [-o option=value]");
            System.exit(-1);
        }
        System.err.println("Starting SSHD on port " + port);
        SshServer sshd = SshServer.setUpDefaultServer();
        Map<String, Object> props = sshd.getProperties();
        props.putAll(options);
        SshServer.setupServerBanner(sshd, options);
        sshd.setPort(port);
        if (SecurityUtils.isBouncyCastleRegistered()) {
            hostKeyFile = new File("key.pem").toPath();
            hostKeyProvider = SecurityUtils.createGeneratorHostKeyProvider(hostKeyFile);
        } else {
            hostKeyFile = new File("key.ser").toPath();
            hostKeyProvider = new SimpleGeneratorHostKeyProvider(hostKeyFile);
        }
        hostKeyProvider.setAlgorithm(hostKeyType);
        List keys = (List)ValidateUtils.checkNotNullAndNotEmpty(hostKeyProvider.loadKeys(), "Failed to load keys from %s", hostKeyFile);
        KeyPair kp = (KeyPair)keys.get(0);
        PublicKey pubKey = kp.getPublic();
        String keyAlgorithm = pubKey.getAlgorithm();
        if (!Objects.equals(keyAlgorithm, hostKeyProvider.getAlgorithm())) {
            Files.deleteIfExists(hostKeyFile);
            hostKeyProvider.clearLoadedKeys();
        }
        sshd.setKeyPairProvider(hostKeyProvider);
        sshd.setShellFactory(InteractiveProcessShellFactory.INSTANCE);
        sshd.setPasswordAuthenticator(new PasswordAuthenticator(){

            @Override
            public boolean authenticate(String username, String password, ServerSession session) {
                return GenericUtils.length(username) > 0 && username.equals(password);
            }
        });
        sshd.setPublickeyAuthenticator(AcceptAllPublickeyAuthenticator.INSTANCE);
        sshd.setTcpipForwardingFilter(AcceptAllForwardingFilter.INSTANCE);
        sshd.setCommandFactory(new ScpCommandFactory.Builder().withDelegate(new CommandFactory(){

            @Override
            public Command createCommand(String command) {
                return new ProcessShellFactory(GenericUtils.split(command, ' ')).create();
            }
        }).build());
        sshd.setSubsystemFactories(Arrays.asList(new SftpSubsystemFactory()));
        sshd.start();
        Thread.sleep(Long.MAX_VALUE);
    }

    public static String setupServerBanner(ServerFactoryManager server, Map<String, ?> options) throws IOException {
        String filePath;
        String string = filePath = GenericUtils.isEmpty(options) ? null : Objects.toString(options.remove("Banner"), null);
        if (GenericUtils.length(filePath) > 0) {
            if ("none".equals(filePath)) {
                return null;
            }
            Path path = Paths.get(filePath, new String[0]);
            long fileSize = Files.size(path);
            ValidateUtils.checkTrue(fileSize > 0L, "No banner contents in file=%s", (Object)filePath);
            StringBuilder sb = new StringBuilder((int)fileSize + 64);
            try (BufferedReader rdr = new BufferedReader(new InputStreamReader(Files.newInputStream(path, new OpenOption[0]), StandardCharsets.UTF_8));){
                String line = rdr.readLine();
                while (line != null) {
                    sb.append(line).append('\n');
                    line = rdr.readLine();
                }
            }
            PropertyResolverUtils.updateProperty((PropertyResolver)server, "welcome-banner", (Object)sb.toString());
        } else {
            PropertyResolverUtils.updateProperty((PropertyResolver)server, "welcome-banner", (Object)"Welcome to SSHD\n");
        }
        return PropertyResolverUtils.getString(server, "welcome-banner");
    }
}

