/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.forward;

import java.io.IOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.sshd.client.future.DefaultOpenFuture;
import org.apache.sshd.client.future.OpenFuture;
import org.apache.sshd.common.FactoryManager;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.SshConstants;
import org.apache.sshd.common.channel.Channel;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.channel.ChannelListener;
import org.apache.sshd.common.channel.ChannelOutputStream;
import org.apache.sshd.common.channel.OpenChannelException;
import org.apache.sshd.common.channel.Window;
import org.apache.sshd.common.future.CloseFuture;
import org.apache.sshd.common.future.SshFutureListener;
import org.apache.sshd.common.io.IoConnectFuture;
import org.apache.sshd.common.io.IoConnector;
import org.apache.sshd.common.io.IoHandler;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.io.IoWriteFuture;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.Readable;
import org.apache.sshd.common.util.ValidateUtils;
import org.apache.sshd.common.util.buffer.Buffer;
import org.apache.sshd.common.util.buffer.ByteArrayBuffer;
import org.apache.sshd.common.util.net.SshdSocketAddress;
import org.apache.sshd.common.util.threads.ExecutorServiceCarrier;
import org.apache.sshd.common.util.threads.ThreadUtils;
import org.apache.sshd.server.channel.AbstractServerChannel;
import org.apache.sshd.server.forward.ForwardingFilter;

public class TcpipServerChannel
extends AbstractServerChannel {
    private final ForwardingFilter.Type type;
    private IoConnector connector;
    private IoSession ioSession;
    private OutputStream out;

    public TcpipServerChannel(ForwardingFilter.Type type) {
        this.type = type;
    }

    public final ForwardingFilter.Type getChannelType() {
        return this.type;
    }

    @Override
    protected OpenFuture doInit(Buffer buffer) {
        SshdSocketAddress address;
        String hostToConnect = buffer.getString();
        int portToConnect = buffer.getInt();
        String originatorIpAddress = buffer.getString();
        int originatorPort = buffer.getInt();
        if (this.log.isDebugEnabled()) {
            this.log.debug("doInit({}) Receiving request for direct tcpip: hostToConnect={}, portToConnect={}, originatorIpAddress={}, originatorPort={}", new Object[]{this, hostToConnect, portToConnect, originatorIpAddress, originatorPort});
        }
        switch (this.type) {
            case Direct: {
                address = new SshdSocketAddress(hostToConnect, portToConnect);
                break;
            }
            case Forwarded: {
                address = this.service.getTcpipForwarder().getForwardedPort(portToConnect);
                break;
            }
            default: {
                throw new IllegalStateException("Unknown server channel type: " + this.type);
            }
        }
        Session session = this.getSession();
        FactoryManager manager = ValidateUtils.checkNotNull(session.getFactoryManager(), "No factory manager");
        ForwardingFilter filter = manager.getTcpipForwardingFilter();
        final DefaultOpenFuture f = new DefaultOpenFuture(this);
        try {
            if (address == null || filter == null || !filter.canConnect(this.type, address, session)) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug("doInit(" + this + ")[" + this.type + "][haveFilter=" + (filter != null) + "] filtered out " + address);
                }
                super.close(true);
                f.setException(new OpenChannelException(1, "Connection denied"));
                return f;
            }
        }
        catch (Error e) {
            this.log.warn("doInit({})[{}] failed ({}) to consult forwarding filter: {}", new Object[]{session, this.type, e.getClass().getSimpleName(), e.getMessage()});
            if (this.log.isDebugEnabled()) {
                this.log.debug("doInit(" + this + ")[" + this.type + "] filter consultation failure details", (Throwable)e);
            }
            throw new RuntimeSshException(e);
        }
        this.out = new ChannelOutputStream(this, this.getRemoteWindow(), this.log, 94, true);
        IoHandler handler = new IoHandler(){

            @Override
            public void messageReceived(IoSession session, Readable message) throws Exception {
                if (TcpipServerChannel.this.isClosing()) {
                    if (TcpipServerChannel.this.log.isDebugEnabled()) {
                        TcpipServerChannel.this.log.debug("doInit({}) Ignoring write to channel in CLOSING state", (Object)TcpipServerChannel.this);
                    }
                } else {
                    ByteArrayBuffer buffer = new ByteArrayBuffer(message.available() + 64, false);
                    buffer.putBuffer(message);
                    TcpipServerChannel.this.out.write(((Buffer)buffer).array(), ((Buffer)buffer).rpos(), buffer.available());
                    TcpipServerChannel.this.out.flush();
                }
            }

            @Override
            public void sessionCreated(IoSession session) throws Exception {
            }

            @Override
            public void sessionClosed(IoSession session) throws Exception {
                TcpipServerChannel.this.close(false);
            }

            @Override
            public void exceptionCaught(IoSession session, Throwable cause) throws Exception {
                TcpipServerChannel.this.close(true);
            }
        };
        this.connector = manager.getIoServiceFactory().createConnector(handler);
        IoConnectFuture future = this.connector.connect(address.toInetSocketAddress());
        future.addListener(new SshFutureListener<IoConnectFuture>(){

            @Override
            public void operationComplete(IoConnectFuture future) {
                TcpipServerChannel.this.handleChannelConnectResult(f, future);
            }
        });
        return f;
    }

    protected void handleChannelConnectResult(OpenFuture f, IoConnectFuture future) {
        ChannelListener listener = this.getChannelListenerProxy();
        try {
            if (future.isConnected()) {
                this.handleChannelOpenSuccess(f, future.getSession());
                return;
            }
            Throwable problem = GenericUtils.peelException(future.getException());
            if (problem != null) {
                this.handleChannelOpenFailure(f, problem);
            }
        }
        catch (RuntimeException t) {
            Throwable e;
            block8: {
                e = GenericUtils.peelException(t);
                try {
                    listener.channelOpenFailure(this, e);
                }
                catch (Throwable err) {
                    Throwable[] suppressed;
                    Throwable ignored = GenericUtils.peelException(err);
                    this.log.warn("handleChannelConnectResult({})[exception] failed ({}) to inform listener of open failure={}: {}", new Object[]{this, ignored.getClass().getSimpleName(), e.getClass().getSimpleName(), ignored.getMessage()});
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("handleChannelConnectResult(" + this + ")[exception] listener exception details", ignored);
                    }
                    if (!this.log.isTraceEnabled() || GenericUtils.length(suppressed = ignored.getSuppressed()) <= 0) break block8;
                    for (Throwable s : suppressed) {
                        this.log.trace("handleChannelConnectResult(" + this + ") suppressed channel open failure signalling", s);
                    }
                }
            }
            f.setException(e);
        }
    }

    protected void handleChannelOpenSuccess(OpenFuture f, IoSession session) {
        this.ioSession = session;
        ChannelListener listener = this.getChannelListenerProxy();
        try {
            listener.channelOpenSuccess(this);
            f.setOpened();
        }
        catch (Throwable t) {
            Throwable e;
            block6: {
                e = GenericUtils.peelException(t);
                try {
                    listener.channelOpenFailure(this, e);
                }
                catch (Throwable err) {
                    Throwable[] suppressed;
                    Throwable ignored = GenericUtils.peelException(err);
                    this.log.warn("handleChannelOpenSuccess({}) failed ({}) to inform listener of open failure={}: {}", new Object[]{this, ignored.getClass().getSimpleName(), e.getClass().getSimpleName(), ignored.getMessage()});
                    if (this.log.isDebugEnabled()) {
                        this.log.debug("doInit(" + this + ") listener inform failure details", ignored);
                    }
                    if (!this.log.isTraceEnabled() || GenericUtils.length(suppressed = ignored.getSuppressed()) <= 0) break block6;
                    for (Throwable s : suppressed) {
                        this.log.trace("handleChannelOpenSuccess(" + this + ") suppressed channel open failure signalling", s);
                    }
                }
            }
            f.setException(e);
        }
    }

    protected void handleChannelOpenFailure(OpenFuture f, Throwable problem) {
        block6: {
            ChannelListener listener = this.getChannelListenerProxy();
            try {
                listener.channelOpenFailure(this, problem);
            }
            catch (Throwable err) {
                Throwable[] suppressed;
                Throwable ignored = GenericUtils.peelException(err);
                this.log.warn("handleChannelOpenFailure({}) failed ({}) to inform listener of open failure={}: {}", new Object[]{this, ignored.getClass().getSimpleName(), problem.getClass().getSimpleName(), ignored.getMessage()});
                if (this.log.isDebugEnabled()) {
                    this.log.debug("handleChannelOpenFailure(" + this + ") listener inform open failure details", ignored);
                }
                if (!this.log.isTraceEnabled() || GenericUtils.length(suppressed = ignored.getSuppressed()) <= 0) break block6;
                for (Throwable s : suppressed) {
                    this.log.trace("handleOpenChannelFailure(" + this + ") suppressed channel open failure signalling", s);
                }
            }
        }
        this.closeImmediately0();
        if (problem instanceof ConnectException) {
            f.setException(new OpenChannelException(2, problem.getMessage(), problem));
        } else {
            f.setException(problem);
        }
    }

    private void closeImmediately0() {
        super.close(true);
        ExecutorService service = this.getExecutorService();
        final ExecutorService executors = service == null ? ThreadUtils.newSingleThreadExecutor("TcpIpServerChannel-ConnectorCleanup[" + this.getSession() + "]") : service;
        final boolean shutdown = executors == service ? this.isShutdownOnExit() : true;
        executors.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    TcpipServerChannel.this.connector.close(true);
                }
                finally {
                    if (executors != null && !executors.isShutdown() && shutdown) {
                        List<Runnable> runners = executors.shutdownNow();
                        if (TcpipServerChannel.this.log.isDebugEnabled()) {
                            TcpipServerChannel.this.log.debug("destroy({}) - shutdown executor service - runners count={}", (Object)TcpipServerChannel.this, (Object)runners.size());
                        }
                    }
                }
            }
        });
    }

    @Override
    public CloseFuture close(boolean immediately) {
        return super.close(immediately).addListener(new SshFutureListener<CloseFuture>(){

            @Override
            public void operationComplete(CloseFuture sshFuture) {
                TcpipServerChannel.this.closeImmediately0();
            }
        });
    }

    @Override
    protected void doWriteData(byte[] data, int off, final int len) throws IOException {
        final ByteArrayBuffer buf = ByteArrayBuffer.getCompactClone(data, off, len);
        this.ioSession.write(buf).addListener(new SshFutureListener<IoWriteFuture>(){

            @Override
            public void operationComplete(IoWriteFuture future) {
                if (future.isWritten()) {
                    TcpipServerChannel.this.handleWriteDataSuccess((byte)94, buf.array(), 0, len);
                } else {
                    TcpipServerChannel.this.handleWriteDataFailure((byte)94, buf.array(), 0, len, future.getException());
                }
            }
        });
    }

    @Override
    protected void doWriteExtendedData(byte[] data, int off, int len) throws IOException {
        throw new UnsupportedOperationException(this.type + "Tcpip channel does not support extended data");
    }

    protected void handleWriteDataSuccess(byte cmd, byte[] data, int off, int len) {
        Session session = this.getSession();
        try {
            Window wLocal = this.getLocalWindow();
            wLocal.consumeAndCheck(len);
        }
        catch (Throwable e) {
            if (this.log.isDebugEnabled()) {
                this.log.debug("handleWriteDataSuccess({})[{}] failed ({}) to consume len={}: {}", new Object[]{this, SshConstants.getCommandMessageName(cmd & 0xFF), e.getClass().getSimpleName(), len, e.getMessage()});
            }
            session.exceptionCaught(e);
        }
    }

    protected void handleWriteDataFailure(byte cmd, byte[] data, int off, int len, Throwable t) {
        Session session = this.getSession();
        if (this.log.isDebugEnabled()) {
            this.log.debug("handleWriteDataFailure({})[{}] failed ({}) to write len={}: {}", new Object[]{this, SshConstants.getCommandMessageName(cmd & 0xFF), t.getClass().getSimpleName(), len, t.getMessage()});
        }
        if (this.log.isTraceEnabled()) {
            this.log.trace("doWriteData(" + this + ")[" + SshConstants.getCommandMessageName(cmd & 0xFF) + "]" + " len=" + len + " write failure details", t);
        }
        session.exceptionCaught(t);
    }

    public static abstract class TcpipFactory
    implements ChannelFactory,
    ExecutorServiceCarrier {
        private final ForwardingFilter.Type type;

        protected TcpipFactory(ForwardingFilter.Type type) {
            this.type = type;
        }

        public final ForwardingFilter.Type getType() {
            return this.type;
        }

        @Override
        public final String getName() {
            return this.type.getName();
        }

        @Override
        public ExecutorService getExecutorService() {
            return null;
        }

        @Override
        public boolean isShutdownOnExit() {
            return false;
        }

        @Override
        public Channel create() {
            TcpipServerChannel channel = new TcpipServerChannel(this.getType());
            channel.setExecutorService(this.getExecutorService());
            channel.setShutdownOnExit(this.isShutdownOnExit());
            return channel;
        }
    }
}

