/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.server.session;

import org.apache.sshd.common.PropertyResolverUtils;
import org.apache.sshd.common.RuntimeSshException;
import org.apache.sshd.common.io.IoSession;
import org.apache.sshd.common.session.SessionListener;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.session.AbstractServerSession;

public class ServerSessionImpl
extends AbstractServerSession {
    public ServerSessionImpl(ServerFactoryManager server, IoSession ioSession) throws Exception {
        super(server, ioSession);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Server session created {}", (Object)ioSession);
        }
        SessionListener listener = this.getSessionListenerProxy();
        try {
            listener.sessionCreated(this);
        }
        catch (Throwable t) {
            Throwable e = GenericUtils.peelException(t);
            if (this.log.isDebugEnabled()) {
                this.log.debug("Failed ({}) to announce session={} created: {}", new Object[]{e.getClass().getSimpleName(), ioSession, e.getMessage()});
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Session=" + ioSession + " creation failure details", e);
            }
            if (e instanceof Exception) {
                throw (Exception)e;
            }
            throw new RuntimeSshException(e);
        }
        String headerConfig = PropertyResolverUtils.getString(this, "server-extra-identification-lines");
        String[] headers = GenericUtils.split(headerConfig, '|');
        this.sendServerIdentification(headers);
    }
}

