/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;

@DataObject
public class RedisOptions {
    private final JsonObject json;

    public String getEncoding() {
        return this.json.getString("encoding", "UTF-8");
    }

    public RedisOptions setEncoding(String encoding) {
        this.json.put("encoding", encoding);
        return this;
    }

    public String getAddress() {
        return this.json.getString("address", "io.vertx.redis");
    }

    public RedisOptions setAddress(String address) {
        this.json.put("address", address);
        return this;
    }

    public String getHost() {
        return this.json.getString("host", "localhost");
    }

    public RedisOptions setHost(String host) {
        this.json.put("host", host);
        return this;
    }

    public int getPort() {
        return this.json.getInteger("port", Integer.valueOf(6379));
    }

    public RedisOptions setPort(int port) {
        this.json.put("port", Integer.valueOf(port));
        return this;
    }

    public boolean isTcpKeepAlive() {
        return this.json.getBoolean("tcpKeepAlive", Boolean.valueOf(true));
    }

    public RedisOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        this.json.put("tcpKeepAlive", Boolean.valueOf(tcpKeepAlive));
        return this;
    }

    public boolean isTcpNoDelay() {
        return this.json.getBoolean("tcpNoDelay", Boolean.valueOf(true));
    }

    public RedisOptions setTcpNoDelay(boolean tcpNoDelay) {
        this.json.put("tcpNoDelay", Boolean.valueOf(tcpNoDelay));
        return this;
    }

    public String getAuth() {
        return this.json.getString("auth");
    }

    public RedisOptions setAuth(String auth) {
        this.json.put("auth", auth);
        return this;
    }

    public Integer getSelect() {
        return this.json.getInteger("select");
    }

    public RedisOptions setSelect(Integer select) {
        if (select != null) {
            this.json.put("select", select);
        } else {
            this.json.remove("select");
        }
        return this;
    }

    public RedisOptions() {
        this.json = new JsonObject();
    }

    public RedisOptions(JsonObject json) {
        this.json = json.copy();
    }

    public RedisOptions(RedisOptions options) {
        this(options.toJSON());
    }

    public JsonObject toJSON() {
        return this.json;
    }
}

