/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.redis.RedisClient;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.impl.Command;
import io.vertx.redis.impl.RedisCommand;
import io.vertx.redis.impl.RedisConnection;
import io.vertx.redis.impl.RedisSubscriptions;
import io.vertx.redis.impl.ResponseTransform;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public abstract class AbstractRedisClient
implements RedisClient {
    private final EventBus eb;
    private final RedisSubscriptions subscriptions;
    private final String encoding;
    private final Charset charset;
    private final Charset binaryCharset;
    private final String baseAddress;
    private final RedisConnection redis;
    private final RedisConnection pubsub;

    AbstractRedisClient(Vertx vertx, RedisOptions config) {
        this.eb = vertx.eventBus();
        this.encoding = config.getEncoding();
        this.charset = Charset.forName(this.encoding);
        this.binaryCharset = Charset.forName("iso-8859-1");
        this.baseAddress = config.getAddress();
        NetClient client = vertx.createNetClient(new NetClientOptions().setTcpKeepAlive(config.isTcpKeepAlive()).setTcpNoDelay(config.isTcpNoDelay()));
        this.subscriptions = new RedisSubscriptions(vertx);
        this.redis = new RedisConnection(client, config);
        this.pubsub = new RedisConnection(client, config, this.subscriptions);
    }

    @Override
    public synchronized void close(Handler<AsyncResult<Void>> handler) {
        AtomicInteger cnt = new AtomicInteger(0);
        Handler cb = v -> {
            if (cnt.incrementAndGet() == 2) {
                handler.handle((Object)Future.succeededFuture());
            }
        };
        this.redis.disconnect((Handler<AsyncResult<Void>>)cb);
        this.pubsub.disconnect((Handler<AsyncResult<Void>>)cb);
    }

    private ResponseTransform getResponseTransformFor(RedisCommand command) {
        if (command == RedisCommand.HGETALL) {
            return ResponseTransform.HASH;
        }
        if (command == RedisCommand.INFO) {
            return ResponseTransform.INFO;
        }
        if (command == RedisCommand.EVAL || command == RedisCommand.EVALSHA) {
            return ResponseTransform.ARRAY;
        }
        return ResponseTransform.NONE;
    }

    final void sendString(RedisCommand command, List<?> args, Handler<AsyncResult<String>> resultHandler) {
        this.send(command, args, String.class, resultHandler);
    }

    final void sendLong(RedisCommand command, List<?> args, Handler<AsyncResult<Long>> resultHandler) {
        this.send(command, args, Long.class, resultHandler);
    }

    final void sendVoid(RedisCommand command, List<?> args, Handler<AsyncResult<Void>> resultHandler) {
        this.send(command, args, Void.class, resultHandler);
    }

    final void sendJsonArray(RedisCommand command, List<?> args, Handler<AsyncResult<JsonArray>> resultHandler) {
        this.send(command, args, JsonArray.class, resultHandler);
    }

    final void sendJsonObject(RedisCommand command, List<?> args, Handler<AsyncResult<JsonObject>> resultHandler) {
        this.send(command, args, JsonObject.class, resultHandler);
    }

    final <T> void send(RedisCommand command, List<?> redisArgs, Class<T> returnType, Handler<AsyncResult<T>> resultHandler) {
        this.send(command, redisArgs, returnType, false, resultHandler);
    }

    final <T> void send(RedisCommand command, List<?> redisArgs, Class<T> returnType, boolean binary, Handler<AsyncResult<T>> resultHandler) {
        Command<T> cmd = new Command<T>(command, redisArgs, binary ? this.binaryCharset : this.charset, this.getResponseTransformFor(command), returnType).handler(resultHandler);
        switch (command) {
            case PSUBSCRIBE: {
                cmd.setExpectedReplies(redisArgs.size());
                for (Object obj : redisArgs) {
                    String pattern = (String)obj;
                    String vertxChannel = this.baseAddress + "." + pattern;
                    this.subscriptions.registerPatternSubscribeHandler(pattern, (pattern1, replyData) -> {
                        JsonObject replyMessage = new JsonObject();
                        replyMessage.put("status", "ok");
                        JsonObject message = new JsonObject();
                        message.put("pattern", pattern1);
                        message.put("channel", replyData[2].asType(String.class, this.encoding));
                        message.put("message", replyData[3].asType(String.class, this.encoding));
                        replyMessage.put("value", message);
                        this.eb.send(vertxChannel, (Object)replyMessage);
                    });
                }
                this.pubsub.send(cmd);
                break;
            }
            case SUBSCRIBE: {
                cmd.setExpectedReplies(redisArgs.size());
                for (Object obj : redisArgs) {
                    String channel = (String)obj;
                    String vertxChannel = this.baseAddress + "." + channel;
                    this.subscriptions.registerChannelSubscribeHandler(channel, (channel1, replyData) -> {
                        JsonObject replyMessage = new JsonObject();
                        replyMessage.put("status", "ok");
                        JsonObject message = new JsonObject();
                        message.put("channel", channel1);
                        message.put("message", replyData[2].asType(String.class, this.encoding));
                        replyMessage.put("value", message);
                        this.eb.send(vertxChannel, (Object)replyMessage);
                    });
                }
                this.pubsub.send(cmd);
                break;
            }
            case PUNSUBSCRIBE: {
                if (redisArgs == null || redisArgs.size() == 0) {
                    cmd.setExpectedReplies(this.subscriptions.patternSize());
                    this.subscriptions.unregisterPatternSubscribeHandler(null);
                } else {
                    cmd.setExpectedReplies(redisArgs.size());
                    for (Object obj : redisArgs) {
                        String pattern = (String)obj;
                        this.subscriptions.unregisterPatternSubscribeHandler(pattern);
                    }
                }
                this.pubsub.send(cmd);
                break;
            }
            case UNSUBSCRIBE: {
                if (redisArgs == null || redisArgs.size() == 0) {
                    cmd.setExpectedReplies(this.subscriptions.channelSize());
                    this.subscriptions.unregisterChannelSubscribeHandler(null);
                } else {
                    cmd.setExpectedReplies(redisArgs.size());
                    for (Object obj : redisArgs) {
                        String channel = (String)obj;
                        this.subscriptions.unregisterChannelSubscribeHandler(channel);
                    }
                }
                this.pubsub.send(cmd);
                break;
            }
            case QUIT: {
                this.redis.send(cmd);
                this.pubsub.send(cmd);
                break;
            }
            default: {
                this.redis.send(cmd);
            }
        }
    }
}

