/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetSocket;
import io.vertx.core.streams.WriteStream;
import io.vertx.redis.RedisOptions;
import io.vertx.redis.impl.Command;
import io.vertx.redis.impl.RedisCommand;
import io.vertx.redis.impl.RedisSubscriptions;
import io.vertx.redis.impl.Reply;
import io.vertx.redis.impl.ReplyParser;
import io.vertx.redis.impl.ResponseTransform;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

class RedisConnection {
    private static final Logger log = LoggerFactory.getLogger(RedisConnection.class);
    private final Queue<Command<?>> pending = new ConcurrentLinkedQueue();
    private final Queue<Command<?>> waiting = new ConcurrentLinkedQueue();
    private final ReplyParser replyParser;
    private final NetClient client;
    private final RedisOptions config;
    private volatile State state = State.DISCONNECTED;
    private volatile NetSocket netSocket;
    private volatile Context context;

    public RedisConnection(NetClient client, RedisOptions config) {
        this.client = client;
        this.config = config;
        this.replyParser = new ReplyParser((Handler<Reply>)((Handler)this::handleReply));
    }

    public RedisConnection(NetClient client, RedisOptions config, RedisSubscriptions subscriptions) {
        this.client = client;
        this.config = config;
        this.replyParser = new ReplyParser((Handler<Reply>)((Handler)reply -> {
            Reply[] data;
            if (reply.is('*') && (data = (Reply[])reply.data()) != null) {
                if (data.length == 3) {
                    if (data[0].is('$') && "message".equals(data[0].asType(String.class))) {
                        String channel = data[1].asType(String.class);
                        subscriptions.handleChannel(channel, data);
                        return;
                    }
                } else if (data.length == 4 && data[0].is('$') && "pmessage".equals(data[0].asType(String.class))) {
                    String pattern = data[1].asType(String.class);
                    subscriptions.handlePattern(pattern, data);
                    return;
                }
            }
            this.handleReply((Reply)reply);
        }));
    }

    private synchronized void connect() {
        if (this.state == State.DISCONNECTED) {
            this.state = State.CONNECTING;
            this.replyParser.reset();
            this.client.connect(this.config.getPort(), this.config.getHost(), asyncResult -> {
                this.context = Vertx.currentContext();
                if (asyncResult.failed()) {
                    Command<?> command;
                    this.state = State.ERROR;
                    while ((command = this.waiting.poll()) != null) {
                        command.handle((AsyncResult<?>)Future.failedFuture((Throwable)asyncResult.cause()));
                    }
                    while ((command = this.pending.poll()) != null) {
                        command.handle((AsyncResult<?>)Future.failedFuture((Throwable)asyncResult.cause()));
                    }
                    if (this.netSocket != null) {
                        this.netSocket.close();
                    }
                    this.state = State.DISCONNECTED;
                } else {
                    Command<?> command;
                    this.netSocket = ((NetSocket)asyncResult.result()).handler((Handler)this.replyParser).closeHandler(v -> {
                        Command<?> command;
                        this.state = State.ERROR;
                        while ((command = this.waiting.poll()) != null) {
                            command.handle((AsyncResult<?>)Future.failedFuture((String)"Connection closed!"));
                        }
                        while ((command = this.pending.poll()) != null) {
                            command.handle((AsyncResult<?>)Future.failedFuture((String)"Connection closed!"));
                        }
                        this.netSocket.close();
                        this.state = State.DISCONNECTED;
                    }).exceptionHandler(e -> {
                        Command<?> command;
                        this.state = State.ERROR;
                        while ((command = this.waiting.poll()) != null) {
                            command.handle((AsyncResult<?>)Future.failedFuture((Throwable)e));
                        }
                        while ((command = this.pending.poll()) != null) {
                            command.handle((AsyncResult<?>)Future.failedFuture((Throwable)e));
                        }
                        this.netSocket.close();
                        this.state = State.DISCONNECTED;
                    });
                    while ((command = this.waiting.poll()) != null) {
                        command.handle((AsyncResult<?>)Future.failedFuture((String)"Connection lost"));
                    }
                    this.state = State.CONNECTED;
                    this.doAuth();
                }
            });
        }
    }

    synchronized void disconnect(Handler<AsyncResult<Void>> closeHandler) {
        switch (this.state) {
            case CONNECTED: 
            case CONNECTING: {
                Command<Void> cmd = new Command<Void>(RedisCommand.QUIT, null, Charset.defaultCharset(), ResponseTransform.NONE, Void.class);
                cmd.handler((Handler<AsyncResult<Void>>)((Handler)v -> {
                    Command<?> command;
                    this.state = State.ERROR;
                    while ((command = this.waiting.poll()) != null) {
                        command.handle((AsyncResult<?>)Future.failedFuture((String)"Connection closed!"));
                    }
                    while ((command = this.pending.poll()) != null) {
                        command.handle((AsyncResult<?>)Future.failedFuture((String)"Connection closed!"));
                    }
                    this.netSocket.close();
                    this.state = State.DISCONNECTED;
                    closeHandler.handle((Object)Future.succeededFuture());
                }));
                this.send(cmd);
                break;
            }
            case ERROR: 
            case DISCONNECTED: {
                closeHandler.handle((Object)Future.succeededFuture());
            }
        }
    }

    void send(Command<?> command) {
        switch (this.state) {
            case CONNECTED: {
                for (int i = 0; i < command.getExpectedReplies(); ++i) {
                    this.waiting.add(command);
                }
                this.context.runOnContext(v -> command.writeTo((WriteStream<Buffer>)this.netSocket));
                break;
            }
            case CONNECTING: 
            case ERROR: {
                this.pending.add(command);
                break;
            }
            case DISCONNECTED: {
                this.pending.add(command);
                this.connect();
            }
        }
    }

    private synchronized void doAuth() {
        if (this.config.getAuth() != null) {
            ArrayList<String> args = new ArrayList<String>();
            args.add(this.config.getAuth());
            Command<String> authCmd = new Command<String>(RedisCommand.AUTH, args, Charset.forName(this.config.getEncoding()), ResponseTransform.NONE, String.class).handler((Handler<AsyncResult<String>>)((Handler)auth -> {
                if (auth.failed()) {
                    Command<?> cmd;
                    while ((cmd = this.pending.poll()) != null) {
                        cmd.handle((AsyncResult<?>)Future.failedFuture((Throwable)auth.cause()));
                    }
                    this.netSocket.close();
                    this.state = State.DISCONNECTED;
                    return;
                }
                this.doSelect();
            }));
            this.waiting.add(authCmd);
            this.context.runOnContext(v -> authCmd.writeTo((WriteStream<Buffer>)this.netSocket));
        } else {
            this.doSelect();
        }
    }

    private synchronized void doSelect() {
        if (this.config.getSelect() != null) {
            ArrayList<Integer> args = new ArrayList<Integer>();
            args.add(this.config.getSelect());
            Command<String> selectCmd = new Command<String>(RedisCommand.SELECT, args, Charset.forName(this.config.getEncoding()), ResponseTransform.NONE, String.class).handler((Handler<AsyncResult<String>>)((Handler)select -> {
                if (select.failed()) {
                    Command<?> cmd;
                    while ((cmd = this.pending.poll()) != null) {
                        cmd.handle((AsyncResult<?>)Future.failedFuture((Throwable)select.cause()));
                    }
                    this.netSocket.close();
                    this.state = State.DISCONNECTED;
                    return;
                }
                this.resendPending();
            }));
            this.waiting.add(selectCmd);
            this.context.runOnContext(v -> selectCmd.writeTo((WriteStream<Buffer>)this.netSocket));
        } else {
            this.resendPending();
        }
    }

    private synchronized void resendPending() {
        Command<?> command;
        while ((command = this.pending.poll()) != null) {
            for (int i = 0; i < command.getExpectedReplies(); ++i) {
                this.waiting.add(command);
            }
            command.writeTo((WriteStream<Buffer>)this.netSocket);
        }
    }

    private void handleReply(Reply reply) {
        Command<?> cmd = this.waiting.poll();
        if (cmd != null) {
            switch (reply.type()) {
                case 45: {
                    cmd.handle((AsyncResult<?>)Future.failedFuture((String)reply.asType(String.class)));
                    return;
                }
                case 43: {
                    switch (cmd.responseTransform()) {
                        case ARRAY: {
                            cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)new JsonArray().add(reply.asType(String.class))));
                            break;
                        }
                        default: {
                            cmd.handle((AsyncResult<?>)Future.succeededFuture(reply.asType(cmd.returnType())));
                        }
                    }
                    return;
                }
                case 36: {
                    switch (cmd.responseTransform()) {
                        case ARRAY: {
                            cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)new JsonArray().add(reply.asType(String.class, cmd.encoding()))));
                            break;
                        }
                        case INFO: {
                            String info = reply.asType(String.class, cmd.encoding());
                            if (info == null) {
                                cmd.handle((AsyncResult<?>)Future.succeededFuture(null));
                                break;
                            }
                            String[] lines = info.split("\\r?\\n");
                            JsonObject value = new JsonObject();
                            JsonObject section = null;
                            for (String line : lines) {
                                if (line.length() == 0) {
                                    section = null;
                                    continue;
                                }
                                if (line.charAt(0) == '#') {
                                    section = new JsonObject();
                                    value.put(line.substring(2).toLowerCase(), section);
                                    continue;
                                }
                                int split = line.indexOf(58);
                                if (section == null) {
                                    value.put(line.substring(0, split), line.substring(split + 1));
                                    continue;
                                }
                                section.put(line.substring(0, split), line.substring(split + 1));
                            }
                            cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)value));
                            break;
                        }
                        default: {
                            cmd.handle((AsyncResult<?>)Future.succeededFuture(reply.asType(cmd.returnType(), cmd.encoding())));
                        }
                    }
                    return;
                }
                case 42: {
                    switch (cmd.responseTransform()) {
                        case HASH: {
                            cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)reply.asType(JsonObject.class, cmd.encoding())));
                            break;
                        }
                        default: {
                            cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)reply.asType(JsonArray.class, cmd.encoding())));
                        }
                    }
                    return;
                }
                case 58: {
                    switch (cmd.responseTransform()) {
                        case ARRAY: {
                            cmd.handle((AsyncResult<?>)Future.succeededFuture((Object)new JsonArray().add(reply.asType(Long.class))));
                            break;
                        }
                        default: {
                            cmd.handle((AsyncResult<?>)Future.succeededFuture(reply.asType(cmd.returnType())));
                        }
                    }
                    return;
                }
            }
            cmd.handle((AsyncResult<?>)Future.failedFuture((String)"Unknown message type"));
        } else {
            log.error((Object)("No handler waiting for message: " + reply.asType(String.class)));
        }
    }

    private static enum State {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        ERROR;

    }
}

