/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.redis.impl;

public class RedisEncoding {
    private static final char[] NUMERALS = "0123456789abcdef".toCharArray();

    public static String encode(String value) {
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        block7: for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            int lo = 0xFF & c;
            if (lo >= 32 && lo < 127) {
                sb.append((char)lo);
                continue;
            }
            switch (lo) {
                case 7: {
                    sb.append("\\a");
                    continue block7;
                }
                case 8: {
                    sb.append("\\b");
                    continue block7;
                }
                case 9: {
                    sb.append("\\t");
                    continue block7;
                }
                case 10: {
                    sb.append("\\n");
                    continue block7;
                }
                case 13: {
                    sb.append("\\r");
                    continue block7;
                }
                default: {
                    int ma = lo / 16;
                    int mi = lo % 16;
                    sb.append("\\x").append(NUMERALS[ma]).append(NUMERALS[mi]);
                }
            }
        }
        return sb.toString();
    }

    public static String decode(String value) {
        StringBuilder sb = new StringBuilder();
        int len = value.length();
        int decoding = -1;
        int d = 0;
        for (int i = 0; i < len; ++i) {
            char c = value.charAt(i);
            if (decoding > -1) {
                int val;
                int df = i - decoding;
                if (df == 1) {
                    if (c == 'x') continue;
                    switch (c) {
                        case 'a': {
                            sb.append('\u0007');
                            break;
                        }
                        case 'b': {
                            sb.append('\b');
                            break;
                        }
                        case 't': {
                            sb.append('\t');
                            break;
                        }
                        case 'n': {
                            sb.append('\n');
                            break;
                        }
                        case 'r': {
                            sb.append('\r');
                            break;
                        }
                        case '\\': {
                            sb.append('\\');
                            break;
                        }
                        default: {
                            throw new RuntimeException("Invalid escape sequence: \\" + c + " at pos " + i);
                        }
                    }
                    decoding = -1;
                    d = 0;
                    continue;
                }
                int n = c >= '0' && c < ':' ? c - 48 : (c >= 'A' && c < 'G' ? 10 + c - 65 : (val = c >= 'a' && c < 'g' ? 10 + c - 97 : -1));
                if (val == -1) {
                    throw new RuntimeException("Invalid escape sequence: " + value.substring(decoding, i + 1) + " at pos: " + i);
                }
                d += df == 2 ? 16 * val : val;
                if (df != 3) continue;
                sb.append((char)d);
                decoding = -1;
                d = 0;
                continue;
            }
            if (c == '\\') {
                decoding = i;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

