/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.MatchType;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

class Matcher {
    private final Set<String> equalsMatches = new HashSet<String>();
    private final Pattern[] regexMatches;

    Matcher(List<Match> matches) {
        for (Match match : matches) {
            if (match.getType() != MatchType.EQUALS || match.getValue() == null) continue;
            this.equalsMatches.add(match.getValue());
        }
        this.regexMatches = (Pattern[])matches.stream().filter(matcher -> matcher.getType() == MatchType.REGEX && matcher.getValue() != null).map(matcher -> Pattern.compile(matcher.getValue())).toArray(Pattern[]::new);
    }

    boolean match(String value) {
        if (this.equalsMatches.size() > 0 && this.equalsMatches.contains(value)) {
            return true;
        }
        if (this.regexMatches.length > 0) {
            for (Pattern pattern : this.regexMatches) {
                if (!pattern.matcher(value).matches()) continue;
                return true;
            }
        }
        return false;
    }
}

