/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.impl.clientside;

import com.hazelcast.client.config.ClientConfig;
import com.hazelcast.client.config.ClientFailoverConfig;
import com.hazelcast.client.config.ClientNetworkConfig;
import com.hazelcast.config.InvalidConfigurationException;
import java.util.List;

public final class FailoverClientConfigSupport {
    private FailoverClientConfigSupport() {
    }

    public static ClientFailoverConfig resolveClientFailoverConfig() {
        return FailoverClientConfigSupport.resolveClientFailoverConfig(null);
    }

    public static ClientFailoverConfig resolveClientFailoverConfig(ClientFailoverConfig clientFailoverConfig) {
        if (clientFailoverConfig == null) {
            clientFailoverConfig = ClientFailoverConfig.load();
        }
        FailoverClientConfigSupport.checkValidAlternative(clientFailoverConfig.getClientConfigs());
        return clientFailoverConfig;
    }

    public static ClientConfig resolveClientConfig(ClientConfig config) {
        if (config == null) {
            return ClientConfig.load();
        }
        return config;
    }

    private static void checkValidAlternative(List<ClientConfig> alternativeClientConfigs) {
        if (alternativeClientConfigs.isEmpty()) {
            throw new InvalidConfigurationException("ClientFailoverConfig should have at least one client config.");
        }
        ClientConfig mainConfig = alternativeClientConfigs.get(0);
        for (ClientConfig alternativeClientConfig : alternativeClientConfigs.subList(1, alternativeClientConfigs.size())) {
            FailoverClientConfigSupport.checkValidAlternative(mainConfig, alternativeClientConfig);
        }
    }

    private static void throwInvalidConfigurationException(String rootClusterName, String clusterName, String configName) {
        throw new InvalidConfigurationException("Alternative config with cluster name " + clusterName + " has a different config than the initial config with cluster name " + rootClusterName + " for " + configName);
    }

    private static boolean notEqual(Object l, Object r) {
        return l != null ? !l.equals(r) : r != null;
    }

    private static void checkValidAlternative(ClientConfig mainConfig, ClientConfig alternativeConfig) {
        String mainClusterName = mainConfig.getClusterName();
        String alterNativeClusterName = alternativeConfig.getClusterName();
        FailoverClientConfigSupport.checkValidAlternativeForNetwork(mainConfig, alternativeConfig);
        if (FailoverClientConfigSupport.notEqual(mainConfig.getProperties(), alternativeConfig.getProperties())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "properties");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getLoadBalancer(), alternativeConfig.getLoadBalancer())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "loadBalancer");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getListenerConfigs(), alternativeConfig.getListenerConfigs())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "listeners");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getInstanceName(), alternativeConfig.getInstanceName())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "instanceName");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getConfigPatternMatcher(), alternativeConfig.getConfigPatternMatcher())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "configPatternMatcher");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getNearCacheConfigMap(), alternativeConfig.getNearCacheConfigMap())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "nearCache");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getReliableTopicConfigMap(), alternativeConfig.getReliableTopicConfigMap())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "reliableTopic");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getQueryCacheConfigs(), alternativeConfig.getQueryCacheConfigs())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "queryCacheConfigs");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getSerializationConfig(), alternativeConfig.getSerializationConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "serializationConfig");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getNativeMemoryConfig(), alternativeConfig.getNativeMemoryConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "nativeMemory");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getProxyFactoryConfigs(), alternativeConfig.getProxyFactoryConfigs())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "proxyFactory");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getManagedContext(), alternativeConfig.getManagedContext())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "managedContext");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getClassLoader(), alternativeConfig.getClassLoader())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "classLoader");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getConnectionStrategyConfig(), alternativeConfig.getConnectionStrategyConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "connectionStrategy");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getUserCodeDeploymentConfig(), alternativeConfig.getUserCodeDeploymentConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "userCodeDeployment");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getFlakeIdGeneratorConfigMap(), alternativeConfig.getFlakeIdGeneratorConfigMap())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "flakeIdGenerator");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getLabels(), alternativeConfig.getLabels())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "labels");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getUserContext(), alternativeConfig.getUserContext())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "userContext");
        }
        if (FailoverClientConfigSupport.notEqual(mainConfig.getMetricsConfig(), alternativeConfig.getMetricsConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "metricsConfig");
        }
        if (mainConfig.isBackupAckToClientEnabled() != alternativeConfig.isBackupAckToClientEnabled()) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "isBackupAckToClientEnabled");
        }
    }

    private static void checkValidAlternativeForNetwork(ClientConfig mainConfig, ClientConfig alternativeConfig) {
        String mainClusterName = mainConfig.getClusterName();
        String alterNativeClusterName = alternativeConfig.getClusterName();
        ClientNetworkConfig mainNetworkConfig = mainConfig.getNetworkConfig();
        ClientNetworkConfig alternativeNetworkConfig = alternativeConfig.getNetworkConfig();
        if (mainNetworkConfig == null && alternativeNetworkConfig == null) {
            return;
        }
        if (mainNetworkConfig == null || alternativeNetworkConfig == null) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "network");
        }
        if (mainNetworkConfig.isSmartRouting() != alternativeNetworkConfig.isSmartRouting()) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "network:smartRouting");
        }
        if (mainNetworkConfig.isRedoOperation() != alternativeNetworkConfig.isRedoOperation()) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "network:redoOperation");
        }
        if (mainNetworkConfig.getConnectionTimeout() != alternativeNetworkConfig.getConnectionTimeout()) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "network:connectionTimeout");
        }
        if (FailoverClientConfigSupport.notEqual(mainNetworkConfig.getSocketOptions(), alternativeNetworkConfig.getSocketOptions())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "network:socketOptions");
        }
        if (FailoverClientConfigSupport.notEqual(mainNetworkConfig.getOutboundPortDefinitions(), alternativeNetworkConfig.getOutboundPortDefinitions())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "network:outboundPortDefinitions");
        }
        if (FailoverClientConfigSupport.notEqual(mainNetworkConfig.getOutboundPorts(), alternativeNetworkConfig.getOutboundPorts())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "network:smartRouting");
        }
        if (FailoverClientConfigSupport.notEqual(mainNetworkConfig.getClientIcmpPingConfig(), alternativeNetworkConfig.getClientIcmpPingConfig())) {
            FailoverClientConfigSupport.throwInvalidConfigurationException(mainClusterName, alterNativeClusterName, "network:clientIcmp");
        }
    }
}

