/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal;

import com.hazelcast.core.DistributedObject;
import com.hazelcast.core.HazelcastException;
import com.hazelcast.cp.CPGroup;
import com.hazelcast.cp.CPGroupId;
import com.hazelcast.cp.CPMember;
import com.hazelcast.cp.CPSubsystem;
import com.hazelcast.cp.CPSubsystemManagementService;
import com.hazelcast.cp.IAtomicLong;
import com.hazelcast.cp.IAtomicReference;
import com.hazelcast.cp.ICountDownLatch;
import com.hazelcast.cp.ISemaphore;
import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.datastructures.spi.RaftRemoteService;
import com.hazelcast.cp.lock.FencedLock;
import com.hazelcast.cp.session.CPSessionManagementService;
import com.hazelcast.instance.impl.HazelcastInstanceImpl;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.logging.ILogger;
import com.hazelcast.spi.impl.InternalCompletableFuture;
import java.util.Collection;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;

public class CPSubsystemImpl
implements CPSubsystem {
    private final HazelcastInstanceImpl instance;
    private final boolean cpSubsystemEnabled;
    private volatile CPSubsystemManagementService cpSubsystemManagementService;

    public CPSubsystemImpl(HazelcastInstanceImpl instance) {
        this.instance = instance;
        int cpMemberCount = instance.getConfig().getCPSubsystemConfig().getCPMemberCount();
        this.cpSubsystemEnabled = cpMemberCount > 0;
        ILogger logger = instance.node.getLogger(CPSubsystem.class);
        if (this.cpSubsystemEnabled) {
            logger.info("CP Subsystem is enabled with " + cpMemberCount + " members.");
        } else {
            logger.warning("CP Subsystem is not enabled. CP data structures will operate in UNSAFE mode! Please note that UNSAFE mode will not provide strong consistency guarantees.");
        }
    }

    @Override
    @Nonnull
    public IAtomicLong getAtomicLong(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic long instance with a null name is not allowed!");
        return (IAtomicLong)this.createProxy("hz:raft:atomicLongService", name);
    }

    @Override
    @Nonnull
    public <E> IAtomicReference<E> getAtomicReference(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an atomic reference instance with a null name is not allowed!");
        return (IAtomicReference)this.createProxy("hz:raft:atomicRefService", name);
    }

    @Override
    @Nonnull
    public ICountDownLatch getCountDownLatch(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a count down latch instance with a null name is not allowed!");
        return (ICountDownLatch)this.createProxy("hz:raft:countDownLatchService", name);
    }

    @Override
    @Nonnull
    public FencedLock getLock(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving an fenced lock instance with a null name is not allowed!");
        return (FencedLock)this.createProxy("hz:raft:lockService", name);
    }

    @Override
    @Nonnull
    public ISemaphore getSemaphore(@Nonnull String name) {
        Preconditions.checkNotNull(name, "Retrieving a semaphore instance with a null name is not allowed!");
        return (ISemaphore)this.createProxy("hz:raft:semaphoreService", name);
    }

    @Override
    public CPMember getLocalCPMember() {
        return this.getCPSubsystemManagementService().getLocalCPMember();
    }

    @Override
    public CPSubsystemManagementService getCPSubsystemManagementService() {
        if (!this.cpSubsystemEnabled) {
            throw new HazelcastException("CP Subsystem is not enabled!");
        }
        if (this.cpSubsystemManagementService != null) {
            return this.cpSubsystemManagementService;
        }
        RaftService raftService = (RaftService)this.getService("hz:core:raft");
        this.cpSubsystemManagementService = new CPSubsystemManagementServiceImpl(raftService);
        return this.cpSubsystemManagementService;
    }

    @Override
    public CPSessionManagementService getCPSessionManagementService() {
        if (!this.cpSubsystemEnabled) {
            throw new HazelcastException("CP Subsystem is not enabled!");
        }
        return (CPSessionManagementService)this.getService("hz:core:raftSession");
    }

    private <T> T getService(@Nonnull String serviceName) {
        return this.instance.node.getNodeEngine().getService(serviceName);
    }

    private <T extends DistributedObject> T createProxy(String serviceName, String name) {
        RaftRemoteService service = (RaftRemoteService)this.getService(serviceName);
        return service.createProxy(name);
    }

    private static class CPSubsystemManagementServiceImpl
    implements CPSubsystemManagementService {
        private final RaftService raftService;

        CPSubsystemManagementServiceImpl(RaftService raftService) {
            this.raftService = raftService;
        }

        @Override
        public CPMember getLocalCPMember() {
            return this.raftService.getLocalCPMember();
        }

        public InternalCompletableFuture<Collection<CPGroupId>> getCPGroupIds() {
            return this.raftService.getCPGroupIds();
        }

        public InternalCompletableFuture<CPGroup> getCPGroup(String name) {
            return this.raftService.getCPGroup(name);
        }

        public InternalCompletableFuture<Void> forceDestroyCPGroup(String groupName) {
            return this.raftService.forceDestroyCPGroup(groupName);
        }

        public InternalCompletableFuture<Collection<CPMember>> getCPMembers() {
            return this.raftService.getCPMembers();
        }

        public InternalCompletableFuture<Void> promoteToCPMember() {
            return this.raftService.promoteToCPMember();
        }

        public InternalCompletableFuture<Void> removeCPMember(UUID cpMemberUuid) {
            return this.raftService.removeCPMember(cpMemberUuid);
        }

        public InternalCompletableFuture<Void> reset() {
            return this.raftService.resetCPSubsystem();
        }

        @Override
        public boolean isDiscoveryCompleted() {
            return this.raftService.isDiscoveryCompleted();
        }

        @Override
        public boolean awaitUntilDiscoveryCompleted(long timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.raftService.awaitUntilDiscoveryCompleted(timeout, timeUnit);
        }
    }
}

