/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.metrics.impl;

import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsPublisher;
import com.hazelcast.internal.metrics.collectors.MetricsCollector;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;

public class PublisherMetricsCollector
implements MetricsCollector {
    private final ILogger logger = Logger.getLogger(PublisherMetricsCollector.class);
    private final MetricsPublisher[] publishers;

    public PublisherMetricsCollector(MetricsPublisher ... publishers) {
        this.publishers = publishers;
    }

    public void publishCollectedMetrics() {
        for (MetricsPublisher publisher : this.publishers) {
            try {
                publisher.whenComplete();
            }
            catch (Exception e) {
                this.logger.severe("Error completing publication for publisher " + publisher, e);
            }
        }
    }

    public void shutdown() {
        for (MetricsPublisher publisher : this.publishers) {
            try {
                publisher.shutdown();
            }
            catch (Exception e) {
                this.logger.warning("Error shutting down metrics publisher " + publisher.name(), e);
            }
        }
    }

    @Override
    public void collectLong(MetricDescriptor descriptor, long value) {
        for (MetricsPublisher publisher : this.publishers) {
            try {
                publisher.publishLong(descriptor, value);
            }
            catch (Exception e) {
                this.logError(descriptor, value, publisher, e);
            }
        }
    }

    @Override
    public void collectDouble(MetricDescriptor descriptor, double value) {
        for (MetricsPublisher publisher : this.publishers) {
            try {
                publisher.publishDouble(descriptor, value);
            }
            catch (Exception e) {
                this.logError(descriptor, value, publisher, e);
            }
        }
    }

    @Override
    public void collectException(MetricDescriptor descriptor, Exception e) {
        this.logger.warning("Error when collecting '" + descriptor.toString() + '\'', e);
    }

    @Override
    public void collectNoValue(MetricDescriptor descriptor) {
    }

    private void logError(MetricDescriptor descriptor, Object value, MetricsPublisher publisher, Exception e) {
        this.logger.fine("Error publishing metric to: " + publisher.name() + ", metric=" + descriptor.toString() + ", value=" + value, e);
    }
}

