/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl;

import com.hazelcast.core.EntryView;
import com.hazelcast.internal.serialization.Data;
import com.hazelcast.internal.serialization.SerializationService;
import com.hazelcast.map.impl.SimpleEntryView;
import com.hazelcast.map.impl.record.Record;
import com.hazelcast.map.impl.wan.WanMapEntryView;

public final class EntryViews {
    private EntryViews() {
    }

    public static <K, V> EntryView<K, V> createSimpleEntryView() {
        return new SimpleEntryView();
    }

    public static <K, V> EntryView<K, V> createSimpleEntryView(K key, V value, Record record) {
        return new SimpleEntryView<K, V>(key, value).withCost(record.getCost()).withVersion(record.getVersion()).withHits(record.getHits()).withLastAccessTime(record.getLastAccessTime()).withLastUpdateTime(record.getLastUpdateTime()).withTtl(record.getTtl()).withMaxIdle(record.getMaxIdle()).withCreationTime(record.getCreationTime()).withExpirationTime(record.getExpirationTime()).withLastStoredTime(record.getLastStoredTime());
    }

    public static <K, V> WanMapEntryView<K, V> createWanEntryView(Data key, Data value, Record<V> record, SerializationService serializationService) {
        return new WanMapEntryView(key, value, serializationService).withCost(record.getCost()).withVersion(record.getVersion()).withHits(record.getHits()).withLastAccessTime(record.getLastAccessTime()).withLastUpdateTime(record.getLastUpdateTime()).withTtl(record.getTtl()).withMaxIdle(record.getMaxIdle()).withCreationTime(record.getCreationTime()).withExpirationTime(record.getExpirationTime()).withLastStoredTime(record.getLastStoredTime());
    }
}

