/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.record;

import com.hazelcast.internal.util.Clock;
import com.hazelcast.internal.util.TimeUtil;
import com.hazelcast.map.impl.record.RecordReaderWriter;
import com.hazelcast.query.impl.Metadata;
import java.util.concurrent.TimeUnit;

public interface Record<V> {
    public static final long EPOCH_TIME = TimeUtil.zeroOutMs(1514764800000L);
    public static final int UNSET = -1;
    public static final Object NOT_CACHED = new Object();

    public V getValue();

    public void setValue(V var1);

    public long getCost();

    public long getVersion();

    public void setVersion(long var1);

    public Object getCachedValueUnsafe();

    public boolean casCachedValue(Object var1, Object var2);

    public long getLastAccessTime();

    public void setLastAccessTime(long var1);

    public long getLastUpdateTime();

    public void setLastUpdateTime(long var1);

    public long getCreationTime();

    public void setCreationTime(long var1);

    public int getHits();

    public void setHits(int var1);

    public long getExpirationTime();

    public void setExpirationTime(long var1);

    public long getLastStoredTime();

    public void setLastStoredTime(long var1);

    public long getSequence();

    public void setSequence(long var1);

    public void setMetadata(Metadata var1);

    public Metadata getMetadata();

    default public long recomputeWithBaseTime(int value) {
        if (value == -1) {
            return 0L;
        }
        long exploded = TimeUnit.SECONDS.toMillis(value);
        return exploded + EPOCH_TIME;
    }

    default public int stripBaseTime(long value) {
        int diff = -1;
        if (value > 0L) {
            diff = (int)TimeUnit.MILLISECONDS.toSeconds(value - EPOCH_TIME);
        }
        return diff;
    }

    default public long getTtl() {
        int ttl = this.getRawTtl();
        return ttl == Integer.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.SECONDS.toMillis(ttl);
    }

    default public void setTtl(long ttl) {
        long ttlSeconds = TimeUnit.MILLISECONDS.toSeconds(ttl);
        if (ttlSeconds == 0L && ttl != 0L) {
            ttlSeconds = 1L;
        }
        this.setRawTtl(ttlSeconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)ttlSeconds);
    }

    default public long getMaxIdle() {
        int maxIdle = this.getRawMaxIdle();
        return maxIdle == Integer.MAX_VALUE ? Long.MAX_VALUE : TimeUnit.SECONDS.toMillis(maxIdle);
    }

    default public void setMaxIdle(long maxIdle) {
        long maxIdleSeconds = TimeUnit.MILLISECONDS.toSeconds(maxIdle);
        if (maxIdleSeconds == 0L && maxIdle != 0L) {
            maxIdleSeconds = 1L;
        }
        this.setRawMaxIdle(maxIdleSeconds > Integer.MAX_VALUE ? Integer.MAX_VALUE : (int)maxIdleSeconds);
    }

    default public void onAccess(long now) {
        int hits = this.getHits();
        if (hits < Integer.MAX_VALUE) {
            this.setHits(hits + 1);
        }
        this.onAccessSafe(now);
    }

    default public void onAccessSafe(long now) {
        this.setLastAccessTime(now);
    }

    default public void onUpdate(long now) {
        this.setVersion(this.getVersion() + 1L);
        this.setLastUpdateTime(now);
    }

    default public void onStore() {
        this.setLastStoredTime(Clock.currentTimeMillis());
    }

    public RecordReaderWriter getMatchingRecordReaderWriter();

    public int getRawTtl();

    public int getRawMaxIdle();

    public int getRawCreationTime();

    public int getRawLastAccessTime();

    public int getRawLastUpdateTime();

    public void setRawTtl(int var1);

    public void setRawMaxIdle(int var1);

    public void setRawCreationTime(int var1);

    public void setRawLastAccessTime(int var1);

    public void setRawLastUpdateTime(int var1);

    public int getRawLastStoredTime();

    public void setRawLastStoredTime(int var1);

    public int getRawExpirationTime();

    public void setRawExpirationTime(int var1);
}

