/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.scheduledexecutor.impl;

import com.hazelcast.cluster.Address;
import com.hazelcast.cluster.Member;
import com.hazelcast.core.ManagedContext;
import com.hazelcast.internal.cluster.ClusterService;
import com.hazelcast.internal.partition.IPartitionService;
import com.hazelcast.internal.util.ExceptionUtil;
import com.hazelcast.internal.util.FutureUtil;
import com.hazelcast.internal.util.MapUtil;
import com.hazelcast.internal.util.Preconditions;
import com.hazelcast.internal.util.UuidUtil;
import com.hazelcast.logging.ILogger;
import com.hazelcast.partition.PartitionAware;
import com.hazelcast.scheduledexecutor.IScheduledExecutorService;
import com.hazelcast.scheduledexecutor.IScheduledFuture;
import com.hazelcast.scheduledexecutor.NamedTask;
import com.hazelcast.scheduledexecutor.ScheduledTaskHandler;
import com.hazelcast.scheduledexecutor.impl.DistributedScheduledExecutorService;
import com.hazelcast.scheduledexecutor.impl.HashMapAdapter;
import com.hazelcast.scheduledexecutor.impl.InvokeOnMembers;
import com.hazelcast.scheduledexecutor.impl.NamedTaskDecorator;
import com.hazelcast.scheduledexecutor.impl.ScheduledFutureProxy;
import com.hazelcast.scheduledexecutor.impl.ScheduledRunnableAdapter;
import com.hazelcast.scheduledexecutor.impl.ScheduledTaskHandlerImpl;
import com.hazelcast.scheduledexecutor.impl.TaskDefinition;
import com.hazelcast.scheduledexecutor.impl.operations.GetAllScheduledOnMemberOperation;
import com.hazelcast.scheduledexecutor.impl.operations.GetAllScheduledOnPartitionOperationFactory;
import com.hazelcast.scheduledexecutor.impl.operations.ScheduleTaskOperation;
import com.hazelcast.scheduledexecutor.impl.operations.ShutdownOperation;
import com.hazelcast.spi.impl.AbstractDistributedObject;
import com.hazelcast.spi.impl.NodeEngine;
import com.hazelcast.spi.impl.operationservice.Operation;
import com.hazelcast.spi.impl.operationservice.OperationService;
import com.hazelcast.splitbrainprotection.SplitBrainProtectionException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.logging.Level;
import javax.annotation.Nonnull;

public class ScheduledExecutorServiceProxy
extends AbstractDistributedObject<DistributedScheduledExecutorService>
implements IScheduledExecutorService {
    private static final int SHUTDOWN_TIMEOUT = 10;
    private final FutureUtil.ExceptionHandler shutdownExceptionHandler = new FutureUtil.ExceptionHandler(){

        @Override
        public void handleException(Throwable throwable) {
            if (throwable != null) {
                if (throwable instanceof SplitBrainProtectionException) {
                    ExceptionUtil.sneakyThrow(throwable);
                }
                if (throwable.getCause() instanceof SplitBrainProtectionException) {
                    ExceptionUtil.sneakyThrow(throwable.getCause());
                }
            }
            if (ScheduledExecutorServiceProxy.this.logger.isLoggable(Level.FINEST)) {
                ScheduledExecutorServiceProxy.this.logger.log(Level.FINEST, "Exception while ExecutorService shutdown", throwable);
            }
        }
    };
    private final String name;
    private final ILogger logger;

    ScheduledExecutorServiceProxy(String name, NodeEngine nodeEngine, DistributedScheduledExecutorService service) {
        super(nodeEngine, service);
        this.name = name;
        this.logger = nodeEngine.getLogger(ScheduledExecutorServiceProxy.class);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:scheduledExecutorService";
    }

    @Nonnull
    public IScheduledFuture schedule(@Nonnull Runnable command, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        ScheduledRunnableAdapter callable = this.createScheduledRunnableAdapter(command);
        return this.schedule(callable, delay, unit);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> schedule(@Nonnull Callable<V> command, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getTaskOrKeyPartitionId(command, (Object)name);
        TaskDefinition<V> definition = new TaskDefinition<V>(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
        return this.submitOnPartitionSync(name, new ScheduleTaskOperation(this.getName(), definition), partitionId);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleAtFixedRate(@Nonnull Runnable command, long initialDelay, long period, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getTaskOrKeyPartitionId(command, (Object)name);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
        return this.submitOnPartitionSync(name, new ScheduleTaskOperation(this.getName(), definition), partitionId);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnMember(@Nonnull Runnable command, @Nonnull Member member, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(member, "Member is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        Map<Member, IScheduledFuture<V>> futureMap = this.scheduleOnMembers(command, Collections.singleton(member), delay, unit);
        return futureMap.get(member);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnMember(@Nonnull Callable<V> command, @Nonnull Member member, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(member, "Member is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        return this.scheduleOnMembers(command, Collections.singleton(member), delay, unit).get(member);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnMemberAtFixedRate(@Nonnull Runnable command, @Nonnull Member member, long initialDelay, long period, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(member, "Member is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        Map<Member, IScheduledFuture<V>> futureMap = this.scheduleOnMembersAtFixedRate(command, Collections.singleton(member), initialDelay, period, unit);
        return futureMap.get(member);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnKeyOwner(@Nonnull Runnable command, @Nonnull Object key, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        ScheduledRunnableAdapter callable = this.createScheduledRunnableAdapter(command);
        return this.scheduleOnKeyOwner(callable, key, delay, unit);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnKeyOwner(@Nonnull Callable<V> command, @Nonnull Object key, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(key, "Key is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getKeyPartitionId(key);
        TaskDefinition<V> definition = new TaskDefinition<V>(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
        return this.submitOnPartitionSync(name, new ScheduleTaskOperation(this.getName(), definition), partitionId);
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> scheduleOnKeyOwnerAtFixedRate(@Nonnull Runnable command, @Nonnull Object key, long initialDelay, long period, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(key, "Key is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        String name = this.extractNameOrGenerateOne(command);
        int partitionId = this.getKeyPartitionId(key);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
        return this.submitOnPartitionSync(name, new ScheduleTaskOperation(this.getName(), definition), partitionId);
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnAllMembers(@Nonnull Runnable command, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        return this.scheduleOnMembers(command, this.getNodeEngine().getClusterService().getMembers(), delay, unit);
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnAllMembers(@Nonnull Callable<V> command, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        return this.scheduleOnMembers(command, this.getNodeEngine().getClusterService().getMembers(), delay, unit);
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnAllMembersAtFixedRate(@Nonnull Runnable command, long initialDelay, long period, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        return this.scheduleOnMembersAtFixedRate(command, this.getNodeEngine().getClusterService().getMembers(), initialDelay, period, unit);
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnMembers(@Nonnull Runnable command, @Nonnull Collection<Member> members, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(members, "Members is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        ScheduledRunnableAdapter callable = this.createScheduledRunnableAdapter(command);
        return this.scheduleOnMembers(callable, members, delay, unit);
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnMembers(@Nonnull Callable<V> command, @Nonnull Collection<Member> members, long delay, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(members, "Members is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        String name = this.extractNameOrGenerateOne(command);
        Map<Member, IScheduledFuture<IScheduledFuture<V>>> futures = MapUtil.createHashMap(members.size());
        for (Member member : members) {
            TaskDefinition<V> definition = new TaskDefinition<V>(TaskDefinition.Type.SINGLE_RUN, name, command, delay, unit);
            futures.put(member, this.submitOnMemberSync(name, new ScheduleTaskOperation(this.getName(), definition), member));
        }
        return futures;
    }

    @Override
    @Nonnull
    public <V> Map<Member, IScheduledFuture<V>> scheduleOnMembersAtFixedRate(@Nonnull Runnable command, @Nonnull Collection<Member> members, long initialDelay, long period, @Nonnull TimeUnit unit) {
        Preconditions.checkNotNull(command, "Command is null");
        Preconditions.checkNotNull(members, "Members is null");
        Preconditions.checkNotNull(unit, "Unit is null");
        this.initializeManagedContext(command);
        String name = this.extractNameOrGenerateOne(command);
        ScheduledRunnableAdapter adapter = this.createScheduledRunnableAdapter(command);
        Map<Member, IScheduledFuture<IScheduledFuture<V>>> futures = ScheduledExecutorServiceProxy.createHashMapAdapter(members.size());
        for (Member member : members) {
            TaskDefinition definition = new TaskDefinition(TaskDefinition.Type.AT_FIXED_RATE, name, adapter, initialDelay, period, unit);
            futures.put(member, this.submitOnMemberSync(name, new ScheduleTaskOperation(this.getName(), definition), member));
        }
        return futures;
    }

    @Override
    @Nonnull
    public <V> IScheduledFuture<V> getScheduledFuture(@Nonnull ScheduledTaskHandler handler) {
        Preconditions.checkNotNull(handler, "Handler is null");
        ScheduledFutureProxy proxy = new ScheduledFutureProxy(handler, this);
        this.initializeManagedContext(proxy);
        return proxy;
    }

    @Override
    @Nonnull
    public <V> Map<Member, List<IScheduledFuture<V>>> getAllScheduledFutures() {
        LinkedHashMap<Member, List<IScheduledFuture<V>>> accumulator = new LinkedHashMap<Member, List<IScheduledFuture<V>>>();
        this.retrieveAllPartitionOwnedScheduled(accumulator);
        this.retrieveAllMemberOwnedScheduled(accumulator);
        return accumulator;
    }

    @Override
    public void shutdown() {
        NodeEngine nodeEngine = this.getNodeEngine();
        Set<Member> members = nodeEngine.getClusterService().getMembers();
        OperationService operationService = nodeEngine.getOperationService();
        LinkedList calls = new LinkedList();
        for (Member member : members) {
            ShutdownOperation op = new ShutdownOperation(this.name);
            calls.add(operationService.invokeOnTarget("hz:impl:scheduledExecutorService", op, member.getAddress()));
        }
        FutureUtil.waitWithDeadline(calls, 10L, TimeUnit.SECONDS, this.shutdownExceptionHandler);
    }

    private <V> void retrieveAllMemberOwnedScheduled(Map<Member, List<IScheduledFuture<V>>> accumulator) {
        try {
            InvokeOnMembers invokeOnMembers = new InvokeOnMembers(this.getNodeEngine(), this.getServiceName(), new GetAllScheduledOnMemberOperationFactory(this.name), this.getNodeEngine().getClusterService().getMembers());
            this.accumulateTaskHandlersAsScheduledFutures(accumulator, invokeOnMembers.invoke());
        }
        catch (Exception e) {
            throw ExceptionUtil.rethrow(e);
        }
    }

    private <V> void retrieveAllPartitionOwnedScheduled(Map<Member, List<IScheduledFuture<V>>> accumulator) {
        try {
            this.accumulateTaskHandlersAsScheduledFutures(accumulator, this.getNodeEngine().getOperationService().invokeOnAllPartitions(this.getServiceName(), new GetAllScheduledOnPartitionOperationFactory(this.name)));
        }
        catch (Throwable t) {
            throw ExceptionUtil.rethrow(t);
        }
    }

    private <V> void accumulateTaskHandlersAsScheduledFutures(Map<Member, List<IScheduledFuture<V>>> accumulator, Map<?, ?> taskHandlersMap) {
        ClusterService clusterService = this.getNodeEngine().getClusterService();
        IPartitionService partitionService = this.getNodeEngine().getPartitionService();
        for (Map.Entry<?, ?> entry : taskHandlersMap.entrySet()) {
            Object key = entry.getKey();
            Member owner = key instanceof Number ? clusterService.getMember(partitionService.getPartitionOwner((Integer)key)) : (Member)key;
            List handlers = (List)entry.getValue();
            ArrayList futures = new ArrayList();
            for (ScheduledTaskHandler handler : handlers) {
                ScheduledFutureProxy future = new ScheduledFutureProxy(handler, this);
                this.initializeManagedContext(future);
                futures.add(future);
            }
            if (accumulator.containsKey(owner)) {
                List<IScheduledFuture<V>> memberFutures = accumulator.get(owner);
                memberFutures.addAll(futures);
                continue;
            }
            accumulator.put(owner, futures);
        }
    }

    private <T> ScheduledRunnableAdapter<T> createScheduledRunnableAdapter(Runnable command) {
        Preconditions.checkNotNull(command, "Command can't be null");
        return new ScheduledRunnableAdapter(command);
    }

    private static <K, V> Map<K, V> createHashMapAdapter(int expectedMapSize) {
        int initialCapacity = MapUtil.calculateInitialCapacity(expectedMapSize);
        return new HashMapAdapter(initialCapacity, 0.75f);
    }

    @Nonnull
    private <V> IScheduledFuture<V> createFutureProxy(int partitionId, String taskName) {
        ScheduledFutureProxy proxy = new ScheduledFutureProxy(ScheduledTaskHandlerImpl.of(partitionId, this.getName(), taskName), this);
        proxy.setHazelcastInstance(this.getNodeEngine().getHazelcastInstance());
        return proxy;
    }

    @Nonnull
    private <V> IScheduledFuture<V> createFutureProxy(UUID uuid, String taskName) {
        ScheduledFutureProxy proxy = new ScheduledFutureProxy(ScheduledTaskHandlerImpl.of(uuid, this.getName(), taskName), this);
        proxy.setHazelcastInstance(this.getNodeEngine().getHazelcastInstance());
        return proxy;
    }

    private int getKeyPartitionId(Object key) {
        return this.getNodeEngine().getPartitionService().getPartitionId(key);
    }

    private int getTaskOrKeyPartitionId(Callable task, Object key) {
        Object newKey;
        if (task instanceof PartitionAware && (newKey = ((PartitionAware)((Object)task)).getPartitionKey()) != null) {
            key = newKey;
        }
        return this.getKeyPartitionId(key);
    }

    private int getTaskOrKeyPartitionId(Runnable task, Object key) {
        Object newKey;
        if (task instanceof PartitionAware && (newKey = ((PartitionAware)((Object)task)).getPartitionKey()) != null) {
            key = newKey;
        }
        return this.getKeyPartitionId(key);
    }

    private String extractNameOrGenerateOne(Object command) {
        String name = null;
        if (command instanceof NamedTask) {
            name = ((NamedTask)command).getName();
        }
        return name != null ? name : UuidUtil.newUnsecureUuidString();
    }

    @Nonnull
    private <V> IScheduledFuture<V> submitOnPartitionSync(String taskName, Operation op, int partitionId) {
        op.setPartitionId(partitionId);
        this.invokeOnPartition(op).joinInternal();
        return this.createFutureProxy(partitionId, taskName);
    }

    @Nonnull
    private <V> IScheduledFuture<V> submitOnMemberSync(String taskName, Operation op, Member member) {
        UUID uuid = member.getUuid();
        Address address = member.getAddress();
        this.getOperationService().invokeOnTarget(this.getServiceName(), op, address).joinInternal();
        return this.createFutureProxy(uuid, taskName);
    }

    private void initializeManagedContext(Object object) {
        ManagedContext context = this.getNodeEngine().getSerializationService().getManagedContext();
        if (object instanceof NamedTaskDecorator) {
            ((NamedTaskDecorator)object).initializeContext(context);
        } else {
            context.initialize(object);
        }
    }

    private static class GetAllScheduledOnMemberOperationFactory
    implements Supplier<Operation> {
        private final String schedulerName;

        GetAllScheduledOnMemberOperationFactory(String schedulerName) {
            this.schedulerName = schedulerName;
        }

        @Override
        public Operation get() {
            return new GetAllScheduledOnMemberOperation(this.schedulerName);
        }
    }
}

