/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nio;

import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelErrorHandler;
import com.hazelcast.internal.networking.ChannelHandler;
import com.hazelcast.internal.networking.nio.MigratablePipeline;
import com.hazelcast.internal.networking.nio.NioChannel;
import com.hazelcast.internal.networking.nio.NioInboundPipeline;
import com.hazelcast.internal.networking.nio.NioOutboundPipeline;
import com.hazelcast.internal.networking.nio.NioThread;
import com.hazelcast.internal.networking.nio.iobalancer.IOBalancer;
import com.hazelcast.internal.util.counters.SwCounter;
import com.hazelcast.logging.ILogger;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicReference;

public abstract class NioPipeline
implements MigratablePipeline,
Runnable {
    protected static final int LOAD_BALANCING_HANDLE = 0;
    protected static final int LOAD_BALANCING_BYTE = 1;
    protected static final int LOAD_BALANCING_FRAME = 2;
    protected final int loadType = Integer.getInteger("hazelcast.io.load", 1);
    @Probe(name="processCount")
    protected final SwCounter processCount = SwCounter.newSwCounter();
    protected final ILogger logger;
    protected final NioChannel channel;
    protected final SocketChannel socketChannel;
    protected volatile NioThread owner;
    protected volatile SelectionKey selectionKey;
    private final ChannelErrorHandler errorHandler;
    private final int initialOps;
    private final IOBalancer ioBalancer;
    private final AtomicReference<TaskNode> delayedTaskStack = new AtomicReference();
    @Probe(name="ownerId")
    private volatile int ownerId;
    @Probe(name="startedMigrations")
    private final SwCounter startedMigrations = SwCounter.newSwCounter();
    @Probe(name="completedMigrations")
    private final SwCounter completedMigrations = SwCounter.newSwCounter();
    private volatile NioThread newOwner;

    NioPipeline(NioChannel channel, NioThread owner, ChannelErrorHandler errorHandler, int initialOps, ILogger logger, IOBalancer ioBalancer) {
        this.channel = channel;
        this.socketChannel = channel.socketChannel();
        this.owner = owner;
        this.ownerId = owner.id;
        this.logger = logger;
        this.initialOps = initialOps;
        this.ioBalancer = ioBalancer;
        this.errorHandler = errorHandler;
    }

    public Channel getChannel() {
        return this.channel;
    }

    @Probe(name="opsInterested", level=ProbeLevel.DEBUG)
    private long opsInterested() {
        SelectionKey selectionKey = this.selectionKey;
        return selectionKey == null ? -1L : (long)selectionKey.interestOps();
    }

    @Probe(name="opsReady", level=ProbeLevel.DEBUG)
    private long opsReady() {
        SelectionKey selectionKey = this.selectionKey;
        return selectionKey == null ? -1L : (long)selectionKey.readyOps();
    }

    @Override
    public NioThread owner() {
        return this.owner;
    }

    void start() {
        this.owner.addTaskAndWakeup(() -> {
            try {
                this.initSelectionKey();
                this.process();
            }
            catch (Throwable t) {
                this.onError(t);
            }
        });
    }

    final void initSelectionKey() throws ClosedChannelException {
        this.initSelectionKey(this.owner.getSelector(), this.initialOps);
    }

    final void initSelectionKey(Selector selector, int ops) throws ClosedChannelException {
        this.selectionKey = this.socketChannel.register(selector, ops, this);
    }

    final void registerOp(int operation) {
        this.selectionKey.interestOps(this.selectionKey.interestOps() | operation);
    }

    final void unregisterOp(int operation) {
        int interestOps = this.selectionKey.interestOps();
        if ((interestOps & operation) != 0) {
            this.selectionKey.interestOps(interestOps & ~operation);
        }
    }

    abstract void publishMetrics();

    abstract void process() throws Exception;

    final void ownerAddTaskAndWakeup(Runnable task) {
        NioThread localOwner;
        TaskNode update;
        TaskNode old;
        do {
            if ((localOwner = this.owner) == null) continue;
            localOwner.addTaskAndWakeup(task);
            return;
        } while (!this.delayedTaskStack.compareAndSet(old = this.delayedTaskStack.get(), update = new TaskNode(task, old)));
        localOwner = this.owner;
        if (localOwner != null) {
            this.restoreTasks(localOwner, this.delayedTaskStack.getAndSet(null), true);
        }
    }

    private void restoreTasks(NioThread owner, TaskNode node, boolean wakeup) {
        if (node == null) {
            return;
        }
        this.restoreTasks(owner, node.next, false);
        if (wakeup) {
            owner.addTaskAndWakeup(node.task);
        } else {
            owner.addTask(node.task);
        }
    }

    @Override
    public final void run() {
        if (this.owner == Thread.currentThread()) {
            try {
                this.process();
            }
            catch (Throwable t) {
                this.onError(t);
            }
        } else {
            this.ownerAddTaskAndWakeup(this);
        }
    }

    public void onError(Throwable error) {
        SelectionKey selectionKey;
        if (error instanceof InterruptedException) {
            Thread.currentThread().interrupt();
        }
        if ((selectionKey = this.selectionKey) != null) {
            selectionKey.cancel();
        }
        try {
            for (ChannelHandler channelHandler : this.handlers()) {
                channelHandler.interceptError(error);
            }
        }
        catch (Throwable newError) {
            error = newError;
        }
        this.errorHandler.onError(this.channel, error);
    }

    protected abstract Iterable<? extends ChannelHandler> handlers();

    @Override
    public final void requestMigration(NioThread newOwner) {
        this.newOwner = newOwner;
        if (this instanceof NioOutboundPipeline) {
            ((NioOutboundPipeline)this).wakeup();
        } else {
            ((NioInboundPipeline)this).wakeup();
        }
    }

    boolean migrationRequested() {
        return this.newOwner != null;
    }

    void startMigration() {
        assert (this.newOwner != null) : "newOwner can't be null";
        assert (this.owner != this.newOwner) : "newOwner can't be the same as the existing owner";
        this.publishMetrics();
        if (!this.socketChannel.isOpen()) {
            return;
        }
        this.startedMigrations.inc();
        this.unregisterOp(this.initialOps);
        this.selectionKey.cancel();
        this.selectionKey = null;
        this.owner = null;
        this.ownerId = -1;
        this.newOwner.addTaskAndWakeup(new CompleteMigrationTask(this.newOwner));
    }

    private static class TaskNode {
        private final Runnable task;
        private final TaskNode next;

        TaskNode(Runnable task, TaskNode next) {
            this.task = task;
            this.next = next;
        }
    }

    private class CompleteMigrationTask
    implements Runnable {
        private final NioThread newOwner;

        CompleteMigrationTask(NioThread newOwner) {
            this.newOwner = newOwner;
        }

        @Override
        public void run() {
            try {
                assert (NioPipeline.this.owner == null);
                NioPipeline.this.owner = this.newOwner;
                NioPipeline.this.ownerId = this.newOwner.id;
                NioPipeline.this.restoreTasks(NioPipeline.this.owner, NioPipeline.this.delayedTaskStack.getAndSet(null), false);
                NioPipeline.this.completedMigrations.inc();
                NioPipeline.this.ioBalancer.signalMigrationComplete();
                if (!NioPipeline.this.socketChannel.isOpen()) {
                    return;
                }
                NioPipeline.this.initSelectionKey();
                NioPipeline.this.newOwner = null;
            }
            catch (Throwable t) {
                NioPipeline.this.onError(t);
            }
        }
    }
}

