/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.state;

import com.hazelcast.sql.impl.operation.QueryAbstractExchangeOperation;
import com.hazelcast.sql.impl.worker.QueryFragmentExecutable;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class QueryDistributedState {
    private final ConcurrentLinkedDeque<QueryAbstractExchangeOperation> pendingOperations = new ConcurrentLinkedDeque();
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private volatile InitializedState initializedState;

    public boolean isStarted() {
        return this.initializedState != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onStart(List<QueryFragmentExecutable> fragments) {
        this.lock.writeLock().lock();
        try {
            this.initializedState = new InitializedState(fragments);
            boolean hadPendingBatches = false;
            for (QueryAbstractExchangeOperation pendingOperation : this.pendingOperations) {
                this.onOperation0(pendingOperation);
                if (hadPendingBatches) continue;
                hadPendingBatches = true;
            }
            if (hadPendingBatches) {
                this.pendingOperations.clear();
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public QueryFragmentExecutable onOperation(QueryAbstractExchangeOperation operation) {
        this.lock.readLock().lock();
        try {
            if (this.initializedState != null) {
                QueryFragmentExecutable queryFragmentExecutable = this.onOperation0(operation);
                return queryFragmentExecutable;
            }
            this.pendingOperations.add(operation);
            QueryFragmentExecutable queryFragmentExecutable = null;
            return queryFragmentExecutable;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public Set<QueryFragmentExecutable> getFragments() {
        if (this.initializedState == null) {
            return Collections.emptySet();
        }
        Set<QueryFragmentExecutable> allFragments = Collections.newSetFromMap(new IdentityHashMap());
        allFragments.addAll(this.initializedState.inboundEdgeToFragment.values());
        allFragments.addAll(this.initializedState.outboundEdgeToFragment.values());
        return allFragments;
    }

    private QueryFragmentExecutable onOperation0(QueryAbstractExchangeOperation operation) {
        assert (this.initializedState != null);
        QueryFragmentExecutable fragment = this.initializedState.getFragment(operation.isInbound(), operation.getEdgeId());
        assert (fragment != null) : operation;
        fragment.addOperation(operation);
        return fragment;
    }

    public boolean onFragmentFinished() {
        assert (this.initializedState != null);
        return this.initializedState.onFragmentFinished();
    }

    private static final class InitializedState {
        private final Map<Integer, QueryFragmentExecutable> inboundEdgeToFragment = new HashMap<Integer, QueryFragmentExecutable>();
        private final Map<Integer, QueryFragmentExecutable> outboundEdgeToFragment = new HashMap<Integer, QueryFragmentExecutable>();
        private final AtomicInteger remainingFragmentCount;

        private InitializedState(List<QueryFragmentExecutable> fragmentExecutables) {
            for (QueryFragmentExecutable fragmentExecutable : fragmentExecutables) {
                QueryFragmentExecutable oldFragmentExecutable;
                for (Integer inboxEdgeId : fragmentExecutable.getInboxEdgeIds()) {
                    oldFragmentExecutable = this.inboundEdgeToFragment.put(inboxEdgeId, fragmentExecutable);
                    assert (oldFragmentExecutable == null || fragmentExecutable == oldFragmentExecutable);
                }
                for (Integer outboxEdgeId : fragmentExecutable.getOutboxEdgeIds()) {
                    oldFragmentExecutable = this.outboundEdgeToFragment.put(outboxEdgeId, fragmentExecutable);
                    assert (oldFragmentExecutable == null || fragmentExecutable == oldFragmentExecutable);
                }
            }
            this.remainingFragmentCount = new AtomicInteger(fragmentExecutables.size());
        }

        private boolean onFragmentFinished() {
            return this.remainingFragmentCount.decrementAndGet() == 0;
        }

        private QueryFragmentExecutable getFragment(boolean inbound, int edgeId) {
            if (inbound) {
                return this.inboundEdgeToFragment.get(edgeId);
            }
            return this.outboundEdgeToFragment.get(edgeId);
        }
    }
}

