/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.internal.networking.nio;

import com.hazelcast.internal.metrics.DynamicMetricsProvider;
import com.hazelcast.internal.metrics.MetricDescriptor;
import com.hazelcast.internal.metrics.MetricsCollectionContext;
import com.hazelcast.internal.metrics.MetricsRegistry;
import com.hazelcast.internal.metrics.Probe;
import com.hazelcast.internal.metrics.ProbeLevel;
import com.hazelcast.internal.metrics.ProbeUnit;
import com.hazelcast.internal.networking.Channel;
import com.hazelcast.internal.networking.ChannelCloseListener;
import com.hazelcast.internal.networking.ChannelErrorHandler;
import com.hazelcast.internal.networking.ChannelInitializer;
import com.hazelcast.internal.networking.Networking;
import com.hazelcast.internal.networking.nio.NioChannel;
import com.hazelcast.internal.networking.nio.NioInboundPipeline;
import com.hazelcast.internal.networking.nio.NioOutboundPipeline;
import com.hazelcast.internal.networking.nio.NioThread;
import com.hazelcast.internal.networking.nio.SelectorMode;
import com.hazelcast.internal.networking.nio.iobalancer.IOBalancer;
import com.hazelcast.internal.nio.IOUtil;
import com.hazelcast.internal.util.ConcurrencyDetection;
import com.hazelcast.internal.util.HashUtil;
import com.hazelcast.internal.util.ThreadAffinity;
import com.hazelcast.internal.util.ThreadUtil;
import com.hazelcast.internal.util.concurrent.BackoffIdleStrategy;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.LoggingService;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.nio.channels.SocketChannel;
import java.util.Collections;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;

public final class NioNetworking
implements Networking,
DynamicMetricsProvider {
    private final AtomicBoolean started = new AtomicBoolean();
    private final AtomicInteger nextInputThreadIndex = new AtomicInteger();
    private final AtomicInteger nextOutputThreadIndex = new AtomicInteger();
    private final ILogger logger;
    private final MetricsRegistry metricsRegistry;
    private final LoggingService loggingService;
    private final String threadNamePrefix;
    private final ChannelErrorHandler errorHandler;
    private final int balancerIntervalSeconds;
    private final int inputThreadCount;
    private final int outputThreadCount;
    private final Set<NioChannel> channels = Collections.newSetFromMap(new ConcurrentHashMap());
    private final ChannelCloseListener channelCloseListener = new ChannelCloseListenerImpl();
    private final SelectorMode selectorMode;
    private final BackoffIdleStrategy idleStrategy;
    private final boolean selectorWorkaroundTest;
    private final boolean selectionKeyWakeupEnabled;
    private final ThreadAffinity outputThreadAffinity;
    private volatile ExecutorService closeListenerExecutor;
    private final ConcurrencyDetection concurrencyDetection;
    private final boolean writeThroughEnabled;
    private final ThreadAffinity inputThreadAffinity;
    private volatile IOBalancer ioBalancer;
    private volatile NioThread[] inputThreads;
    private volatile NioThread[] outputThreads;
    private volatile ScheduledFuture publishFuture;
    @Probe(name="bytesSend", unit=ProbeUnit.BYTES)
    private volatile long bytesSend;
    @Probe(name="bytesReceived", unit=ProbeUnit.BYTES)
    private volatile long bytesReceived;
    @Probe(name="packetsSend")
    private volatile long packetsSend;
    @Probe(name="packetsReceived")
    private volatile long packetsReceived;

    public NioNetworking(Context ctx) {
        this.threadNamePrefix = ctx.threadNamePrefix;
        this.metricsRegistry = ctx.metricsRegistry;
        this.loggingService = ctx.loggingService;
        this.inputThreadCount = ctx.inputThreadCount;
        this.outputThreadCount = ctx.outputThreadCount;
        this.logger = this.loggingService.getLogger(NioNetworking.class);
        this.errorHandler = ctx.errorHandler;
        this.inputThreadAffinity = ctx.inputThreadAffinity;
        this.outputThreadAffinity = ctx.outputThreadAffinity;
        this.balancerIntervalSeconds = ctx.balancerIntervalSeconds;
        this.selectorMode = ctx.selectorMode;
        this.selectorWorkaroundTest = ctx.selectorWorkaroundTest;
        this.idleStrategy = ctx.idleStrategy;
        this.concurrencyDetection = ctx.concurrencyDetection;
        this.writeThroughEnabled = ctx.writeThroughEnabled && this.selectorMode != SelectorMode.SELECT_WITH_FIX;
        boolean bl = this.selectionKeyWakeupEnabled = ctx.selectionKeyWakeupEnabled && this.selectorMode != SelectorMode.SELECT_WITH_FIX;
        if (this.selectorMode == SelectorMode.SELECT_WITH_FIX && (ctx.writeThroughEnabled || ctx.selectionKeyWakeupEnabled)) {
            this.logger.warning("Selector mode SELECT_WITH_FIX is incompatible with write-through and selection key wakeup optimizations and they have been disabled. Start Hazelcast with options \"-Dhazelcast.io.selectionKeyWakeupEnabled=false -Dhazelcast.io.write.through=false\" to explicitly disable selection key wakeup and write-through optimizations and avoid logging this warning.");
        }
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="used only for testing")
    public NioThread[] getInputThreads() {
        return this.inputThreads;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="used only for testing")
    public NioThread[] getOutputThreads() {
        return this.outputThreads;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"}, justification="used only for testing")
    public Set<NioChannel> getChannels() {
        return this.channels;
    }

    public IOBalancer getIOBalancer() {
        return this.ioBalancer;
    }

    @Override
    public void restart() {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Can't (re)start an already running NioNetworking");
        }
        if (this.logger.isFineEnabled()) {
            this.logger.fine("TcpIpConnectionManager configured with Non Blocking IO-threading model: " + this.inputThreadCount + " input threads and " + this.outputThreadCount + " output threads");
            this.logger.fine("write through enabled:" + this.writeThroughEnabled);
        }
        this.logger.log(this.selectorMode != SelectorMode.SELECT ? Level.INFO : Level.FINE, "IO threads selector mode is " + (Object)((Object)this.selectorMode));
        this.publishFuture = this.metricsRegistry.scheduleAtFixedRate(new PublishAllTask(), 1L, TimeUnit.SECONDS, ProbeLevel.INFO);
        this.closeListenerExecutor = Executors.newSingleThreadExecutor(r -> {
            Thread t = new Thread(r);
            t.setName(this.threadNamePrefix + "-NioNetworking-closeListenerExecutor");
            return t;
        });
        NioThread[] inThreads = new NioThread[this.inputThreadCount];
        for (int i = 0; i < inThreads.length; ++i) {
            NioThread thread = new NioThread(ThreadUtil.createThreadPoolName(this.threadNamePrefix, "IO") + "in-" + i, this.loggingService.getLogger(NioThread.class), this.errorHandler, this.selectorMode, this.idleStrategy);
            thread.id = i;
            thread.setSelectorWorkaroundTest(this.selectorWorkaroundTest);
            thread.setThreadAffinity(this.inputThreadAffinity);
            inThreads[i] = thread;
            thread.start();
        }
        this.inputThreads = inThreads;
        NioThread[] outThreads = new NioThread[this.outputThreadCount];
        for (int i = 0; i < outThreads.length; ++i) {
            NioThread thread = new NioThread(ThreadUtil.createThreadPoolName(this.threadNamePrefix, "IO") + "out-" + i, this.loggingService.getLogger(NioThread.class), this.errorHandler, this.selectorMode, this.idleStrategy);
            thread.id = i;
            thread.setSelectorWorkaroundTest(this.selectorWorkaroundTest);
            thread.setThreadAffinity(this.outputThreadAffinity);
            outThreads[i] = thread;
            thread.start();
        }
        this.outputThreads = outThreads;
        this.startIOBalancer();
        this.metricsRegistry.registerDynamicMetricsProvider(this);
    }

    private void startIOBalancer() {
        this.ioBalancer = new IOBalancer(this.inputThreads, this.outputThreads, this.threadNamePrefix, this.balancerIntervalSeconds, this.loggingService);
        this.ioBalancer.start();
    }

    @Override
    public void shutdown() {
        if (!this.started.compareAndSet(true, false)) {
            return;
        }
        this.metricsRegistry.deregisterDynamicMetricsProvider(this);
        for (Channel channel : this.channels) {
            if (channel.isClosed()) continue;
            IOUtil.closeResource(channel);
        }
        this.channels.clear();
        if (this.publishFuture != null) {
            this.publishFuture.cancel(false);
            this.publishFuture = null;
        }
        this.ioBalancer.stop();
        if (this.logger.isFinestEnabled()) {
            this.logger.finest("Shutting down IO Threads... Total: " + (this.inputThreads.length + this.outputThreads.length));
        }
        this.shutdown(this.inputThreads);
        this.inputThreads = null;
        this.shutdown(this.outputThreads);
        this.outputThreads = null;
        this.closeListenerExecutor.shutdown();
        this.closeListenerExecutor = null;
    }

    private void shutdown(NioThread[] threads) {
        if (threads == null) {
            return;
        }
        for (NioThread thread : threads) {
            thread.shutdown();
        }
    }

    @Override
    public Channel register(ChannelInitializer channelInitializer, SocketChannel socketChannel, boolean clientMode) throws IOException {
        if (!this.started.get()) {
            throw new IllegalArgumentException("Can't register a channel when networking isn't started");
        }
        NioChannel channel = new NioChannel(socketChannel, clientMode, channelInitializer, this.closeListenerExecutor);
        socketChannel.configureBlocking(false);
        NioInboundPipeline inboundPipeline = this.newInboundPipeline(channel);
        NioOutboundPipeline outboundPipeline = this.newOutboundPipeline(channel);
        channel.init(inboundPipeline, outboundPipeline);
        this.ioBalancer.channelAdded(inboundPipeline, outboundPipeline);
        channel.addCloseListener(this.channelCloseListener);
        this.channels.add(channel);
        return channel;
    }

    private NioOutboundPipeline newOutboundPipeline(NioChannel channel) {
        int index = HashUtil.hashToIndex(this.nextOutputThreadIndex.getAndIncrement(), this.outputThreadCount);
        NioThread[] threads = this.outputThreads;
        if (threads == null) {
            throw new IllegalStateException("NioNetworking is shutdown!");
        }
        return new NioOutboundPipeline(channel, threads[index], this.errorHandler, this.loggingService.getLogger(NioOutboundPipeline.class), this.ioBalancer, this.concurrencyDetection, this.writeThroughEnabled, this.selectionKeyWakeupEnabled);
    }

    private NioInboundPipeline newInboundPipeline(NioChannel channel) {
        int index = HashUtil.hashToIndex(this.nextInputThreadIndex.getAndIncrement(), this.inputThreadCount);
        NioThread[] threads = this.inputThreads;
        if (threads == null) {
            throw new IllegalStateException("NioNetworking is shutdown!");
        }
        return new NioInboundPipeline(channel, threads[index], this.errorHandler, this.loggingService.getLogger(NioInboundPipeline.class), this.ioBalancer);
    }

    @Override
    public void provideDynamicMetrics(MetricDescriptor descriptor, MetricsCollectionContext context) {
        IOBalancer ioBalancer;
        NioThread[] nioThreadArray;
        for (Channel channel : this.channels) {
            String pipelineId = channel.localSocketAddress() + "->" + channel.remoteSocketAddress();
            MetricDescriptor descriptorIn = descriptor.copy().withPrefix("tcp.connection.in").withDiscriminator("pipelineId", pipelineId);
            context.collect(descriptorIn, channel.inboundPipeline());
            MetricDescriptor descriptorOut = descriptor.copy().withPrefix("tcp.connection.out").withDiscriminator("pipelineId", pipelineId);
            context.collect(descriptorOut, channel.outboundPipeline());
        }
        NioThread[] inputThreads = this.inputThreads;
        if (inputThreads != null) {
            for (NioThread nioThread : inputThreads) {
                MetricDescriptor descriptorInThread = descriptor.copy().withPrefix("tcp.inputThread").withDiscriminator("thread", nioThread.getName());
                context.collect(descriptorInThread, nioThread);
            }
        }
        if ((nioThreadArray = this.outputThreads) != null) {
            for (NioThread nioThread : nioThreadArray) {
                MetricDescriptor descriptorOutThread = descriptor.copy().withPrefix("tcp.outputThread").withDiscriminator("thread", nioThread.getName());
                context.collect(descriptorOutThread, nioThread);
            }
        }
        if ((ioBalancer = this.ioBalancer) != null) {
            MetricDescriptor descriptorBalancer = descriptor.copy().withPrefix("tcp.balancer");
            context.collect(descriptorBalancer, ioBalancer);
        }
        MetricDescriptor descriptorTcp = descriptor.copy().withPrefix("tcp");
        context.collect(descriptorTcp, this);
    }

    boolean isWriteThroughEnabled() {
        return this.writeThroughEnabled;
    }

    boolean isSelectionKeyWakeupEnabled() {
        return this.selectionKeyWakeupEnabled;
    }

    public static class Context {
        private BackoffIdleStrategy idleStrategy;
        private LoggingService loggingService;
        private MetricsRegistry metricsRegistry;
        private String threadNamePrefix = "hz";
        private ChannelErrorHandler errorHandler;
        private int inputThreadCount = 1;
        private int outputThreadCount = 1;
        private int balancerIntervalSeconds;
        private ThreadAffinity inputThreadAffinity = ThreadAffinity.DISABLED;
        private ThreadAffinity outputThreadAffinity = ThreadAffinity.DISABLED;
        private SelectorMode selectorMode = SelectorMode.getConfiguredValue();
        private boolean selectorWorkaroundTest = Boolean.getBoolean("hazelcast.io.selector.workaround.test");
        private boolean selectionKeyWakeupEnabled = Boolean.parseBoolean(System.getProperty("hazelcast.io.selectionKeyWakeupEnabled", "true"));
        private ConcurrencyDetection concurrencyDetection;
        private boolean writeThroughEnabled;

        public Context() {
            String selectorModeString = SelectorMode.getConfiguredString();
            if (selectorModeString.startsWith("selectnow,")) {
                this.idleStrategy = BackoffIdleStrategy.createBackoffIdleStrategy(selectorModeString);
            }
        }

        public Context selectionKeyWakeupEnabled(boolean selectionKeyWakeupEnabled) {
            this.selectionKeyWakeupEnabled = selectionKeyWakeupEnabled;
            return this;
        }

        public Context writeThroughEnabled(boolean writeThroughEnabled) {
            this.writeThroughEnabled = writeThroughEnabled;
            return this;
        }

        public Context concurrencyDetection(ConcurrencyDetection concurrencyDetection) {
            this.concurrencyDetection = concurrencyDetection;
            return this;
        }

        public Context selectorWorkaroundTest(boolean selectorWorkaroundTest) {
            this.selectorWorkaroundTest = selectorWorkaroundTest;
            return this;
        }

        public Context selectorMode(SelectorMode selectorMode) {
            this.selectorMode = selectorMode;
            return this;
        }

        public Context loggingService(LoggingService loggingService) {
            this.loggingService = loggingService;
            return this;
        }

        public Context metricsRegistry(MetricsRegistry metricsRegistry) {
            this.metricsRegistry = metricsRegistry;
            return this;
        }

        public Context threadNamePrefix(String threadNamePrefix) {
            this.threadNamePrefix = threadNamePrefix;
            return this;
        }

        public Context errorHandler(ChannelErrorHandler errorHandler) {
            this.errorHandler = errorHandler;
            return this;
        }

        public Context inputThreadCount(int inputThreadCount) {
            if (this.inputThreadAffinity.isEnabled()) {
                return this;
            }
            this.inputThreadCount = inputThreadCount;
            return this;
        }

        public Context outputThreadCount(int outputThreadCount) {
            if (this.outputThreadAffinity.isEnabled()) {
                return this;
            }
            this.outputThreadCount = outputThreadCount;
            return this;
        }

        public Context inputThreadAffinity(ThreadAffinity inputThreadAffinity) {
            this.inputThreadAffinity = inputThreadAffinity;
            if (inputThreadAffinity.isEnabled()) {
                this.inputThreadCount = inputThreadAffinity.getThreadCount();
            }
            return this;
        }

        public Context outputThreadAffinity(ThreadAffinity outputThreadAffinity) {
            this.outputThreadAffinity = outputThreadAffinity;
            if (outputThreadAffinity.isEnabled()) {
                this.outputThreadCount = outputThreadAffinity.getThreadCount();
            }
            return this;
        }

        public Context balancerIntervalSeconds(int balancerIntervalSeconds) {
            this.balancerIntervalSeconds = balancerIntervalSeconds;
            return this;
        }
    }

    private class PublishAllTask
    implements Runnable {
        private PublishAllTask() {
        }

        @Override
        public void run() {
            for (NioChannel channel : NioNetworking.this.channels) {
                NioOutboundPipeline outboundPipeline;
                NioThread outputThread;
                NioInboundPipeline inboundPipeline = channel.inboundPipeline;
                NioThread inputThread = inboundPipeline.owner();
                if (inputThread != null) {
                    inputThread.addTaskAndWakeup(inboundPipeline::publishMetrics);
                }
                if ((outputThread = (outboundPipeline = channel.outboundPipeline).owner()) == null) continue;
                outputThread.addTaskAndWakeup(outboundPipeline::publishMetrics);
            }
            NioNetworking.this.bytesSend = this.bytesTransceived(NioNetworking.this.outputThreads);
            NioNetworking.this.bytesReceived = this.bytesTransceived(NioNetworking.this.inputThreads);
            NioNetworking.this.packetsSend = this.packetsTransceived(NioNetworking.this.outputThreads);
            NioNetworking.this.packetsReceived = this.packetsTransceived(NioNetworking.this.inputThreads);
        }

        private long bytesTransceived(NioThread[] threads) {
            if (threads == null) {
                return 0L;
            }
            long result = 0L;
            for (NioThread nioThread : threads) {
                result += nioThread.bytesTransceived;
            }
            return result;
        }

        private long packetsTransceived(NioThread[] threads) {
            if (threads == null) {
                return 0L;
            }
            long result = 0L;
            for (NioThread nioThread : threads) {
                result += nioThread.framesTransceived + nioThread.priorityFramesTransceived;
            }
            return result;
        }
    }

    private class ChannelCloseListenerImpl
    implements ChannelCloseListener {
        private ChannelCloseListenerImpl() {
        }

        @Override
        public void onClose(Channel channel) {
            NioChannel nioChannel = (NioChannel)channel;
            NioNetworking.this.channels.remove(channel);
            NioNetworking.this.ioBalancer.channelRemoved(nioChannel.inboundPipeline(), nioChannel.outboundPipeline());
        }
    }
}

