/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.type.converter;

import com.hazelcast.sql.impl.type.QueryDataTypeFamily;
import com.hazelcast.sql.impl.type.converter.AbstractTemporalConverter;
import com.hazelcast.sql.impl.type.converter.Converter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;

public final class LocalDateConverter
extends AbstractTemporalConverter {
    public static final LocalDateConverter INSTANCE = new LocalDateConverter();

    private LocalDateConverter() {
        super(13, QueryDataTypeFamily.DATE);
    }

    @Override
    public Class<?> getValueClass() {
        return LocalDate.class;
    }

    @Override
    public String asVarchar(Object val) {
        return this.cast(val).toString();
    }

    @Override
    public LocalDate asDate(Object val) {
        return this.cast(val);
    }

    @Override
    public LocalDateTime asTimestamp(Object val) {
        LocalDate date = this.cast(val);
        return LocalDateConverter.dateToTimestamp(date);
    }

    @Override
    public OffsetDateTime asTimestampWithTimezone(Object val) {
        LocalDate date = this.cast(val);
        LocalDateTime timestamp = LocalDateConverter.dateToTimestamp(date);
        return LocalDateConverter.timestampToTimestampWithTimezone(timestamp);
    }

    @Override
    public Object convertToSelf(Converter valConverter, Object val) {
        return valConverter.asDate(val);
    }

    private LocalDate cast(Object val) {
        return (LocalDate)val;
    }
}

