/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.docgen;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.doctree.UnknownBlockTagTree;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import io.vertx.docgen.DocGenException;
import io.vertx.docgen.DocGenerator;
import io.vertx.docgen.DocWriter;
import io.vertx.docgen.Document;
import io.vertx.docgen.EntityUtils;
import io.vertx.docgen.Helper;
import io.vertx.docgen.JavaDocGenerator;
import io.vertx.docgen.LanguageFilterPostProcessor;
import io.vertx.docgen.PostProcessor;
import io.vertx.docgen.Syntax;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public abstract class BaseProcessor
extends AbstractProcessor {
    private static final String DOCGEN_OUTPUT = "docgen.output";
    private static final String DOCGEN_EXTENSION = "docgen.extension";
    private static final String DOCGEN_SOURCE = "docgen.source";
    private static final String DOCGEN_SYNTAX = "docgen.syntax";
    protected DocTrees docTrees;
    protected Helper helper;
    protected List<String> sources;
    protected Set<PostProcessor> postProcessors = new LinkedHashSet<PostProcessor>();
    protected Map<String, ElementResolution> resolutions = new HashMap<String, ElementResolution>();
    protected Syntax syntax;
    Map<String, String> failures = new HashMap<String, String>();
    private final Map<Doc, Map<DocGenerator, DocWriter>> state = new HashMap<Doc, Map<DocGenerator, DocWriter>>();
    private final LinkedList<PackageElement> stack = new LinkedList();
    private static final Pattern LINK_PATTERN = Pattern.compile("\\{@link\\s([^}]+)\\}");
    private static final Pattern METHOD_LINK_PATTERN = Pattern.compile("^([$_\\w]+\\.)*[$_\\w]+(?:#[$_\\w]+(?:(?:\\([^)]*)\\)|$|(?= )))?");

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(Arrays.asList(DOCGEN_OUTPUT, DOCGEN_EXTENSION, DOCGEN_SOURCE));
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton("*");
    }

    public synchronized BaseProcessor registerPostProcessor(PostProcessor postProcessor) {
        if (this.getPostProcessor(postProcessor.getName()) != null) {
            throw new IllegalArgumentException("Post-processor with name '" + postProcessor.getName() + "' is already registered.");
        }
        this.postProcessors.add(postProcessor);
        return this;
    }

    public synchronized PostProcessor getPostProcessor(String name) {
        for (PostProcessor pp : this.postProcessors) {
            if (!pp.getName().equalsIgnoreCase(name)) continue;
            return pp;
        }
        return null;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        String sourceOpt = processingEnv.getOptions().get(DOCGEN_SOURCE);
        if (sourceOpt != null) {
            this.sources = new ArrayList<String>(Arrays.asList(sourceOpt.split("\\s*,\\s*")));
        }
        this.docTrees = DocTrees.instance(processingEnv);
        this.helper = new Helper(processingEnv);
        String syntaxOpt = processingEnv.getOptions().get(DOCGEN_SYNTAX);
        this.syntax = "markdown".equals(syntaxOpt) ? Syntax.MARKDOWN : Syntax.ASCIIDOC;
        this.registerPostProcessor(new LanguageFilterPostProcessor());
    }

    private String render(List<? extends DocTree> trees) {
        final StringBuilder buffer = new StringBuilder();
        DocTreeScanner<Void, Void> visitor = new DocTreeScanner<Void, Void>(){

            @Override
            public Void visitText(TextTree node, Void aVoid) {
                buffer.append(node.getBody());
                return (Void)super.visitText(node, aVoid);
            }
        };
        trees.forEach(tree -> {
            Void cfr_ignored_0 = (Void)tree.accept(visitor, null);
        });
        return buffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        StackTraceElement[] trace = Thread.currentThread().getStackTrace();
        for (StackTraceElement elt2 : trace) {
            if (!elt2.getClassName().startsWith("org.jetbrains")) continue;
            return true;
        }
        if (!this.failures.isEmpty()) return false;
        try {
            if (!roundEnv.processingOver()) {
                Optional<ElementResolution> opt;
                roundEnv.getElementsAnnotatedWith(Document.class).forEach(elt -> {
                    try {
                        PackageDoc doc = new PackageDoc((PackageElement)elt);
                        this.state.put(doc, this.handleGen(doc));
                    }
                    catch (DocGenException e) {
                        if (e.element == null) {
                            e.element = elt;
                        }
                        throw e;
                    }
                });
                if (this.sources != null && this.sources.size() > 0) {
                    for (String source : this.sources) {
                        ArrayList<File> files = new ArrayList<File>();
                        File f = new File(source);
                        if (!f.exists()) {
                            if (!f.getName().contains("*")) throw new FileNotFoundException("Cannot process document " + source);
                            StringBuilder sb = new StringBuilder();
                            for (char c : f.getName().toCharArray()) {
                                if (c == '*') {
                                    sb.append(".*");
                                    continue;
                                }
                                sb.append(Matcher.quoteReplacement(Character.toString(c)));
                            }
                            Pattern p = Pattern.compile(sb.toString());
                            File parentFile = f.getParentFile();
                            File[] children = parentFile.listFiles();
                            if (children != null) {
                                for (File child : children) {
                                    if (!p.matcher(child.getName()).matches()) continue;
                                    files.add(child);
                                }
                            }
                        } else {
                            files.add(f);
                        }
                        for (File file : files) {
                            if (file.isFile()) {
                                FileDoc fileDoc = new FileDoc(file, file.getName());
                                Map<DocGenerator, DocWriter> m2 = this.handleGen(fileDoc);
                                this.state.put(fileDoc, m2);
                                continue;
                            }
                            if (!file.isDirectory()) throw new IOException("Document " + file.getAbsolutePath() + " is not a file nor a dir");
                            Files.walk(file.toPath(), new FileVisitOption[0]).map(Path::toFile).filter(File::isFile).forEach(docFile -> {
                                String relativePath = file.toPath().relativize(docFile.toPath()).toString();
                                FileDoc fileDoc = new FileDoc((File)docFile, relativePath);
                                Map<DocGenerator, DocWriter> m = this.handleGen(fileDoc);
                                this.state.put(fileDoc, m);
                            });
                        }
                    }
                    this.sources.clear();
                }
                HashSet<String> processed = new HashSet<String>();
                while ((opt = this.resolutions.values().stream().filter(res -> ((ElementResolution)res).elt == null && !processed.contains(res.signature)).findFirst()).isPresent()) {
                    ElementResolution res2 = opt.get();
                    processed.add(res2.signature);
                    res2.tryResolve();
                }
                return false;
            } else {
                this.state.forEach((doc, m) -> m.forEach((gen, w) -> {
                    String content = this.postProcess(gen.getName(), w.render());
                    this.write((DocGenerator)gen, (Doc)doc, content);
                }));
            }
            return false;
        }
        catch (Exception e) {
            Element reportedElt = e instanceof DocGenException ? ((DocGenException)e).element : null;
            String msg = e.getMessage();
            if (msg == null) {
                msg = e.toString();
            }
            e.printStackTrace();
            if (reportedElt != null) {
                this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, reportedElt);
                if (!(reportedElt instanceof PackageElement)) throw new UnsupportedOperationException("not implemented");
                this.failures.put(((PackageElement)reportedElt).getQualifiedName().toString(), msg);
                return false;
            }
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg);
        }
        return false;
    }

    protected abstract Iterable<DocGenerator> generators();

    private Map<DocGenerator, DocWriter> handleGen(Doc doc) {
        HashMap<DocGenerator, DocWriter> map = new HashMap<DocGenerator, DocWriter>();
        for (DocGenerator generator : this.generators()) {
            generator.init(this.processingEnv);
            DocWriter writer = new DocWriter();
            doc.process(generator, writer);
            map.put(generator, writer);
        }
        return map;
    }

    protected String getExtension() {
        String extension = this.processingEnv.getOptions().get(DOCGEN_EXTENSION);
        if (extension != null) {
            return extension;
        }
        return ".adoc";
    }

    protected String resolveLinkToPackageDoc(PackageElement elt) {
        Document annotation = elt.getAnnotation(Document.class);
        String fileName = annotation.fileName();
        if (fileName.isEmpty()) {
            return elt.toString() + this.getExtension();
        }
        return fileName;
    }

    private URL getURL(JavaFileObject fileObject) {
        try {
            return fileObject.toUri().toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    private String resolveLabel(DocGenerator generator, Element elt) {
        String label = elt.getSimpleName().toString();
        if (elt.getModifiers().contains((Object)Modifier.STATIC) && (elt.getKind() == ElementKind.METHOD || elt.getKind() == ElementKind.FIELD)) {
            label = elt.getEnclosingElement().getSimpleName() + "." + label;
        }
        if (elt.getKind() == ElementKind.ANNOTATION_TYPE) {
            label = "@" + label;
        }
        return generator.resolveLabel(elt, label);
    }

    private void visitLink(PackageElement pkgElt, String label, String signature, DocGenerator generator, DocWriter writer) {
        ElementResolution res = this.resolutions.get(signature);
        if (res == null) {
            res = new ElementResolution(signature);
            this.resolutions.put(signature, res);
        }
        LinkProcessing fut = new LinkProcessing(generator, label);
        res.add(fut);
        writer.write(() -> {
            DocWriter ww = fut.writer;
            if (ww == null) {
                throw new DocGenException(pkgElt, "Could not resolve " + signature);
            }
            return ww;
        });
    }

    protected String postProcess(String name, String content) {
        String processed = this.applyVariableSubstitution(content);
        processed = this.applyPostProcessors(name, processed);
        return processed;
    }

    protected void write(DocGenerator generator, Doc doc, String content) {
        String outputOpt = this.processingEnv.getOptions().get(DOCGEN_OUTPUT);
        if (outputOpt != null) {
            outputOpt = outputOpt.replace("$lang", generator.getName());
            String relativeName = doc.resolveRelativeFileName(generator);
            try {
                File dir = new File(outputOpt);
                int i = relativeName.indexOf(47);
                while (i != -1) {
                    dir = new File(dir, relativeName.substring(0, i));
                    relativeName = relativeName.substring(i + 1);
                    i = relativeName.indexOf(47, i + 1);
                }
                File file = new File(dir, relativeName);
                this.ensureDir(file.getParentFile());
                try (FileWriter writer = new FileWriter(file);){
                    writer.write(content);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String applyPostProcessors(String name2, String content) {
        List<String> lines = Arrays.asList(content.split("\r?\n"));
        StringBuilder processed = new StringBuilder();
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            String trimmedLine = line.trim();
            if (!PostProcessor.isBlockDeclaration(trimmedLine)) {
                processed.append(line);
                if (!iterator.hasNext()) continue;
                processed.append("\n");
                continue;
            }
            String name = PostProcessor.getProcessorName(trimmedLine);
            String[] attributes = PostProcessor.getProcessorAttributes(trimmedLine);
            PostProcessor postProcessor = this.getPostProcessor(name);
            if (postProcessor == null) {
                processed.append(line);
                if (!iterator.hasNext()) continue;
                processed.append("\n");
                continue;
            }
            String block = PostProcessor.getBlockContent(iterator);
            processed.append(postProcessor.process(name2, block, attributes));
            if (!iterator.hasNext()) continue;
            processed.append("\n");
        }
        return processed.toString();
    }

    private void ensureDir(File dir) {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new DocGenException("File " + dir.getAbsolutePath() + " is not a dir");
            }
        } else if (!dir.mkdirs()) {
            throw new DocGenException("could not create dir " + dir.getAbsolutePath());
        }
    }

    public String applyVariableSubstitution(String content) {
        for (Map.Entry<String, String> entry : this.processingEnv.getOptions().entrySet()) {
            content = content.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return content;
    }

    class LinkProcessing {
        final DocGenerator generator;
        final String label;
        private DocWriter writer;

        public LinkProcessing(DocGenerator generator, String label) {
            this.generator = generator;
            this.label = label;
        }

        void handle(Element elt) {
            this.writer = new DocWriter();
            if (elt instanceof PackageElement) {
                PackageElement includedElt = (PackageElement)elt;
                if (includedElt.getAnnotation(Document.class) == null) {
                    new PackageDoc(includedElt).process(this.generator, this.writer);
                } else {
                    String link = BaseProcessor.this.resolveLinkToPackageDoc((PackageElement)elt);
                    this.writer.append(link);
                }
            } else {
                String link;
                if (BaseProcessor.this.helper.isExample(elt)) {
                    String source = BaseProcessor.this.helper.readSource(elt);
                    switch (elt.getKind()) {
                        case CONSTRUCTOR: 
                        case METHOD: {
                            String fragment;
                            if (BaseProcessor.this.helper.hasToBeTranslated(elt)) {
                                fragment = this.generator.renderSource((ExecutableElement)elt, source);
                            } else {
                                JavaDocGenerator javaGen = new JavaDocGenerator();
                                javaGen.init(BaseProcessor.this.processingEnv);
                                fragment = javaGen.renderSource((ExecutableElement)elt, source);
                            }
                            if (fragment != null) {
                                this.writer.literalMode();
                                this.writer.append(fragment);
                                this.writer.commentMode();
                            }
                            return;
                        }
                        case CLASS: 
                        case INTERFACE: 
                        case ENUM: 
                        case ANNOTATION_TYPE: {
                            TypeElement typeElt = (TypeElement)elt;
                            JavaDocGenerator javaGen = new JavaDocGenerator();
                            javaGen.init(BaseProcessor.this.processingEnv);
                            String fragment = javaGen.renderSource(typeElt, source);
                            if (fragment != null) {
                                this.writer.literalMode();
                                this.writer.append(fragment);
                                this.writer.commentMode();
                            }
                            return;
                        }
                    }
                    throw new UnsupportedOperationException("unsupported element: " + (Object)((Object)elt.getKind()));
                }
                switch (elt.getKind()) {
                    case CLASS: 
                    case INTERFACE: 
                    case ENUM: 
                    case ANNOTATION_TYPE: {
                        TypeElement typeElt = (TypeElement)elt;
                        link = this.generator.resolveTypeLink(typeElt);
                        break;
                    }
                    case METHOD: {
                        ExecutableElement methodElt = (ExecutableElement)elt;
                        TypeElement typeElt = (TypeElement)methodElt.getEnclosingElement();
                        link = this.generator.resolveMethodLink(methodElt);
                        break;
                    }
                    case CONSTRUCTOR: {
                        ExecutableElement constructorElt = (ExecutableElement)elt;
                        TypeElement typeElt = (TypeElement)constructorElt.getEnclosingElement();
                        link = this.generator.resolveConstructorLink(constructorElt);
                        break;
                    }
                    case FIELD: 
                    case ENUM_CONSTANT: {
                        VariableElement variableElt = (VariableElement)elt;
                        TypeElement typeElt = (TypeElement)variableElt.getEnclosingElement();
                        link = this.generator.resolveFieldLink(variableElt);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Not yet implemented " + elt + " with kind " + (Object)((Object)elt.getKind()));
                    }
                }
                String s = this.label.length() == 0 ? BaseProcessor.this.resolveLabel(this.generator, elt) : this.label;
                if (link != null) {
                    BaseProcessor.this.syntax.writeLink(link, s, this.writer);
                } else {
                    this.writer.append("`").append(s).append("`");
                }
            }
        }
    }

    class ElementResolution {
        final String signature;
        private Element elt;
        private List<LinkProcessing> handlers = new ArrayList<LinkProcessing>();

        public ElementResolution(String signature) {
            this.signature = signature;
        }

        boolean tryResolve() {
            if (this.elt == null) {
                this.doResolve();
            }
            return this.elt != null;
        }

        public boolean equals(Object o) {
            if (o instanceof ElementResolution) {
                ElementResolution that = (ElementResolution)o;
                return this.signature.equals(that.signature);
            }
            return false;
        }

        public int hashCode() {
            return this.signature.hashCode();
        }

        private void doResolve() {
            this.elt = BaseProcessor.this.helper.resolveLink(this.signature);
            if (this.elt != null) {
                for (LinkProcessing fut : this.handlers) {
                    fut.handle(this.elt);
                }
                this.handlers.clear();
            }
        }

        private void add(LinkProcessing fut) {
            if (this.elt != null) {
                fut.handle(this.elt);
            } else {
                this.handlers.add(fut);
            }
        }
    }

    class FileDoc
    extends Doc {
        final File file;
        final String relativePath;

        FileDoc(File file, String relativePath) {
            this.file = file;
            this.relativePath = relativePath;
        }

        @Override
        public String id() {
            return this.relativePath;
        }

        @Override
        public String resolveRelativeFileName(DocGenerator generator) {
            return this.relativePath;
        }
    }

    class PackageDoc
    extends Doc {
        final PackageElement elt;

        PackageDoc(PackageElement elt) {
            this.elt = elt;
        }

        @Override
        public String id() {
            return this.elt.getQualifiedName().toString();
        }

        @Override
        public String resolveRelativeFileName(DocGenerator generator) {
            Document doc = this.elt.getAnnotation(Document.class);
            String relativeName = doc.fileName();
            if (relativeName.isEmpty()) {
                relativeName = this.elt.getQualifiedName() + BaseProcessor.this.getExtension();
            }
            return generator.resolveRelativeFileName(this.elt, relativeName);
        }
    }

    abstract class Doc {
        Doc() {
        }

        abstract String id();

        abstract String resolveRelativeFileName(DocGenerator var1);

        protected final void process(final DocGenerator generator, final DocWriter writer) {
            if (this instanceof PackageDoc) {
                final PackageElement pkgElt = ((PackageDoc)this).elt;
                for (PackageElement stackElt : BaseProcessor.this.stack) {
                    if (!pkgElt.getQualifiedName().equals(stackElt.getQualifiedName())) continue;
                    throw new DocGenException((Element)BaseProcessor.this.stack.peekLast(), "Circular include");
                }
                BaseProcessor.this.stack.addLast(pkgElt);
                final String pkgSource = BaseProcessor.this.helper.readSource(pkgElt);
                final TreePath pkgPath = BaseProcessor.this.docTrees.getPath(pkgElt);
                final DocCommentTree docTree = BaseProcessor.this.docTrees.getDocCommentTree(pkgPath);
                DocTreeScanner<Void, Void> visitor = new DocTreeScanner<Void, Void>(){

                    private void copyContent(DocTree node) {
                        int from = (int)BaseProcessor.this.docTrees.getSourcePositions().getStartPosition(pkgPath.getCompilationUnit(), docTree, node);
                        int to = (int)BaseProcessor.this.docTrees.getSourcePositions().getEndPosition(pkgPath.getCompilationUnit(), docTree, node);
                        writer.append(pkgSource, from, to);
                    }

                    @Override
                    public Void visitUnknownBlockTag(UnknownBlockTagTree node, Void v) {
                        writer.append("@").append(node.getTagName()).append(" ");
                        return (Void)super.visitUnknownBlockTag(node, v);
                    }

                    @Override
                    public Void visitDocComment(DocCommentTree node, Void v) {
                        List<? extends DocTree> blockTags;
                        v = (Void)this.scan(node.getFirstSentence(), v);
                        List<? extends DocTree> body = node.getBody();
                        if (body.size() > 0) {
                            writer.append("\n\n");
                            writer.resetParagraph();
                            v = (Void)this.scan(body, v);
                        }
                        if ((blockTags = node.getBlockTags()).size() > 0) {
                            writer.append("\n");
                            v = (Void)this.scan(blockTags, v);
                        }
                        return v;
                    }

                    @Override
                    public Void visitErroneous(ErroneousTree node, Void v) {
                        return this.visitText((TextTree)node, v);
                    }

                    @Override
                    public Void visitText(TextTree node, Void v) {
                        String body = node.getBody();
                        BaseProcessor.this.helper.filterLang(body, generator.getName(), writer);
                        return (Void)super.visitText(node, v);
                    }

                    @Override
                    public Void visitLiteral(LiteralTree node, Void aVoid) {
                        writer.append("`").append(node.getBody().getBody()).append("`");
                        return (Void)super.visitLiteral(node, aVoid);
                    }

                    @Override
                    public Void visitEntity(EntityTree node, Void aVoid) {
                        writer.append(EntityUtils.unescapeEntity(node.getName().toString()));
                        return (Void)super.visitEntity(node, aVoid);
                    }

                    @Override
                    public Void visitStartElement(StartElementTree node, Void v) {
                        this.copyContent(node);
                        return v;
                    }

                    @Override
                    public Void visitEndElement(EndElementTree node, Void v) {
                        writer.write("</");
                        writer.append(node.getName());
                        writer.append('>');
                        return v;
                    }

                    @Override
                    public Void visitLink(LinkTree node, Void v) {
                        String signature = node.getReference().getSignature();
                        String label = BaseProcessor.this.render(node.getLabel()).trim();
                        BaseProcessor.this.visitLink(pkgElt, label, signature, generator, writer);
                        return v;
                    }
                };
                docTree.accept(visitor, null);
                BaseProcessor.this.stack.removeLast();
            } else {
                FileDoc fileDoc = (FileDoc)this;
                try {
                    String content = new String(Files.readAllBytes(fileDoc.file.toPath()), StandardCharsets.UTF_8);
                    StringBuilder intermediate = new StringBuilder(content.length());
                    BaseProcessor.this.helper.filterLang(content, generator.getName(), intermediate);
                    content = intermediate.toString();
                    Matcher linkMatcher = LINK_PATTERN.matcher(content);
                    int prev = 0;
                    while (linkMatcher.find()) {
                        writer.write(content, prev, linkMatcher.start() - prev);
                        String value = linkMatcher.group(1).trim();
                        Matcher methodLinkMatcher = METHOD_LINK_PATTERN.matcher(value);
                        if (methodLinkMatcher.find()) {
                            String signature = value.substring(0, methodLinkMatcher.end());
                            String label = value.substring(methodLinkMatcher.end()).trim();
                            writer.exec(() -> BaseProcessor.this.visitLink(null, label, signature, generator, writer));
                        }
                        prev = linkMatcher.end();
                    }
                    writer.append(content, prev, content.length());
                }
                catch (IOException e) {
                    throw new DocGenException(e.getMessage());
                }
            }
        }
    }
}

