/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cp.internal.operation.unsafe;

import com.hazelcast.cp.internal.RaftService;
import com.hazelcast.cp.internal.RaftServiceDataSerializerHook;
import com.hazelcast.cp.internal.UnsafeModePartitionState;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.IdentifiedDataSerializable;
import com.hazelcast.spi.impl.operationservice.Operation;
import java.io.IOException;

public class UnsafeStateReplicationOp
extends Operation
implements IdentifiedDataSerializable {
    private UnsafeModePartitionState state;

    public UnsafeStateReplicationOp() {
    }

    public UnsafeStateReplicationOp(UnsafeModePartitionState state) {
        this.state = state;
    }

    @Override
    public void run() throws Exception {
        RaftService service = (RaftService)this.getService();
        service.applyUnsafeModeState(this.getPartitionId(), this.state);
    }

    @Override
    public String getServiceName() {
        return "hz:core:raft";
    }

    @Override
    public int getFactoryId() {
        return RaftServiceDataSerializerHook.F_ID;
    }

    @Override
    public int getClassId() {
        return 52;
    }

    @Override
    protected void writeInternal(ObjectDataOutput out) throws IOException {
        super.writeInternal(out);
        out.writeObject(this.state);
    }

    @Override
    protected void readInternal(ObjectDataInput in) throws IOException {
        super.readInternal(in);
        this.state = (UnsafeModePartitionState)in.readObject();
    }
}

