/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.plan;

import com.hazelcast.internal.util.collection.PartitionIdSet;
import com.hazelcast.sql.SqlRowMetadata;
import com.hazelcast.sql.impl.QueryParameterMetadata;
import com.hazelcast.sql.impl.plan.PlanFragmentMapping;
import com.hazelcast.sql.impl.plan.cache.CacheablePlan;
import com.hazelcast.sql.impl.plan.cache.PlanCacheKey;
import com.hazelcast.sql.impl.plan.cache.PlanCheckContext;
import com.hazelcast.sql.impl.plan.cache.PlanObjectKey;
import com.hazelcast.sql.impl.plan.node.PlanNode;
import com.hazelcast.sql.impl.security.SqlSecurityContext;
import java.security.Permission;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class Plan
implements CacheablePlan {
    private volatile long planLastUsed;
    private final PlanCacheKey planKey;
    private final Map<UUID, PartitionIdSet> partMap;
    private final List<PlanNode> fragments;
    private final List<PlanFragmentMapping> fragmentMappings;
    private final Map<Integer, Integer> outboundEdgeMap;
    private final Map<Integer, Integer> inboundEdgeMap;
    private final Map<Integer, Integer> inboundEdgeMemberCountMap;
    private final SqlRowMetadata rowMetadata;
    private final QueryParameterMetadata parameterMetadata;
    private final Set<PlanObjectKey> objectIds;
    private final List<Permission> permissions;

    public Plan(Map<UUID, PartitionIdSet> partMap, List<PlanNode> fragments, List<PlanFragmentMapping> fragmentMappings, Map<Integer, Integer> outboundEdgeMap, Map<Integer, Integer> inboundEdgeMap, Map<Integer, Integer> inboundEdgeMemberCountMap, SqlRowMetadata rowMetadata, QueryParameterMetadata parameterMetadata, PlanCacheKey planKey, Set<PlanObjectKey> objectIds, List<Permission> permissions) {
        this.partMap = partMap;
        this.fragments = fragments;
        this.fragmentMappings = fragmentMappings;
        this.outboundEdgeMap = outboundEdgeMap;
        this.inboundEdgeMap = inboundEdgeMap;
        this.inboundEdgeMemberCountMap = inboundEdgeMemberCountMap;
        this.rowMetadata = rowMetadata;
        this.parameterMetadata = parameterMetadata;
        this.planKey = planKey;
        this.objectIds = objectIds;
        this.permissions = permissions;
    }

    @Override
    public PlanCacheKey getPlanKey() {
        return this.planKey;
    }

    @Override
    public long getPlanLastUsed() {
        return this.planLastUsed;
    }

    @Override
    public void onPlanUsed() {
        this.planLastUsed = System.currentTimeMillis();
    }

    @Override
    public boolean isPlanValid(PlanCheckContext context) {
        return context.isValid(this.objectIds, this.partMap);
    }

    @Override
    public void checkPermissions(SqlSecurityContext context) {
        for (Permission permission : this.permissions) {
            context.checkPermission(permission);
        }
    }

    @Override
    public boolean producesRows() {
        return true;
    }

    public Map<UUID, PartitionIdSet> getPartitionMap() {
        return this.partMap;
    }

    public Collection<UUID> getMemberIds() {
        return this.partMap.keySet();
    }

    public int getFragmentCount() {
        return this.fragments.size();
    }

    public PlanNode getFragment(int index) {
        return this.fragments.get(index);
    }

    public List<PlanNode> getFragments() {
        return this.fragments;
    }

    public PlanFragmentMapping getFragmentMapping(int index) {
        return this.fragmentMappings.get(index);
    }

    public List<PlanFragmentMapping> getFragmentMappings() {
        return this.fragmentMappings;
    }

    public Map<Integer, Integer> getOutboundEdgeMap() {
        return this.outboundEdgeMap;
    }

    public Map<Integer, Integer> getInboundEdgeMap() {
        return this.inboundEdgeMap;
    }

    public Map<Integer, Integer> getInboundEdgeMemberCountMap() {
        return this.inboundEdgeMemberCountMap;
    }

    public SqlRowMetadata getRowMetadata() {
        return this.rowMetadata;
    }

    public QueryParameterMetadata getParameterMetadata() {
        return this.parameterMetadata;
    }

    public Set<PlanObjectKey> getObjectIds() {
        return this.objectIds;
    }

    public List<Permission> getPermissions() {
        return this.permissions;
    }
}

