/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.config.security;

import com.hazelcast.internal.util.StringUtil;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.function.Function;

public enum TokenEncoding {
    NONE("none", ba -> new String((byte[])ba, StandardCharsets.US_ASCII), s -> s.getBytes(StandardCharsets.US_ASCII)),
    BASE64("base64", ba -> Base64.getEncoder().encodeToString((byte[])ba), s -> Base64.getDecoder().decode((String)s));

    private static final TokenEncoding DEFAULT;
    private final String valueString;
    private final Function<byte[], String> encoder;
    private final Function<String, byte[]> decoder;

    private TokenEncoding(String valueString, Function<byte[], String> encoder, Function<String, byte[]> decoder) {
        this.valueString = valueString;
        this.encoder = encoder;
        this.decoder = decoder;
    }

    public String toString() {
        return this.valueString;
    }

    public String encode(byte[] token) {
        return token == null ? null : this.encoder.apply(token);
    }

    public byte[] decode(String str) {
        return str == null ? null : this.decoder.apply(str);
    }

    public static TokenEncoding getTokenEncoding(String label) {
        if ((label = StringUtil.trim(label)) == null) {
            return DEFAULT;
        }
        for (TokenEncoding item : TokenEncoding.values()) {
            if (!item.toString().equals(label)) continue;
            return item;
        }
        return DEFAULT;
    }

    public static TokenEncoding getEncodingForBytes(byte[] token) {
        return TokenEncoding.isAsciiOnly(token) ? NONE : BASE64;
    }

    private static boolean isAsciiOnly(byte[] token) {
        if (token == null) {
            return true;
        }
        for (byte b : token) {
            int num = b & 0xFF;
            if (num >= 32 && num < 127) continue;
            return false;
        }
        return true;
    }

    static {
        DEFAULT = NONE;
    }
}

