/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.sql.impl.schema.map;

import com.hazelcast.sql.impl.QueryException;
import com.hazelcast.sql.impl.extract.QueryTargetDescriptor;
import com.hazelcast.sql.impl.plan.cache.PartitionedMapPlanObjectKey;
import com.hazelcast.sql.impl.plan.cache.PlanObjectKey;
import com.hazelcast.sql.impl.schema.TableField;
import com.hazelcast.sql.impl.schema.TableStatistics;
import com.hazelcast.sql.impl.schema.map.AbstractMapTable;
import com.hazelcast.sql.impl.schema.map.MapTableIndex;
import java.util.Collections;
import java.util.List;

public class PartitionedMapTable
extends AbstractMapTable {
    private final List<MapTableIndex> indexes;
    private final boolean hd;

    public PartitionedMapTable(String schemaName, String tableName, String mapName, List<TableField> fields, TableStatistics statistics, QueryTargetDescriptor keyDescriptor, QueryTargetDescriptor valueDescriptor, Object keyJetMetadata, Object valueJetMetadata, List<MapTableIndex> indexes, boolean hd) {
        super(schemaName, tableName, mapName, fields, statistics, keyDescriptor, valueDescriptor, keyJetMetadata, valueJetMetadata);
        this.indexes = indexes;
        this.hd = hd;
    }

    public PartitionedMapTable(String name, QueryException exception) {
        super("partitioned", name, exception);
        this.indexes = null;
        this.hd = false;
    }

    @Override
    public PlanObjectKey getObjectKey() {
        if (!this.isValid()) {
            return null;
        }
        return new PartitionedMapPlanObjectKey(this.getSchemaName(), this.getMapName(), this.getFields(), this.getConflictingSchemas(), this.getKeyDescriptor(), this.getValueDescriptor(), this.getIndexes(), this.isHd());
    }

    public List<MapTableIndex> getIndexes() {
        this.checkException();
        return this.indexes != null ? this.indexes : Collections.emptyList();
    }

    public boolean isHd() {
        return this.hd;
    }
}

