/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sync.benchmark;

import co.paralleluniverse.fibers.Suspendable;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.sync.benchmark.Benchmarker;
import io.vertx.ext.sync.benchmark.SomeAsyncInterface;
import io.vertx.ext.sync.benchmark.SomeAsyncInterfaceImpl;

public class AsyncBenchmarkVerticle
extends AbstractVerticle {
    private Benchmarker benchmarker = new Benchmarker(100000L);
    private SomeAsyncInterface ai;

    public static void main(String[] args) {
        Vertx.vertx().deployVerticle(AsyncBenchmarkVerticle.class.getName());
    }

    @Suspendable
    public void start() {
        this.ai = new SomeAsyncInterfaceImpl(this.vertx);
        this.benchmarkMethod();
    }

    @Suspendable
    protected void benchmarkMethod() {
        this.ai.asyncMethod("foo", (Handler<AsyncResult<String>>)((Handler)res -> {
            if (res.succeeded()) {
                String result = (String)res.result();
                this.benchmarker.iterDone(result.hashCode());
                this.vertx.runOnContext(v -> this.benchmarkMethod());
            } else {
                res.cause().printStackTrace();
            }
        }));
    }
}

