/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sync.benchmark;

import co.paralleluniverse.fibers.Suspendable;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.ext.sync.Sync;
import io.vertx.ext.sync.SyncVerticle;
import io.vertx.ext.sync.benchmark.Benchmarker;
import io.vertx.ext.sync.benchmark.SomeAsyncInterface;
import io.vertx.ext.sync.benchmark.SomeAsyncInterfaceImpl;
import io.vertx.ext.sync.impl.AsyncAdaptor;

public class SyncBenchmarkVerticle
extends SyncVerticle {
    private Benchmarker benchmarker = new Benchmarker(100000L);
    private SomeAsyncInterface ai;

    public static void main(String[] args) {
        Vertx.vertx().deployVerticle(SyncBenchmarkVerticle.class.getName());
    }

    @Suspendable
    public void start() {
        this.ai = new SomeAsyncInterfaceImpl(this.vertx);
        this.benchmarkMethod();
    }

    @Suspendable
    protected void benchmarkMethod() {
        try {
            AsyncAdaptor<String> aa = new AsyncAdaptor<String>(){

                protected void requestAsync() {
                    SyncBenchmarkVerticle.this.ai.asyncMethod("foo", (Handler<AsyncResult<String>>)this);
                }
            };
            String result = (String)aa.run();
            this.benchmarker.iterDone(result.hashCode());
            this.vertx.runOnContext(Sync.fiberHandler(v -> this.benchmarkMethod()));
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

