/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sync.test;

import io.vertx.core.DeploymentOptions;
import io.vertx.core.Verticle;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.sync.test.TestVerticle;
import io.vertx.test.core.VertxTestBase;
import org.junit.Test;

public class SyncTest
extends VertxTestBase {
    protected void runTest(String testName) throws Exception {
        this.vertx.deployVerticle((Verticle)new TestVerticle(), new DeploymentOptions().setConfig(new JsonObject().put("testName", (Object)testName)), res -> {
            if (res.succeeded()) {
                this.vertx.undeploy((String)res.result(), res2 -> {
                    if (res2.succeeded()) {
                        this.testComplete();
                    } else {
                        res2.cause().printStackTrace();
                        this.fail("Failure in undeploying");
                    }
                });
            } else {
                res.cause().printStackTrace();
                this.fail("Failure in running tests");
            }
        });
        this.await();
    }

    protected String getMethodName() {
        return Thread.currentThread().getStackTrace()[2].getMethodName();
    }

    @Test
    public void testFiberHandler() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testExecSyncMethodWithParamsAndHandlerNoReturn() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testExecSyncMethodWithNoParamsAndHandlerNoReturn() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testExecSyncMethodWithParamsAndHandlerWithReturn() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testExecSyncMethodWithNoParamsAndHandlerWithReturn() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testExecSyncMethodWithParamsAndHandlerInterface() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testExecSyncMethodWithNoParamsAndHandlerWithReturnNoTimeout() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testExecSyncMethodWithNoParamsAndHandlerWithReturnTimedout() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testExecSyncMethodThatFails() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testReceiveEvent() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testReceiveEventTimedout() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testReceiveEventNoTimeout() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testHandlerAdaptor() throws Exception {
        this.runTest(this.getMethodName());
    }

    @Test
    public void testSleep() throws Exception {
        this.runTest(this.getMethodName());
    }
}

