/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.sync.test;

import co.paralleluniverse.fibers.SuspendExecution;
import co.paralleluniverse.fibers.Suspendable;
import co.paralleluniverse.strands.Strand;
import co.paralleluniverse.strands.channels.Channel;
import co.paralleluniverse.strands.channels.Channels;
import co.paralleluniverse.strands.channels.ReceivePort;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxException;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.sync.HandlerReceiverAdaptor;
import io.vertx.ext.sync.Sync;
import io.vertx.ext.sync.SyncVerticle;
import io.vertx.ext.sync.testmodel.AsyncInterface;
import io.vertx.ext.sync.testmodel.AsyncInterfaceImpl;
import io.vertx.ext.sync.testmodel.ReturnedInterface;
import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.hamcrest.Matcher;
import org.hamcrest.core.Is;
import org.junit.Assert;

public class TestVerticle
extends SyncVerticle {
    private static final String ADDRESS1 = "address1";
    private static final String ADDRESS2 = "address2";
    private static final String ADDRESS3 = "address3";
    private AsyncInterface ai;
    private Channel<Object> completeChannel;

    @Suspendable
    public void start() throws Exception {
        this.ai = new AsyncInterfaceImpl(this.vertx);
        this.completeChannel = Channels.newChannel((int)1, (Channels.OverflowPolicy)Channels.OverflowPolicy.THROW);
        try {
            String testName = this.config().getString("testName");
            Method meth = ((Object)((Object)this)).getClass().getDeclaredMethod(testName, new Class[0]);
            meth.setAccessible(true);
            meth.invoke((Object)this, new Object[0]);
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
            throw new IllegalStateException("Tests failed", (Throwable)((Object)e));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IllegalStateException("Failed to invoke test", e);
        }
        this.completeChannel.receive(10L, TimeUnit.SECONDS);
    }

    @Suspendable
    protected void complete() {
        try {
            this.completeChannel.send(new Object());
        }
        catch (Exception e) {
            throw new VertxException((Throwable)e);
        }
    }

    @Suspendable
    protected void testContext() {
        Context ctx = Vertx.currentContext();
        Assert.assertTrue((boolean)ctx.isEventLoopContext());
        this.complete();
    }

    @Suspendable
    protected void testSleep() throws Exception {
        Thread th = Thread.currentThread();
        AtomicInteger cnt = new AtomicInteger();
        this.vertx.setPeriodic(1L, tid -> {
            Assert.assertSame((Object)Thread.currentThread(), (Object)th);
            cnt.incrementAndGet();
        });
        Assert.assertSame((Object)Thread.currentThread(), (Object)th);
        Strand.sleep((long)1000L, (TimeUnit)TimeUnit.MILLISECONDS);
        Assert.assertSame((Object)Thread.currentThread(), (Object)th);
        Assert.assertTrue((cnt.get() > 900 ? 1 : 0) != 0);
        this.complete();
    }

    @Suspendable
    protected void testFiberHandler() {
        HttpServer server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080));
        server.requestHandler(Sync.fiberHandler(req -> {
            String res = (String)Sync.awaitResult(h -> this.ai.methodWithParamsAndHandlerNoReturn("oranges", 23L, (Handler<AsyncResult<String>>)h));
            Assert.assertEquals((Object)"oranges23", (Object)res);
            req.response().end();
        }));
        server.listen(res -> {
            Assert.assertTrue((boolean)res.succeeded());
            HttpClient client = this.vertx.createHttpClient(new HttpClientOptions().setDefaultPort(8080));
            client.get("/somepath", ar -> {
                Assert.assertTrue((boolean)ar.succeeded());
                if (ar.succeeded()) {
                    HttpClientResponse resp = (HttpClientResponse)ar.result();
                    Assert.assertEquals((long)200L, (long)resp.statusCode());
                    client.close();
                    server.close(res2 -> this.complete());
                }
            });
        });
    }

    @Suspendable
    protected void testExecSyncMethodWithParamsAndHandlerNoReturn() {
        Thread th = Thread.currentThread();
        String res = (String)Sync.awaitResult(h -> this.ai.methodWithParamsAndHandlerNoReturn("oranges", 23L, (Handler<AsyncResult<String>>)h));
        Assert.assertEquals((Object)"oranges23", (Object)res);
        Assert.assertSame((Object)Thread.currentThread(), (Object)th);
        this.complete();
    }

    @Suspendable
    protected void testExecSyncMethodWithNoParamsAndHandlerNoReturn() {
        String res = (String)Sync.awaitResult(h -> this.ai.methodWithNoParamsAndHandlerNoReturn((Handler<AsyncResult<String>>)h));
        Assert.assertEquals((Object)"wibble", (Object)res);
        this.complete();
    }

    @Suspendable
    protected void testExecSyncMethodWithParamsAndHandlerWithReturn() {
        String res = (String)Sync.awaitResult(h -> this.ai.methodWithParamsAndHandlerWithReturn("oranges", 23L, (Handler<AsyncResult<String>>)h));
        Assert.assertEquals((Object)"oranges23", (Object)res);
        this.complete();
    }

    @Suspendable
    protected void testExecSyncMethodWithNoParamsAndHandlerWithReturn() {
        String res = (String)Sync.awaitResult(h -> this.ai.methodWithNoParamsAndHandlerWithReturn((Handler<AsyncResult<String>>)h));
        Assert.assertEquals((Object)"wibble", (Object)res);
        this.complete();
    }

    @Suspendable
    private void sleep(long millis) {
        try {
            Strand.sleep((long)millis);
        }
        catch (SuspendExecution | InterruptedException suspendExecution) {
            throw new AssertionError();
        }
    }

    @Suspendable
    protected void testExecSyncMethodWithNoParamsAndHandlerWithReturnNoTimeout() {
        long start = System.currentTimeMillis();
        String res = (String)Sync.awaitResult(h -> {
            this.sleep(500L);
            this.ai.methodWithNoParamsAndHandlerWithReturn((Handler<AsyncResult<String>>)h);
        }, (long)2000L);
        long duration = System.currentTimeMillis() - start;
        Assert.assertEquals((Object)"wibble", (Object)res);
        Assert.assertTrue((duration > 500L && duration < 1000L ? 1 : 0) != 0);
        this.complete();
    }

    @Suspendable
    protected void testExecSyncMethodWithNoParamsAndHandlerWithReturnTimedout() {
        String res = (String)Sync.awaitResult(h -> {
            this.sleep(1000L);
            this.ai.methodWithNoParamsAndHandlerWithReturn((Handler<AsyncResult<String>>)h);
        }, (long)500L);
        Assert.assertNull((Object)res);
        this.complete();
    }

    @Suspendable
    protected void testExecSyncMethodWithParamsAndHandlerInterface() {
        ReturnedInterface returned = (ReturnedInterface)Sync.awaitResult(h -> this.ai.methodWithParamsAndHandlerInterface("apples", 123L, (Handler<AsyncResult<ReturnedInterface>>)h));
        Assert.assertNotNull((Object)returned);
        String res = (String)Sync.awaitResult(h -> returned.methodWithParamsAndHandlerNoReturn("bananas", 100L, (Handler<AsyncResult<String>>)h));
        Assert.assertEquals((Object)res, (Object)"bananas100");
        this.complete();
    }

    @Suspendable
    protected void testExecSyncMethodThatFails() {
        try {
            String res = (String)Sync.awaitResult(h -> this.ai.methodThatFails("oranges", (Handler<AsyncResult<String>>)h));
            Assert.fail((String)"Should throw exception");
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)(e instanceof VertxException));
            VertxException ve = (VertxException)e;
            Assert.assertEquals((Object)"oranges", (Object)ve.getCause().getMessage());
            this.complete();
        }
    }

    @Suspendable
    protected void testReceiveEvent() {
        long start = System.currentTimeMillis();
        long tid = (Long)Sync.awaitEvent(h -> this.vertx.setTimer(500L, h));
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start >= 500L ? 1 : 0) != 0);
        Assert.assertTrue((tid >= 0L ? 1 : 0) != 0);
        this.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Suspendable
    protected void testReceiveEventTimedout() {
        long start = System.currentTimeMillis();
        try {
            long l = (Long)Sync.awaitEvent(h -> this.vertx.setTimer(500L, h), (long)250L);
        }
        catch (NullPointerException npe) {
            Assert.assertThat((Object)npe, (Matcher)Is.isA(NullPointerException.class));
        }
        catch (Exception e) {
            Assert.assertTrue((boolean)false);
        }
        finally {
            this.complete();
        }
    }

    @Suspendable
    protected void testReceiveEventNoTimeout() {
        long start = System.currentTimeMillis();
        long tid = (Long)Sync.awaitEvent(h -> this.vertx.setTimer(500L, h), (long)1000L);
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start >= 500L ? 1 : 0) != 0);
        Assert.assertTrue((tid >= 0L ? 1 : 0) != 0);
        this.complete();
    }

    @Suspendable
    protected void testHandlerAdaptor() throws Exception {
        EventBus eb = this.vertx.eventBus();
        HandlerReceiverAdaptor adaptor1 = Sync.streamAdaptor();
        eb.consumer(ADDRESS1).handler((Handler)adaptor1);
        HandlerReceiverAdaptor adaptor2 = Sync.streamAdaptor();
        eb.consumer(ADDRESS2).handler((Handler)adaptor2);
        long start = System.currentTimeMillis();
        this.vertx.setPeriodic(10L, tid -> {
            eb.send(ADDRESS1, (Object)"wibble");
            eb.send(ADDRESS2, (Object)"flibble");
        });
        for (int i = 0; i < 10; ++i) {
            Message received1 = (Message)adaptor1.receive();
            Assert.assertEquals((Object)"wibble", (Object)received1.body());
            Message received2 = (Message)adaptor2.receive();
            Assert.assertEquals((Object)"flibble", (Object)received2.body());
        }
        long end = System.currentTimeMillis();
        Assert.assertTrue((end - start >= 100L ? 1 : 0) != 0);
        Message received1 = (Message)adaptor1.receive(1000L);
        Assert.assertEquals((Object)"wibble", (Object)received1.body());
        HandlerReceiverAdaptor adaptor3 = Sync.streamAdaptor();
        eb.consumer(ADDRESS3).handler((Handler)adaptor3);
        Message received3 = (Message)adaptor3.receive(100L);
        Assert.assertNull((Object)received3);
        ReceivePort channel = adaptor1.receivePort();
        Assert.assertNotNull((Object)channel);
        received1 = (Message)channel.receive();
        Assert.assertEquals((Object)"wibble", (Object)received1.body());
        this.complete();
    }

    @Suspendable
    public void stop() {
        try {
            this.testContext();
        }
        catch (AssertionError e) {
            ((Throwable)((Object)e)).printStackTrace();
            Assert.fail((String)"tests failed");
        }
    }
}

