/*
 * Copyright 2014 Red Hat, Inc.
 *
 * Red Hat licenses this file to you under the Apache License, version 2.0
 * (the "License"); you may not use this file except in compliance with the
 * License.  You may obtain a copy of the License at:
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.  See the
 * License for the specific language governing permissions and limitations
 * under the License.
 */

package io.vertx.reactivex.ext.web.templ;

import java.util.Map;
import io.reactivex.Observable;
import io.reactivex.Flowable;
import io.reactivex.Single;
import io.reactivex.Completable;
import io.reactivex.Maybe;
import io.vertx.reactivex.core.buffer.Buffer;
import io.vertx.reactivex.core.Vertx;
import io.vertx.reactivex.ext.web.RoutingContext;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;

/**
 * A template engine that uses the Pebble library.
 *
 * <p/>
 * NOTE: This class has been automatically generated from the {@link io.vertx.ext.web.templ.PebbleTemplateEngine original} non RX-ified interface using Vert.x codegen.
 */

@io.vertx.lang.reactivex.RxGen(io.vertx.ext.web.templ.PebbleTemplateEngine.class)
public class PebbleTemplateEngine extends TemplateEngine {

  @Override
  public String toString() {
    return delegate.toString();
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    PebbleTemplateEngine that = (PebbleTemplateEngine) o;
    return delegate.equals(that.delegate);
  }
  
  @Override
  public int hashCode() {
    return delegate.hashCode();
  }

  public static final io.vertx.lang.reactivex.TypeArg<PebbleTemplateEngine> __TYPE_ARG = new io.vertx.lang.reactivex.TypeArg<>(
    obj -> new PebbleTemplateEngine((io.vertx.ext.web.templ.PebbleTemplateEngine) obj),
    PebbleTemplateEngine::getDelegate
  );

  private final io.vertx.ext.web.templ.PebbleTemplateEngine delegate;
  
  public PebbleTemplateEngine(io.vertx.ext.web.templ.PebbleTemplateEngine delegate) {
    super(delegate);
    this.delegate = delegate;
  }

  public io.vertx.ext.web.templ.PebbleTemplateEngine getDelegate() {
    return delegate;
  }

  /**
   * Create a template engine using defaults
   * @param vertx 
   * @return the engine
   */
  public static PebbleTemplateEngine create(Vertx vertx) { 
    PebbleTemplateEngine ret = PebbleTemplateEngine.newInstance(io.vertx.ext.web.templ.PebbleTemplateEngine.create(vertx.getDelegate()));
    return ret;
  }

  /**
   * Set the extension for the engine
   * @param extension the extension
   * @return a reference to this for fluency
   */
  public PebbleTemplateEngine setExtension(String extension) { 
    delegate.setExtension(extension);
    return this;
  }

  /**
   * Set the max cache size for the engine
   * @param maxCacheSize the maxCacheSize
   * @return a reference to this for fluency
   */
  public PebbleTemplateEngine setMaxCacheSize(int maxCacheSize) { 
    delegate.setMaxCacheSize(maxCacheSize);
    return this;
  }


  public static  PebbleTemplateEngine newInstance(io.vertx.ext.web.templ.PebbleTemplateEngine arg) {
    return arg != null ? new PebbleTemplateEngine(arg) : null;
  }
}
