/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.rxjava.ext.web.sstore;

import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.lang.rxjava.InternalHelper;
import io.vertx.rx.java.ObservableFuture;
import io.vertx.rx.java.RxHelper;
import io.vertx.rxjava.ext.web.Session;
import rx.Observable;

public class SessionStore {
    final io.vertx.ext.web.sstore.SessionStore delegate;

    public SessionStore(io.vertx.ext.web.sstore.SessionStore delegate) {
        this.delegate = delegate;
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public Session createSession(long timeout) {
        Session ret = Session.newInstance(this.delegate.createSession(timeout));
        return ret;
    }

    public void get(String id, final Handler<AsyncResult<Session>> resultHandler) {
        this.delegate.get(id, new Handler<AsyncResult<io.vertx.ext.web.Session>>(){

            public void handle(AsyncResult<io.vertx.ext.web.Session> event) {
                AsyncResult f = event.succeeded() ? InternalHelper.result((Object)new Session((io.vertx.ext.web.Session)event.result())) : InternalHelper.failure((Throwable)event.cause());
                resultHandler.handle((Object)f);
            }
        });
    }

    public Observable<Session> getObservable(String id) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.get(id, (Handler<AsyncResult<Session>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void delete(String id, Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.delete(id, resultHandler);
    }

    public Observable<Boolean> deleteObservable(String id) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.delete(id, (Handler<AsyncResult<Boolean>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void put(Session session, Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.put((io.vertx.ext.web.Session)session.getDelegate(), resultHandler);
    }

    public Observable<Boolean> putObservable(Session session) {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.put(session, (Handler<AsyncResult<Boolean>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void clear(Handler<AsyncResult<Boolean>> resultHandler) {
        this.delegate.clear(resultHandler);
    }

    public Observable<Boolean> clearObservable() {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.clear((Handler<AsyncResult<Boolean>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void size(Handler<AsyncResult<Integer>> resultHandler) {
        this.delegate.size(resultHandler);
    }

    public Observable<Integer> sizeObservable() {
        ObservableFuture resultHandler = RxHelper.observableFuture();
        this.size((Handler<AsyncResult<Integer>>)resultHandler.toHandler());
        return resultHandler;
    }

    public void close() {
        this.delegate.close();
    }

    public static SessionStore newInstance(io.vertx.ext.web.sstore.SessionStore arg) {
        return arg != null ? new SessionStore(arg) : null;
    }
}

