/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.FaviconHandler;
import io.vertx.ext.web.impl.Utils;
import org.junit.Test;

public class FaviconHandlerTest
extends WebTestBase {
    @Test
    public void testFaviconClasspath() throws Exception {
        this.testFaviconPath(FaviconHandler.create(), 86400L);
    }

    @Test
    public void testFaviconPath() throws Exception {
        String path = "src/test/resources/favicon.ico";
        this.testFaviconPath(FaviconHandler.create((String)path), 86400L);
    }

    @Test
    public void testFaviconPathMaxAge() throws Exception {
        String path = "src/test/resources/favicon.ico";
        long maxAge = 172800L;
        this.testFaviconPath(FaviconHandler.create((String)path, (long)maxAge), maxAge);
    }

    @Test
    public void testFaviconMaxAge() throws Exception {
        long maxAge = 172800L;
        this.testFaviconPath(FaviconHandler.create((long)maxAge), maxAge);
    }

    private void testFaviconPath(FaviconHandler favicon, long maxAgeSeconds) throws Exception {
        this.router.route().handler((Handler)favicon);
        this.router.route().handler(rc -> rc.response().end());
        Buffer icon = Utils.readResourceToBuffer((String)"favicon.ico");
        this.testRequestBuffer(HttpMethod.GET, "/favicon.ico", null, resp -> {
            this.assertEquals("image/x-icon", resp.headers().get("content-type"));
            this.assertEquals(icon.length(), Integer.valueOf(resp.headers().get("content-length")).intValue());
            this.assertEquals("public, max-age=" + maxAgeSeconds, resp.headers().get("cache-control"));
        }, 200, "OK", icon);
    }
}

