/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.ResponseTimeHandler;
import org.junit.Test;

public class ResponseTimeTest
extends WebTestBase {
    @Test
    public void testRequestTime1() throws Exception {
        this.router.route().handler((Handler)ResponseTimeHandler.create());
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String reqTime = resp.headers().get("x-response-time");
            this.assertNotNull(reqTime);
            this.assertTrue(reqTime.endsWith("ms"));
        }, 200, "OK", null);
    }

    @Test
    public void testRequestTime2() throws Exception {
        this.router.route().handler((Handler)ResponseTimeHandler.create());
        this.router.route().handler(rc -> this.vertx.setTimer(250L, tid -> rc.response().end()));
        this.testRequest(HttpMethod.GET, "/", null, resp -> {
            String reqTime = resp.headers().get("x-response-time");
            this.assertNotNull(reqTime);
            this.assertTrue(reqTime.endsWith("ms"));
            String time = reqTime.substring(0, reqTime.length() - 2);
            Integer dur = Integer.valueOf(time);
            this.assertTrue(dur >= 250);
        }, 200, "OK", null);
    }
}

