/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.CaseInsensitiveHeaders;
import io.vertx.core.http.WebSocketFrame;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.test.core.TestUtils;
import org.junit.Test;

public class SockJSHandlerTest
extends WebTestBase {
    private static final Logger log = LoggerFactory.getLogger(SockJSHandlerTest.class);

    @Override
    public void setUp() throws Exception {
        super.setUp();
        SockJSHandler.installTestApplications((Router)this.router, (Vertx)this.vertx);
    }

    @Test
    public void testGreeting() {
        this.waitFor(2);
        this.testGreeting("/echo/");
        this.testGreeting("/echo");
        this.await();
    }

    private void testGreeting(String uri) {
        this.client.getNow(uri, resp -> {
            this.assertEquals(200L, resp.statusCode());
            this.assertEquals("text/plain; charset=UTF-8", resp.getHeader("content-type"));
            resp.bodyHandler(buff -> {
                this.assertEquals("Welcome to SockJS!\n", buff.toString());
                this.complete();
            });
        });
    }

    @Test
    public void testNotFound() {
        this.waitFor(5);
        this.testNotFound("/echo/a");
        this.testNotFound("/echo/a.html");
        this.testNotFound("/echo/a/a");
        this.testNotFound("/echo/a/a/");
        this.testNotFound("/echo/a/");
        this.testNotFound("/echo//");
        this.testNotFound("/echo///");
        this.await();
    }

    @Test
    public void testSendWebsocketContinuationFrames() {
        this.client.websocket("/echo/websocket", ws -> {
            int size = 65535;
            Buffer buffer1 = TestUtils.randomBuffer((int)size);
            Buffer buffer2 = TestUtils.randomBuffer((int)size);
            ws.writeFrame(WebSocketFrame.binaryFrame((Buffer)buffer1, (boolean)false));
            ws.writeFrame(WebSocketFrame.continuationFrame((Buffer)buffer2, (boolean)true));
            Buffer received = Buffer.buffer();
            ws.handler(buff -> {
                received.appendBuffer(buff);
                if (received.length() == size * 2) {
                    this.testComplete();
                }
            });
        });
        this.await();
    }

    private void testNotFound(String uri) {
        this.client.getNow(uri, resp -> {
            this.assertEquals(404L, resp.statusCode());
            this.complete();
        });
    }

    @Test
    public void testCookiesRemoved() throws Exception {
        this.router.route("/cookiesremoved/*").handler((Handler)SockJSHandler.create((Vertx)this.vertx).socketHandler(sock -> {
            MultiMap headers = sock.headers();
            String cookieHeader = headers.get("cookie");
            this.assertNotNull(cookieHeader);
            this.assertEquals("JSESSIONID=wibble", cookieHeader);
            this.testComplete();
        }));
        CaseInsensitiveHeaders headers = new CaseInsensitiveHeaders();
        headers.add("cookie", "JSESSIONID=wibble");
        headers.add("cookie", "flibble=floob");
        this.client.websocket("/cookiesremoved/websocket", (MultiMap)headers, ws -> {
            String frame = "foo";
            ws.writeFrame(WebSocketFrame.textFrame((String)frame, (boolean)true));
        });
        this.await();
    }
}

