/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.handler.CookieHandler;
import io.vertx.ext.web.handler.SessionHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandler;
import io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import io.vertx.ext.web.handler.sockjs.SockJSSocket;
import io.vertx.ext.web.sstore.LocalSessionStore;
import io.vertx.ext.web.sstore.SessionStore;
import io.vertx.test.core.TestUtils;
import io.vertx.test.core.VertxTestBase;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;
import org.junit.Test;

public class SockJSSessionTest
extends VertxTestBase {
    private HttpClient client;
    private HttpServer server;
    private Router router;
    private SockJSHandler sockJSHandler;

    public void setUp() throws Exception {
        super.setUp();
        this.client = this.vertx.createHttpClient(new HttpClientOptions().setDefaultPort(8080));
        this.router = Router.router((Vertx)this.vertx);
        this.router.route().handler((Handler)CookieHandler.create());
        this.router.route().handler((Handler)SessionHandler.create((SessionStore)LocalSessionStore.create((Vertx)this.vertx)).setNagHttps(false).setSessionTimeout(3600000L));
        SockJSHandlerOptions options = new SockJSHandlerOptions().setHeartbeatInterval(2000L);
        this.sockJSHandler = SockJSHandler.create((Vertx)this.vertx, (SockJSHandlerOptions)options);
        this.router.route("/test/*").handler((Handler)this.sockJSHandler);
        this.server = this.vertx.createHttpServer(new HttpServerOptions().setPort(8080).setHost("localhost"));
        CountDownLatch latch = new CountDownLatch(1);
        this.server.requestHandler(arg_0 -> ((Router)this.router).accept(arg_0)).listen(ar -> latch.countDown());
        this.awaitLatch(latch);
    }

    @Test
    public void testNoDeadlockWhenWritingFromAnotherThreadWithSseTransport() {
        this.sockJSHandler.socketHandler(socket -> {
            final AtomicBoolean closed = new AtomicBoolean();
            socket.endHandler(v -> {
                closed.set(true);
                this.testComplete();
            });
            new Thread((SockJSSocket)socket){
                final /* synthetic */ SockJSSocket val$socket;
                {
                    this.val$socket = sockJSSocket;
                }

                @Override
                public void run() {
                    while (!closed.get()) {
                        LockSupport.parkNanos(50L);
                        this.val$socket.write(Buffer.buffer((String)TestUtils.randomAlphaString((int)256)));
                    }
                }
            }.start();
        });
        this.client.get("/test/400/8ne8e94a/eventsource", resp -> {
            AtomicInteger count = new AtomicInteger();
            resp.handler(msg -> {
                if (count.incrementAndGet() == 400) {
                    resp.request().connection().close();
                }
            });
        }).end();
        this.await();
    }

    @Test
    public void testNoDeadlockWhenWritingFromAnotherThreadWithWebsocketTransport() {
        this.sockJSHandler.socketHandler(socket -> {
            final AtomicBoolean closed = new AtomicBoolean();
            socket.endHandler(v -> {
                closed.set(true);
                this.testComplete();
            });
            new Thread((SockJSSocket)socket){
                final /* synthetic */ SockJSSocket val$socket;
                {
                    this.val$socket = sockJSSocket;
                }

                @Override
                public void run() {
                    while (!closed.get()) {
                        LockSupport.parkNanos(50L);
                        try {
                            this.val$socket.write(Buffer.buffer((String)TestUtils.randomAlphaString((int)256)));
                        }
                        catch (IllegalStateException illegalStateException) {}
                    }
                }
            }.start();
        });
        this.client.websocket("/test/400/8ne8e94a/websocket", ws -> {
            AtomicInteger count = new AtomicInteger();
            ws.handler(msg -> {
                if (count.incrementAndGet() == 400) {
                    ws.close();
                }
            });
        });
        this.await();
    }
}

