/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web.handler;

import io.vertx.core.Handler;
import io.vertx.core.http.HttpMethod;
import io.vertx.ext.web.WebTestBase;
import io.vertx.ext.web.handler.TimeoutHandler;
import org.junit.Test;

public class TimeoutHandlerTest
extends WebTestBase {
    @Test
    public void testTimeout() throws Exception {
        long timeout = 500L;
        this.router.route().handler((Handler)TimeoutHandler.create((long)timeout));
        this.router.route().handler(rc -> {});
        this.testRequest(HttpMethod.GET, "/", 503, "Service Unavailable");
    }

    @Test
    public void testTimeoutWithCustomBodyEndHandler() throws Exception {
        long timeout = 500L;
        boolean[] ended = new boolean[]{false};
        this.router.route().handler(routingContext -> {
            routingContext.addBodyEndHandler(event -> {
                ended[0] = true;
            });
            routingContext.next();
        });
        this.router.route().handler((Handler)TimeoutHandler.create((long)timeout));
        this.router.route().handler(rc -> {});
        this.testRequest(HttpMethod.GET, "/", 503, "Service Unavailable");
        this.assertTrue(ended[0]);
    }

    @Test
    public void testTimeoutCancelled() throws Exception {
        long timeout = 500L;
        this.router.route().handler((Handler)TimeoutHandler.create((long)timeout));
        this.router.route().handler(rc -> rc.response().end());
        this.testRequest(HttpMethod.GET, "/", 200, "OK");
        Thread.sleep(1000L);
    }
}

