/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.web;

import io.vertx.core.http.HttpMethod;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.test.fakemetrics.FakeMetricsBase;
import io.vertx.test.fakemetrics.HttpServerMetric;
import io.vertx.test.fakemetrics.SocketMetric;
import io.vertx.test.fakemetrics.WebSocketMetric;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;

class FakeHttpServerMetrics
extends FakeMetricsBase
implements HttpServerMetrics<HttpServerMetric, WebSocketMetric, SocketMetric> {
    private final AtomicInteger seq = new AtomicInteger(0);
    private final AtomicInteger routed = new AtomicInteger(0);
    private String[] args;

    public void reset(String ... args) {
        this.seq.set(0);
        this.routed.set(0);
        this.args = args == null ? new String[]{} : args;
    }

    public HttpServerMetric requestBegin(SocketMetric socketMetric, HttpRequest request) {
        Assert.assertEquals((long)2L, (long)this.seq.incrementAndGet());
        return new HttpServerMetric(request, socketMetric);
    }

    public void requestEnd(HttpServerMetric requestMetric, HttpRequest request, long bytesRead) {
        Assert.assertEquals((long)5L, (long)this.seq.incrementAndGet());
        requestMetric.requestEnded.set(true);
        requestMetric.bytesRead.set(bytesRead);
    }

    public HttpServerMetric responsePushed(SocketMetric socketMetric, HttpMethod method, String uri, HttpResponse response) {
        HttpServerMetric requestMetric = new HttpServerMetric(uri, socketMetric);
        requestMetric.response.set(response);
        return requestMetric;
    }

    public void requestReset(HttpServerMetric requestMetric) {
        requestMetric.failed.set(true);
    }

    public void responseBegin(HttpServerMetric requestMetric, HttpResponse response) {
        Assert.assertEquals((long)3L, (long)this.seq.incrementAndGet());
        requestMetric.response.set(response);
    }

    public void responseEnd(HttpServerMetric requestMetric, HttpResponse response, long bytesWritten) {
        Assert.assertEquals((long)4L, (long)this.seq.incrementAndGet());
        requestMetric.responseEnded.set(true);
        requestMetric.bytesWritten.set(bytesWritten);
    }

    public SocketMetric connected(SocketAddress remoteAddress, String remoteName) {
        Assert.assertEquals((long)1L, (long)this.seq.incrementAndGet());
        return new SocketMetric(remoteAddress, remoteName);
    }

    public void disconnected(SocketMetric socketMetric, SocketAddress remoteAddress) {
        Assert.assertEquals((long)6L, (long)this.seq.incrementAndGet());
        socketMetric.connected.set(false);
    }

    public void bytesRead(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesRead.addAndGet(numberOfBytes);
        socketMetric.bytesReadEvents.add(numberOfBytes);
    }

    public void bytesWritten(SocketMetric socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        socketMetric.bytesWritten.addAndGet(numberOfBytes);
        socketMetric.bytesWrittenEvents.add(numberOfBytes);
    }

    public void exceptionOccurred(SocketMetric socketMetric, SocketAddress remoteAddress, Throwable t) {
    }

    public void requestRouted(HttpServerMetric requestMetric, String route) {
        Assert.assertEquals((Object)this.args[this.routed.getAndIncrement()], (Object)route);
        requestMetric.route.set(route);
    }
}

